package it.imolinfo.jbi4ejb.nbm;

import java.awt.Component;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class GetCorbaConfigurationlWizardPanel implements WizardDescriptor.Panel {

    /** The logger */
    private static final Logger LOG = Logger.getLogger(GetCorbaConfigurationlWizardPanel.class.getName());

    /**
     * The visual component that displays this panel. If you need to access the
     * component from this class, just use getComponent().
     */
    private GetCorbaConfigurationVisualPanel component;

    // Get the visual component for the panel. In this template, the component
    // is kept separate. This can be more efficient: if the wizard is created
    // but never displayed, or not all panels are displayed, it is better to  // create only those which really need to be visible.
    public Component getComponent() {
        if (component == null) {
            component = new GetCorbaConfigurationVisualPanel(this);
        }
        return component;
    }

    public HelpCtx getHelp() {
        // Show no Help button for this panel:
        return HelpCtx.DEFAULT_HELP;
        // If you have context help:
        // return new HelpCtx(SampleWizardPanel1.class);
    }

    /**
     * Valid if the getCorbaNameInserted is not null (it's changed)
     */
    public boolean isValid() {
        
        if (component.getCorbaNameInserted() != null) {            
            return true;
        }
        return false;        
    }



    private final Set<ChangeListener> listeners = new HashSet<ChangeListener>(1); // or can use ChangeSupport in NB 6.0

    public final void addChangeListener(ChangeListener l) {
        synchronized (listeners) {
            listeners.add(l);
        }
    }

    public final void removeChangeListener(ChangeListener l) {
        synchronized (listeners) {
            listeners.remove(l);
        }
    }

    protected final void fireChangeEvent() {
        Iterator<ChangeListener> it;
        synchronized (listeners) {
            it = new HashSet<ChangeListener>(listeners).iterator();
        }
        ChangeEvent ev = new ChangeEvent(this);
        while (it.hasNext()) {
            it.next().stateChanged(ev);
        }
    }


    // You can use a settings object to keep track of state. Normally the
    // settings object will be the WizardDescriptor, so you can use
    // WizardDescriptor.getProperty & putProperty to store information entered
    // by the user.
    public void readSettings(Object settings) {

        WizardDescriptor wd = (WizardDescriptor) settings;

        WsdlGeneratorContext gen = (WsdlGeneratorContext) wd.getProperty(WsdlGeneratorContext.WIZARD_DESCRIPTOR);
        
    }

    public void storeSettings(Object settings) {
        WizardDescriptor wd = (WizardDescriptor) settings;
        GetCorbaConfigurationVisualPanel comp = (GetCorbaConfigurationVisualPanel) getComponent();

        WsdlGeneratorContext gen = (WsdlGeneratorContext) wd.getProperty(WsdlGeneratorContext.WIZARD_DESCRIPTOR);

        if (gen == null) {
            gen = new WsdlGeneratorContext();
            wd.putProperty(WsdlGeneratorContext.WIZARD_DESCRIPTOR, gen);
        }

        if (GetCorbaConfigurationVisualPanel.OPT_CORBANAME.equalsIgnoreCase(comp.ejbLookupModeSelected)) {

            gen.setEjbLookupMode(WsdlGeneratorContext.EJBLOOKUP.CORBANAME);
            gen.setCorbaName(comp.getCorbaNameInserted());

            if (gen.getCorbaName() == null || "".equals(gen.getCorbaName())) {
                String msg = NbBundle.getMessage(GetCorbaConfigurationlWizardPanel.class, "MSG_NoCorbanameSpecified");
                LOG.warning(msg);
            }
        } else {
            gen.setEjbLookupMode(WsdlGeneratorContext.EJBLOOKUP.JNDI);
            gen.setCorbaName(null);
        }

        /* if the look up mode seleted is 'corba'
         * then we are talking about 'orb properties'
         * else we are talking about 'jndi properties'.
         */
        Map<String, String> map = comp.getPropertiesMap() == null ? new HashMap<String, String>() : comp.getPropertiesMap();
        gen.setEjbLookupProperties(map);
    }
}
