package org.netbeans.modules.worklist.dataloader;

import java.io.IOException;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.UniFileLoader;
import org.openide.util.NbBundle;

public class WorklistDataLoader extends UniFileLoader {
    
    public static final String REQUIRED_MIME = "text/x-wf";
    
    private static final long serialVersionUID = 1L;
    
    public WorklistDataLoader() {
        super("org.netbeans.modules.worklist.dataloader.WorklistDataObject");
    }
    
    protected String defaultDisplayName() {
        return NbBundle.getMessage(WorklistDataLoader.class, "LBL_Worklist_loader_name");
    }
    
    protected void initialize() {
        super.initialize();
        getExtensions().addMimeType(REQUIRED_MIME);
    }
    
    protected MultiDataObject createMultiObject(FileObject primaryFile) throws DataObjectExistsException, IOException {
        return new WorklistDataObject(primaryFile, this);
    }
    
    protected String actionsContext() {
        return "Loaders/" + REQUIRED_MIME + "/Actions";
    }
    
}
