/*
 * TaskDefinitionMultiViewElement.java
 * 
 * Created on May 24, 2007, 3:09:23 PM
 * 
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.netbeans.modules.worklist.editor.multiview.assignment;

import org.netbeans.modules.worklist.editor.multiview.assignment.AssignmentPanelFactory;
import org.netbeans.modules.worklist.editor.multiview.*;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import org.netbeans.modules.wlm.model.api.TTask;
import org.netbeans.modules.wlm.model.api.WLMModel;
import org.netbeans.modules.worklist.dataloader.WorklistDataObject;
import org.netbeans.modules.worklist.editor.view.nodes.AssignmentNode;
import org.netbeans.modules.xml.multiview.ToolBarMultiViewElement;
import org.netbeans.modules.xml.multiview.ui.SectionContainer;
import org.netbeans.modules.xml.multiview.ui.SectionContainerNode;
import org.netbeans.modules.xml.multiview.ui.SectionPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.multiview.ui.ToolBarDesignEditor;
import org.netbeans.modules.xml.validation.ValidateAction;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/**
 *
 * @author radval
 */
public class AssignmentMultiViewElement extends ToolBarMultiViewElement implements java.beans.PropertyChangeListener {

    private WorklistDataObject dObj;
    
    private SectionView view;
    private ToolBarDesignEditor comp;
    private AssignmentPanelFactory factory;
    private javax.swing.Action addAction, removeAction;
    private boolean needInit=true;
    private int index;
    private TaskSelectionModel taskSelectionModel;
    
    private TTask selectedTask;
    
    private RequestProcessor.Task repaintingTask;
   
    private static final String HELP_ID_PREFIX=WorklistDataObject.HELP_ID_PREFIX_ASSIGNMENT;
    
    
    
    public AssignmentMultiViewElement(final WorklistDataObject dObj, 
                                      int index,
                                      TaskSelectionModel taskSelectionModel) {
        super(dObj);
        this.dObj=dObj;
        this.index=index;
        this.taskSelectionModel = taskSelectionModel;
        this.selectedTask = this.taskSelectionModel.getSelectedTask();
        
         comp = new ToolBarDesignEditor();
        factory = new AssignmentPanelFactory(comp, dObj);
        addAction = new AddAction(dObj, NbBundle.getMessage(AssignmentMultiViewElement.class,"LBL_addServlet"));
        removeAction = new RemoveAction(NbBundle.getMessage(AssignmentMultiViewElement.class,"LBL_remove"));
        setVisualEditor(comp);
        view = new AssignmentView();
        comp.setContentView(view);
        repaintingTask = RequestProcessor.getDefault().create(new Runnable() {
            public void run() {
                javax.swing.SwingUtilities.invokeLater(new Runnable() {
                    public void run() {
                        repaintView();
                    }
                });
            }
        });
        
        initGUI();
    }

    private void initGUI() {
        dObj.getTaskSelectionModel().addTaskSelectionListner(new TaskSelectionAdapter());
        WLMModel model = dObj.getModel();
        JComponent toolbar = comp.getStructureView();
        if(toolbar instanceof JToolBar) {
            JToolBar tBar = (JToolBar) toolbar;
            tBar.add(new ValidateAction(model));
        }
    }
    
    public SectionView getSectionView() {
        return this.view;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        
    }
    
    private void repaintView() {
        
        Object lastActive = comp.getLastActive();
        if (lastActive!=null) {
            ((SectionView)view).openPanel(lastActive);
        } else {
            AssignmentView assignmentView = (AssignmentView)view;
            Node initialNode = assignmentView.getAssignmentNode();
            Children ch = initialNode.getChildren();
            if (ch.getNodesCount()>0) 
                initialNode = ch.getNodes()[0];
            assignmentView.selectNode(initialNode);
        }
        view.checkValidity();
        //ritdObj.checkParseable();
    }
    
    public void componentShowing() {
        super.componentShowing();
        dObj.setLastOpenView(index);
        if (needInit || !dObj.isDocumentParseable()) {
            repaintView();
            needInit = false;
        }
    }
    
    class AssignmentView extends SectionView {
        private SectionContainer servletsCont;
        private Node rootNode;
        
        AssignmentView () {
            super(factory);
            Children ch = new Children.Array();
            rootNode = new SectionContainerNode(ch);
                    
            TTask task = selectedTask;
            if(task != null) {
                String assignmentNodeDisplayName = "Assignment";
            
                AssignmentNode assignmentNode = new AssignmentNode(this, task.getAssignment(), assignmentNodeDisplayName);
                ch.add(new Node[] {assignmentNode});
            
                SectionContainer assignmentContainer = new SectionContainer(this, assignmentNode, assignmentNodeDisplayName, false);
                addSection(assignmentContainer);
                
                String[] userAndGroups = new String[] {EditorConstants.USERS_PANEL, EditorConstants.GROUPS_PANEL};
                Node[] nodes = new Node[userAndGroups.length];
                
                for (int i=0;i<nodes.length;i++) {
                    nodes[i] = new UsersNode(this, userAndGroups[i]);
                    rootNode.getChildren().add(new Node[] {nodes[i]});
                }
                //ch.add(nodes);

                /*
                servletsNode = new SectionContainerNode(ch);

                servletsCont = new SectionContainer(this,servletsNode,
                    NbBundle.getMessage(AssignmentMultiViewElement.class,"TTL_servlets"),false);
                servletsCont.setHeaderActions(new javax.swing.Action[]{addAction});

                Children servletsChildren = new Children.Array();
                servletsChildren.add(new Node[]{servletsNode});
                 */

                SectionPanel[] pan = new SectionPanel[userAndGroups.length];



                for (int i=0;i<nodes.length;i++) {
                    PanelKey key = new PanelKey(selectedTask, userAndGroups[i]);
                    pan[i] = new SectionPanel(this, nodes[i], userAndGroups[i], key);
                    //pan[i].setHeaderActions(new javax.swing.Action[]{removeAction});
                    //servletsCont.addSection(pan[i]);
                    assignmentContainer.addSection(pan[i]);
                }
            }
            /*
            addSection(servletsCont);
            //root.setDisplayName("<Servlets>");
            servletsNode.setDisplayName(NbBundle.getMessage(AssignmentMultiViewElement.class,"TTL_servlets"));
            servletsNode.setName(HELP_ID_PREFIX+"servletsNode"); //NOI18N
             */
            
                
            setRoot(rootNode);
        }
        
        Node getAssignmentNode() {
            return rootNode;
        }
        
        
        public org.netbeans.modules.xml.multiview.Error validateView() {
            org.netbeans.modules.xml.multiview.Error error = null;//getSectionView().getErrorPanel().getError();
//            if (error != null){
//                return error;
//            }
            
            TTask task = taskSelectionModel.getSelectedTask();
            if(task == null) {
                error = new org.netbeans.modules.xml.multiview.Error(org.netbeans.modules.xml.multiview.Error.ERROR_MESSAGE, "Select a task from overview section" , this);
            }
            
            return error;
            //ritreturn SectionValidator.validateServlets(webApp);
        }
    }
    
    
    private class UsersNode extends org.openide.nodes.AbstractNode {
        private SectionView view;
        UsersNode(SectionView view, String data) {
            super(org.openide.nodes.Children.LEAF);
            this.view=view;
            setDisplayName(data);
            setIconBaseWithExtension("org/netbeans/modules/worklist/dataloader/wait.gif"); //NOI18N
        }
        public HelpCtx getHelpCtx() {
            return new HelpCtx(HELP_ID_PREFIX+"servletNode"); //NOI18N
        }
    }
    
    private class GroupsNode extends org.openide.nodes.AbstractNode {
        private SectionView view;
        GroupsNode(SectionView view, String data) {
            super(org.openide.nodes.Children.LEAF);
            this.view=view;
            setDisplayName(data);
            setIconBaseWithExtension("org/netbeans/modules/worklist/dataloader/wait.gif"); //NOI18N
        }
        public HelpCtx getHelpCtx() {
            return new HelpCtx(HELP_ID_PREFIX+"servletNode"); //NOI18N
        }
    }
    
    
    private class AddAction extends javax.swing.AbstractAction {
        
        AddAction(final WorklistDataObject dObj, String actionName) {
            super(actionName);
            char mnem = NbBundle.getMessage(AssignmentMultiViewElement.class,"LBL_addServlet_mnem").charAt(0);
            putValue(MNEMONIC_KEY,new Integer((int)mnem));
        }
        public void actionPerformed(java.awt.event.ActionEvent evt) {
        }
    }
    
    private class RemoveAction extends javax.swing.AbstractAction {
        
        RemoveAction(String actionName) {
            super(actionName);
            char mnem = NbBundle.getMessage(AssignmentMultiViewElement.class,"LBL_remove_mnem").charAt(0);
            putValue(MNEMONIC_KEY,new Integer((int)mnem));
        }
        
        public void actionPerformed(java.awt.event.ActionEvent evt) {
        }
    }
    
    
    private class TaskSelectionAdapter implements TaskSelectionListener {

        public void taskSelected(TaskSelectionEvent evt) {
            TTask task = evt.getTask();
            selectedTask = task;
            view = new AssignmentView();
            comp.setContentView(view);
            view.checkValidity();
        }
        
        
    }
}
