/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Ralph Krueger.
 */

package org.netbeans.modules.changelog;


import java.util.*;

/**
 *
 * @author  Ralph Krueger
 */


public class SummaryProcessor {

    /** the max. number of top values.
     */
    private static final int MAX_LENGTH = 10;

    /** Holds value of property commitCount. */
    private int commitCount;

    /** Holds value of property userList. */
    private HashMap usersList;

    private HashMap mostChangedFilesMap;
    private HashMap activeUsersMap;

    /** Creates a new instance of SummaryProcessor */
    public SummaryProcessor() {
        usersList = new HashMap();
        commitCount = 0;
        mostChangedFilesMap = new HashMap();
    }

    
    public void processGroup(RevisionsGroup group) {
        String user = group.getUser();
        increaseCountByOne(usersList, user);
        commitCount = commitCount + 1;
        Iterator it = group.getList().iterator();
        while (it.hasNext()) {
            LogInfoRevision rev = (LogInfoRevision)it.next();
            increaseCountByOne(mostChangedFilesMap, 
                         rev.getLogInfoHeader().getRepositoryFilename());
            
        }
    }
    
    private void increaseCountByOne(Map map, Object key) {
        Integer val = (Integer)map.get(key);
        if (val == null) {
            val = new Integer(1);
        } else {
            val = new Integer(val.intValue() + 1);
        }
        map.put(key, val);
    }
    
    private List createSortedList(Map map) {
        Iterator it = map.keySet().iterator();
        LinkedList keyList = new LinkedList();
        LinkedList valList = new LinkedList();
        while (it.hasNext()) {
            Object key = it.next();
            Integer val = (Integer)map.get(key);
            Iterator valIt = valList.iterator();
            boolean wasSet = false;
            int valIndex = -1;
            while (valIt.hasNext()) {
                Integer val2 = (Integer)valIt.next();
                valIndex = valIndex + 1;
                if (val.compareTo(val2) >= 0) {
                    keyList.add(valIndex, key);
                    valList.add(valIndex, val);
                    wasSet = true;
                    break;
                }
            }
            if (!wasSet && keyList.size() < MAX_LENGTH) {
                keyList.add(key);
                valList.add(val);
            }
            if (keyList.size() >= MAX_LENGTH) {
                keyList.removeLast();
                valList.removeLast();
            }
        }
        return keyList;
    }
    
    /** Getter for property mostActiveUsers.
     * @return Value of property mostActiveUsers.
     */
    public String[] getMostActiveUsers() {
        List topList = createSortedList(usersList);
        String[] toReturn = new String[topList.size()];
        Iterator it = topList.iterator();
        int count = 0;
        while (it.hasNext()) {
            String item = (String)it.next();
            Integer num = (Integer)usersList.get(item);
            toReturn[count] = num.toString() + " " + item;
            count = count + 1;
        }
        return toReturn;
    }
    
    /** Getter for property mostChangedFiles.
     * @return Value of property mostChangedFiles.
     */
    public String[] getMostChangedFiles() {
        List topList = createSortedList(mostChangedFilesMap);
        String[] toReturn = new String[topList.size()];
        Iterator it = topList.iterator();
        int count = 0;
        while (it.hasNext()) {
            String item = (String)it.next();
            Integer num = (Integer)mostChangedFilesMap.get(item);
            toReturn[count] = num.toString() + " " + item;
            count = count + 1;
        }
        return toReturn;
    }    

    /** Getter for property commitCount.
     * @return Value of property commitCount.
     */
    public int getCommitCount() {
        return this.commitCount;
    }
    
    /** Getter for property userList.
     * @return Value of property userList.
     */
    public String[] getUserList() {
        String[] toReturn = new String[usersList.size()];
        toReturn = (String[])usersList.keySet().toArray(toReturn);
        return toReturn;
    }
    
}
