/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.exceptions.web.action;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionForward;
import org.netbeans.modules.exceptions.entity.Comment;
import org.netbeans.modules.exceptions.entity.Exceptions;
import org.netbeans.modules.exceptions.entity.Nbuser;
import org.netbeans.modules.exceptions.utils.LoggerUtils;
import org.netbeans.modules.exceptions.utils.PersistenceUtils;
/**
 *
 * @author Jan Horvath
 * @version
 */

public class DetailAction extends ExceptionsAbstractAction {
    
    /* forward name="success" path="" */
    private final static String SUCCESS = "success";
    private final static String LOGGER = "logger";
    
    /**
     * This is the action called from the Struts framework.
     * @param mapping The ActionMapping used to select this instance.
     * @param form The optional ActionForm bean for this request.
     * @param request The HTTP Request we are processing.
     * @param response The HTTP Response we are processing.
     * @throws java.lang.Exception
     * @return
     */
    public ActionForward execute(ActionMapping mapping, ActionForm  form,
            HttpServletRequest request, HttpServletResponse response)
            throws Exception {
        Integer id = null;
        Integer newduplicateof = null;
        Integer newissuezillaid = null;
        String component = request.getParameter("component");
        String subcomponent = request.getParameter("subcomponent");
        String comment = request.getParameter("comment");
        String username = request.getParameter("username");
        String duplicateof = request.getParameter("duplicateof");
        
        try {
            id = new Integer(request.getParameter("id"));
        } catch (NumberFormatException e) {
        }
        try {
            newduplicateof = new Integer(duplicateof);
        } catch (NumberFormatException e) {
        }
        try {
            newissuezillaid = new Integer(request.getParameter("issuezillaid"));
        } catch (NumberFormatException e) {
        }
        
        
        Exceptions exceptions = (Exceptions) PersistenceUtils.getInstance().getEntity(Exceptions.class, id);
        
        // make updates
        boolean merge = false;
        if ((newissuezillaid != null) && (exceptions !=null)) {
            exceptions.setIssuezillaid(newissuezillaid);
            exceptions.setIssueManChanged(true);
            merge = true;
        }
        
        if ((duplicateof != null) && (exceptions !=null)) {
            Exceptions duplExc = null;
            if (newduplicateof != null) {
                duplExc = (Exceptions) PersistenceUtils.getInstance().getEntity(Exceptions.class, newduplicateof);
            }
//            if (duplicateof != null) {
                exceptions.setDuplicateof(duplExc);
                exceptions.setDuplicateManChanged(true);
                merge = true;
//            }
        }
        
        if ((subcomponent != null) && (subcomponent.length() > 0) && (component != null) && (component.length() > 0)) {
            exceptions.setComponentAndSubcomponent(component, subcomponent);
            exceptions.setComponentManChanged(true);
            merge = true;
        }
        
        if ((comment != null) && (comment.length() > 0)) {
            Comment commentEntity = new Comment();
            commentEntity.setComment(comment);
            Principal p = request.getUserPrincipal();
            if (p != null) {
                System.err.println("** " + p.getName());
                Collection col = PersistenceUtils.getInstance().find(Nbuser.class,(Map) java.util.Collections.singletonMap("name", Collections.singletonList(p.getName())));
                if (!col.isEmpty()) {
                    Nbuser nbuser = (Nbuser) col.iterator().next();
                    commentEntity.setNbuserId(nbuser);
                }
                commentEntity.setExceptionId(exceptions);
                exceptions.getCommentCollection().add(commentEntity);
            }
            merge = true;
        }
        
        if (merge) {
            if (checkPrivileges(request)) {
                PersistenceUtils.getInstance().merge(exceptions);
            } else {
                return mapping.findForward(LOGIN);
            }
            
            response.sendRedirect("detail.do?id=" + exceptions.getId());
        }
        
        request.setAttribute("exceptions", exceptions);
        
        
        
        
        
        
        String logger = request.getParameter("logger");
        if ((logger != null) && (exceptions != null)) {
            //get logger
            H handler = new H();
            LoggerUtils.getLogRecord(exceptions.getLoggername(), handler);
            ArrayList lines = new ArrayList();
            for (Iterator<LogRecord> it = handler.nr.iterator(); it.hasNext();) {
                LogRecord record = it.next();
                lines.add(LoggerUtils.getLine(record));
            }
            request.setAttribute("logger",lines);
            return mapping.findForward(LOGGER);
        }
        
        request.setAttribute("components", PersistenceUtils.getInstance().getComponents().getComponentsSet());
        
        return mapping.findForward(SUCCESS);
        
    }
    
    class H extends Handler {
        public ArrayList<LogRecord> nr = new ArrayList<LogRecord>();
        
        public void publish(LogRecord arg0) {
            nr.add(arg0);
        }
        
        public void flush() {
        }
        
        public void close() throws SecurityException {
        }
        
    }
}
