/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * Portions Copyrighted 2007 Sun Microsystems, Inc.
 */
package org.netbeans.modules.php.rt.providers.impl.ftp.nodes;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.Action;
import org.netbeans.modules.php.rt.providers.impl.ftp.FtpHostImpl;
import org.netbeans.modules.php.rt.providers.impl.ftp.nodes.actions.RefreshAction;
import org.netbeans.modules.php.rt.resources.ResourceMarker;
import org.netbeans.modules.php.rt.spi.providers.Host;
import org.openide.actions.CustomizeAction;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

/**
 *
 * @author avk
 */
public class FileInfoNode extends AbstractNode {

    public FileInfoNode(FtpHostImpl host) {
        super(Children.LEAF, 
                createLookup(new FtpBaseObjectNodeChildren(), host));
        setChildren(getLookup().lookup(Children.class));
        initNode();
    }

    private void initNode(){
        Host host = getLookup().lookup(Host.class);

        String name = getNodeName(host);
        String description = getNodeDescription(host);

        setName("");
        setDisplayName(name);
        setIcon();
        setShortDescription(description);
    }

    private String getNodeName(Host host){
        String name = "";
        
        if (host instanceof FtpHostImpl) {
            FtpHostImpl ftpHost = (FtpHostImpl) host;
            name = "ftp://" + ftpHost.getProperty(FtpHostImpl.FTP_SERVER);
        }
        return name;
    }
    
    private String getNodeDescription(Host host){
        String description = "";
        
        if (host instanceof FtpHostImpl) {
            FtpHostImpl ftpHost = (FtpHostImpl) host;
            description = FtpHostImpl.Helper.getFtpUrl(ftpHost);
        }
        return description;
    }
    
    public void setIcon() {
        setIconBaseWithExtension(ResourceMarker.getLocation() + ResourceMarker.FILE_SERVER_ICON);
    }

    public void setErrorIcon() {
        setIconBaseWithExtension(ResourceMarker.getLocation() + ResourceMarker.FILE_SERVER_ERROR_ICON);
    }

    private void updateKeys() {
        new Thread() {
            public void run() {
                ((FtpBaseObjectNodeChildren) getChildren()).updateKeys();
            }
        }.start();
    }


    @Override
    public boolean hasCustomizer() {
        Node parent = getParentNode();
        if (parent != null) {
            return parent.hasCustomizer();
        }
        return false;
    }

    @Override
    public Component getCustomizer() {
        return getParentNode().getCustomizer();
    }

    @Override
    public Action[] getActions(boolean context) {
        
        ArrayList<Action> actionsList = new ArrayList();
        
        actionsList.addAll(Arrays.asList(ACTIONS));
        
        if (hasCustomizer()) {
            actionsList.add(SystemAction.get(CustomizeAction.class));
        }
        
        return actionsList.toArray(new Action[]{});
   }

    static Lookup createLookup(FtpBaseObjectNodeChildren children, FtpHostImpl host) {
        InstanceContent ic = new InstanceContent();

        if (host != null) {
            ic.add(host);
        }
        //if (pool != null) {
        //    ic.add(pool);
        //}
        ic.add(children);
        return new AbstractLookup(ic);
    }

    private static final Action[] ACTIONS = new Action[]{
        SystemAction.get(RefreshAction.class)
    };
}
