package org.netbeans.modules.web.jsf.navigation;

/*
 * PageFlowViewTest.java
 * NetBeans JUnit based test
 *
 * Created on May 7, 2007, 11:40 AM
 */
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Enumeration;
import java.util.List;
import junit.framework.*;
import org.netbeans.api.visual.action.PopupMenuProvider;
import org.netbeans.junit.*;
import org.netbeans.modules.web.jsf.api.facesmodel.FacesConfig;
import org.openide.filesystems.FileObject;
import org.openide.nodes.*;
import org.netbeans.modules.web.jsf.api.facesmodel.NavigationCase;
import org.netbeans.modules.web.jsf.api.facesmodel.NavigationRule;
import org.netbeans.modules.web.jsf.navigation.PageFlowController.TestAccessor;
import org.netbeans.modules.web.jsf.navigation.graph.PFObjectSceneListener;
import org.netbeans.modules.web.jsf.navigation.graph.PageFlowScene;
import org.netbeans.modules.web.jsf.navigation.graph.PageFlowSceneAccessor;
import org.netbeans.modules.web.jsf.navigation.graph.layout.FreePlaceNodesLayouter;
import org.openide.util.Exceptions;
import org.openide.util.lookup.Lookups;
import org.openide.util.test.MockLookup;

/**
 *
 * @author joelle
 */
public class PageFlowViewTest extends NbTestCase implements TestServices {

    final String zipPath;
    private PageFlowTestUtility tu;

    public PageFlowViewTest(String testName) {
        super(testName);
        zipPath = PageFlowViewTest.class.getResource("TestJSFApp.zip").getPath();

    }

    public static void main(java.lang.String[] args) {
        junit.textui.TestRunner.run(suite());
    }

    public static Test suite() {
        TestSuite suite = new NbTestSuite(PageFlowViewTest.class);
        return suite;
    }

    @Override
    protected boolean runInEQ() {
        return true;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        tu = new PageFlowTestUtility(this);
        tu.setUp(zipPath, "TestJSFApp");
        importantValuesNotNull();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        tu.tearDown();
        tu = null;
        view = null;
        scene = null;
        controller = null;
    }
    PageFlowView view;
    PageFlowScene scene;
    PageFlowController controller;

    public void importantValuesNotNull() throws InterruptedException {

        assertNotNull(tu.getProject());
        assertNotNull(tu.getJsfDO());
        assertNotNull(tu.getFacesConfig());
        assertNotNull(view = tu.getPageFlowView());
        assertNotNull(controller = tu.getController());
        assertNotNull(scene = tu.getScene());
    }

    public void testPageSetName() throws InterruptedException {
        Page firstPage = controller.createPage("FirstPage");
        Page secondPage = controller.createPage("SecondPage");
        view.createNode(firstPage, null, null);
        view.createNode(secondPage, null, null);

        NavigationCase navCase = controller.createLink(secondPage, firstPage, null);
        firstPage.setName("NewName");
        Collection<Page> pages = scene.getNodes();
        boolean found = false;
        for (Page page : pages) {
            if (page.getName().equals("NewName")) {
                /* It is weird that page.getDisplayName is not "NewName"... 
               * This may have worked more appropriately if I used the 
               * InlineTextEditor which probably sets the DisplayName. 
               * Not sure though */
                found = true;
                break;
            }

        }
        assertTrue(found);
    }

    public void testInitialPageCount() throws InterruptedException {
        FileObject webFolder = PageFlowView.getWebFolder(tu.getJsfDO().getPrimaryFile());
        int fileInWebFolderNum = webFolder.getChildren().length - 1; //Remove WEB-INF
        int dataNodePages = 0;
        Collection<Page> pages = scene.getNodes();
        for (Page page : pages) {
            if (page.isDataNode()) {
                dataNodePages++;
            }
        }
        assertTrue(dataNodePages == fileInWebFolderNum);
        assertTrue(pages.size() == 2);
    }

    public void testInitialCaseCount() throws InterruptedException {
        Collection<NavigationCaseEdge> edges = scene.getEdges();
        assert (edges.size() == 1);
    }

    public void testAdd2Pages() throws InterruptedException {
        String strFirstPage = "FirstPage";
        String strSecondPage = "SecondPage";

        Page firstPage = controller.createPage(strFirstPage);
        Page secondPage = controller.createPage(strSecondPage);

        view.createNode(firstPage, null, null);
        view.createNode(secondPage, null, null);

        Collection<Page> pages = scene.getNodes();
        boolean found1 = false;
        boolean found2 = false;
        for (Page page : pages) {
            if (page.getName().startsWith(strFirstPage)) {
                found1 = true;
            } else if (page.getName().startsWith(strSecondPage)) {
                found2 = true;
            }
        }
        assertTrue(found1);
        assertTrue(found2);

    }

    public void testAddLink() throws InterruptedException {
        Page firstPage = controller.createPage("FirstPage");
        Page secondPage = controller.createPage("SecondPage");

        view.createNode(firstPage, null, null);
        view.createNode(secondPage, null, null);
        
        Thread.sleep(5000);

        NavigationCase navCase = controller.createLink(firstPage, secondPage, null);
        Thread.sleep(5000);
        
        /* First Make sure it can be found in the faces Configuration */
        FacesConfig facesConfig = tu.getFacesConfig();
        List<NavigationRule> rules = facesConfig.getNavigationRules();
        boolean foundCase = false;
        for( NavigationRule rule : rules ){
            if( rule.getNavigationCases().contains(navCase) ) {
                foundCase = true;
            }
        }
        assertTrue (foundCase);
        

        Collection<NavigationCaseEdge> edges = scene.getEdges();
        boolean found = false;
        for (NavigationCaseEdge edge : edges) {
            Page srcPage = scene.getEdgeSource(edge).getPage();
            Page trgPage = scene.getEdgeTarget(edge).getPage();
            if (srcPage == firstPage && trgPage == secondPage) {
                found = true;
            }
        }
        assertTrue(found);

    }

    /* Unit Test 1 for Bug: 120355 */
    public void testSimiluateDeletePageThroughExplorer1() throws InterruptedException {
        try {

            int i_pageCount = TestAccessor.getAllRelevantFiles(controller).size();
            assertTrue(i_pageCount == 2);

            FileObject webFolder = PageFlowView.getWebFolder(tu.getJsfDO().getPrimaryFile());
            FileObject jspFile = webFolder.getFileObject("welcomeJSF", "jsp");
            jspFile.delete();
            Thread.sleep(3000);
            int e_pageCount = TestAccessor.getAllRelevantFiles(controller).size();
            assertTrue(i_pageCount == e_pageCount + 1);
        } catch (Exception ex) {
            Exceptions.printStackTrace(ex);
            fail();
        }
    }

    /* Unit Test 2 for Bug: 120355 */
    public void testSimiluateAddPageThroughExplorer2() throws InterruptedException, IOException {
        int i_pageCount = TestAccessor.getAllRelevantFiles(controller).size();


        FileObject webFolder = PageFlowView.getWebFolder(tu.getJsfDO().getPrimaryFile());
        webFolder.createData("newPage", "jsp");
        Thread.sleep(3000);
        int e_pageCount = TestAccessor.getAllRelevantFiles(controller).size();
        assertTrue(i_pageCount == e_pageCount - 1);

    }

    public void testMemoryLeaksOnScene() throws InterruptedException {
        PopupMenuProvider pnp = PageFlowSceneAccessor.getPopupMenuProvider(scene);
        FreePlaceNodesLayouter fpnl = PageFlowSceneAccessor.getFreePlaceNodesLayouter(scene);
        PFObjectSceneListener pfosl = PageFlowSceneAccessor.getPfObjectSceneListener(scene);


        WeakReference refPnp = new WeakReference(pnp);
        WeakReference refFpnl = new WeakReference(fpnl);
        WeakReference refPfosl = new WeakReference(pfosl);

        tu.closeFacesModel();


        Thread.sleep(3000);
        pnp = null;
        fpnl = null;
        pfosl = null;
        assertGC("PopupMenuProvider should no longer exist.", refPnp);
        assertGC("FreePlaceNodesLayouter should no longer exist.", refFpnl);
        assertGC("PFObjectSceneListener should no longer exist.", refPfosl);

    }

    /* This Test Currently Fails Do To Memory Leak 
    public void testMemoryLeakPageOnScene() throws InterruptedException {
        Thread.sleep(3000);
        PageFlowScene scene = PageFlowView.PFVTestAccessor.getPageFlowScene(tu.getPageFlowView());
        
        Collection<Page> pages = scene.getNodes();
        Collection<WeakReference> pageRefs = new ArrayList<WeakReference>();
        for ( Page page : pages ){
            pageRefs.add(new WeakReference(page));
        }
        
        tu.closeFacesModel();
        
        for(Page page : pages ){
            page = null;
        }
        for ( WeakReference pageRef : pageRefs ) {
            assertGC("Page has not be garbage collected.", pageRef);
        }
        
    }*/
    public void setupServices() {

        ClassLoader l = this.getClass().getClassLoader();
        MockLookup.setLookup(Lookups.fixed(l), Lookups.metaInfServices(l));
    }
}