/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.xslt.model.impl;

import java.util.List;

import javax.xml.namespace.QName;

import org.netbeans.modules.xslt.model.ApplyTemplateChild;
import org.netbeans.modules.xslt.model.ApplyTemplates;
import org.netbeans.modules.xslt.model.XslComponent;
import org.netbeans.modules.xslt.model.XslVisitor;
import org.w3c.dom.Element;


/**
 * @author ads
 *
 */
class ApplyTemplatesImpl extends SequenceElementImpl implements
        ApplyTemplates
{

    ApplyTemplatesImpl( XslModelImpl model, Element element ) {
        super( model , element );
    }
    
    ApplyTemplatesImpl( XslModelImpl model ) {
        super( model , XslElements.APPLY_TEMPLATES);
    }

    /* (non-Javadoc)
     * @see org.netbeans.modules.xslt.model.impl.XslComponentImpl#accept(org.netbeans.modules.xslt.model.XslVisitor)
     */
    @Override
    public void accept( XslVisitor visitor )
    {
        visitor.visit( this );
    }

    /* (non-Javadoc)
     * @see org.netbeans.modules.xslt.model.impl.XslComponentImpl#getComponentType()
     */
    @Override
    public Class<? extends XslComponent> getComponentType()
    {
        return ApplyTemplates.class;
    }

    /* (non-Javadoc)
     * @see org.netbeans.modules.xslt.model.ApplyTemplates#addChildElement(org.netbeans.modules.xslt.model.ApplyTemplateChild, int)
     */
    public void addChildElement( ApplyTemplateChild child, int position ) {
        insertAtIndex( CHILD_ELEMENTS, child , position );
    }

    /* (non-Javadoc)
     * @see org.netbeans.modules.xslt.model.ApplyTemplates#appendChildElement(org.netbeans.modules.xslt.model.ApplyTemplateChild)
     */
    public void appendChildElement( ApplyTemplateChild child ) {
        appendChild( CHILD_ELEMENTS, child);
    }

    /* (non-Javadoc)
     * @see org.netbeans.modules.xslt.model.ApplyTemplates#getChildrenElements()
     */
    public List<ApplyTemplateChild> getChildrenElements() {
        return getChildren( ApplyTemplateChild.class );
    }

    /* (non-Javadoc)
     * @see org.netbeans.modules.xslt.model.ApplyTemplates#removeChildElement(org.netbeans.modules.xslt.model.ApplyTemplateChild)
     */
    public void removeChildElement( ApplyTemplateChild child ) {
        removeChild( CHILD_ELEMENTS , child );
    }

    /* (non-Javadoc)
     * @see org.netbeans.modules.xslt.model.ModeSpec#getMode()
     */
    public QName getMode() {
        return QNameBuilder.createQName( this, XslAttributes.MODE );
    }

    /* (non-Javadoc)
     * @see org.netbeans.modules.xslt.model.ModeSpec#setMode(java.lang.String)
     */
    public void setMode( QName mode ) {
        setAttribute( XslAttributes.MODE, mode );
    }
    
}
