#ifdef HAVE_REGEX
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include <glib.h>

#include "re.h"
#include "nls.h"
#include "nscache.h"

void re_free(ree)
re_entry *ree;
{
#ifdef HAVE_POSIX_REGEX
	regfree(&(ree->preg));
#endif
#ifdef HAVE_V8_REGEX
	free(ree->preg);
#endif
#ifdef HAVE_GNU_REGEX
	regfree(&(ree->preg));
#endif
#ifdef HAVE_PCRE_REGEX
	free(ree->preg);
	free(ree->preg_extra);
#endif
	g_free(ree->pattern);
	g_free(ree);
}

re_entry *re_make(str)
char *str;
{
	char errmsg[4096];
	int ec;
	re_entry *rv;
#if defined(HAVE_BSD_REGEX) || defined(HAVE_GNU_REGEX) || defined(HAVE_PCRE_REGEX)
	char *p;
#endif

	rv = g_malloc(sizeof(re_entry));

#ifdef HAVE_POSIX_REGEX
	if ((ec = regcomp(&(rv->preg) , str , REG_EXTENDED)))
	{
		char pom[2048];

		sprintf(errmsg, gettext("Error compiling regular expression : %s\n") , str);
		regerror(ec , &(rv->preg) , pom , sizeof(pom));
		strcat(errmsg, " - ");
		strcat(errmsg, pom);
		gui_err(errmsg);
		regfree(&(rv->preg));
		g_free(rv);
		rv = NULL;
	}
#endif
#ifdef HAVE_V8_REGEX
	if (!(rv->preg = regcomp(str)))
	{
		sprintf(errmsg, gettext("Error compiling regular expression : %s\n") , str);
		gui_err(errmsg);
		g_free(rv);
		rv = NULL;
	}
#endif
#ifdef HAVE_BSD_REGEX
	if ((p = re_comp(str)))
	{
		sprintf(errmsg, gettext("Error compiling regular expression : %s\n") , str);
		strcat(errmsg, " - ");
		strcat(errmsg, p);
		gui_err(errmsg);
		g_free(rv);
		rv = NULL;
	}
#endif
#ifdef HAVE_GNU_REGEX
	rv->preg.allocated = 0;
	rv->preg.buffer = NULL;
	rv->preg.fastmap = NULL;

	if ((p = re_compile_pattern(str, strlen(str) , &rv->preg)))
	{
		sprintf(errmsg, gettext("Error compiling regular expression : %s\n") , str);
		strcat(errmsg, " - ");
		strcat(errmsg, p);
		gui_err(errmsg);
		regfree(&(rv->preg));
		g_free(rv);
		rv = NULL;
	}

#endif
#ifdef HAVE_PCRE_REGEX
	if ((rv->preg = pcre_compile(str, 0, (const char **)&p, &ec, NULL)))
	{
		rv->preg_extra = pcre_study(rv->preg, 0, (const char **)&p);
	}

	if (!rv->preg)
	{
		sprintf(errmsg, gettext("Error compiling regular expression : %s\n") , str);
		strcat(errmsg, " - ");
		strcat(errmsg, p);
		gui_err(errmsg);
		g_free(rv);
		rv = NULL;
	}
#endif
	else
		rv->pattern = g_strdup(str);

	return rv;
}

int re_pmatch(ree, str)
re_entry *ree;
char *str;
{
#ifdef HAVE_POSIX_REGEX
	return !regexec(&(ree->preg) , str , 0 , NULL , 0);
#endif
#ifdef HAVE_V8_REGEX
	return regexec(ree->preg , str);
#endif
#ifdef HAVE_BSD_REGEX
	re_comp(ree->pattern);
	return re_exec(str);
#endif
#ifdef HAVE_GNU_REGEX
	return re_match(&(ree->preg), str, strlen(str), 0, NULL) >= 0;
#endif
#ifdef HAVE_PCRE_REGEX
	return pcre_exec(ree->preg, ree->preg_extra, str, strlen(str), 0, 0, NULL, 0) >= 0;
#endif
}

#endif

