/***************************************************************************/
/* 		This code is part of Nscache - viewer of Netscape(tm)	   */
/*		browsers disc cache					   */
/*		Copyright (c) 1999,2000 Ondrejicka Stefan		   */
/*		(ondrej@idata.sk)					   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#include <stdio.h>
#include <glib.h>
#include <string.h>
#include <unistd.h>
#ifdef HAVE_GETOPT_LONG
#include <getopt.h>
#else
#include "getopt.h"
#endif

#include "apassign.h"
#include "nls.h"
#include "gaccel.h"
#include "gprop.h"
#include "indexdb.h"
#include "nscache.h"

enum {
	NSC_VIEWER,
	NSC_INDEXDB,
	NSC_MENUACCEL ,
	NSC_PROP ,
	NSC_LAST
};

struct rc_terms {
	char *name;
	int id;
};

static struct rc_terms cfgrc[] = {
	{"Viewer:", NSC_VIEWER},
	{"IndexDB:", NSC_INDEXDB},
	{"MenuAccel:", NSC_MENUACCEL},
	{"Property:", NSC_PROP}
};

char *get_1qstr(str)
char *str;
{
	static char *p = NULL;
	char *pom1 = NULL , *pom2 = NULL;
	int found;

	if (str) p = str;

	for ( ; p && *p && (!pom1 || !pom2) ; p++)
	{
		found = FALSE;

		if (*p == '\"')
		{
			if ((p == str) || (*(p-1) != '\\'))
				found = TRUE;
		}

		if (!pom1 && found)
			pom1 = p+1;
		else if (!pom2 && found)
			pom2 = p;
	}
	if (pom1 && pom2)
	{
		*pom2 = '\0';
		return pom1;
	}
	else
	{
		p = NULL;
		return NULL;
	}
}

char *escape_str(str , unsafe)
char *str;
char *unsafe;
{
	char sbuf[2048];
	char *p,*r;

	for (p = str, r = sbuf ; *p ; p++)
	{
		if (strchr(unsafe, *p))
		{
			*r = '\\';
			r++;
			*r = *p;
			r++;
		}
		else
		{
			*r = *p;
			r++;
		}
	}
	*r = '\0';
	return g_strdup(sbuf);
}

void load_rc()
{
	char pom[2048];
	FILE *f;
	char *line;
	int found = FALSE;
	int i;

	sprintf(pom, "%s/.nscacherc" , g_get_home_dir());

	f = fopen(pom , "r");

	if (!f) return;

	while((line = fgets(pom, sizeof(pom) , f)))
	{
		if (*line == '#') continue;
		if (!strcspn(line , " \t\r\n")) continue;

		found = FALSE;
		for (i = 0 ; i < NSC_LAST ; i++)
		{
			if (!strncasecmp(cfgrc[i].name, line , strlen(cfgrc[i].name)))
			{
				found = TRUE;
				break;
			}
		}
		if (!found)
			fprintf(stderr, gettext("Unable to parse: \"%s\"\n"), line);
		else
		{
			line += strlen(cfgrc[i].name);
			line += strspn(line , "\t ");
			*(line + strcspn(line,"\n\r")) = '\0';
			switch(cfgrc[i].id)
			{
				case NSC_VIEWER:
				{
					apassign *ad = g_malloc(sizeof(apassign));

					ad->mimetype = g_strdup(get_1qstr(line));
					ad->fapplication = g_strdup(get_1qstr(NULL));
					ad->uapplication = g_strdup(get_1qstr(NULL));
					if (!*ad->fapplication)
					{
						g_free(ad->fapplication);
						ad->fapplication = NULL;
					}
					if (!*ad->uapplication)
					{
						g_free(ad->uapplication);
						ad->uapplication = NULL;
					}

					apassign_data = g_slist_append(apassign_data, ad);
				}
				break;
				case NSC_INDEXDB:
				{
					int l;

					l = strcspn(line , "\r\n");
					if (l) db_name = g_strndup(line , l);
				}
				break;
				case NSC_MENUACCEL:
				{
					gaccel *ga;

					if ((ga = gaccel_parse_str((guchar *)line)))
					{
						gaccel_add(ga);
					}
					else
						printf(gettext("Unable to parse: \"%s\"\n"), line); 
				}
				break;
				case NSC_PROP:
				{
					gprop *gp;

					if ((gp = gprop_parse(line)))
					{
						gprop_add(gp);
					}
					else
						printf(gettext("Unable to parse: \"%s\"\n"), line); 
				}
				break;
				default:
				break;
			}
		}
	}
	fclose(f);
}

void save_rc()
{
	char pom[2048];
	GSList *ptr;
	FILE *f;

	sprintf(pom , "%s/.nscacherc" , g_get_home_dir());

	f = fopen(pom , "w+");

	if (!f)
	{
		gui_err(gettext("Unable to open ~/.nscacherc file"));
		return;
	}

	fprintf(f, gettext("# This .nscacherc file was generated by nscache\n# You may edit it if you're careful!\n\n"));


	if (db_name)
		fprintf(f , "%s %s\n\n", cfgrc[NSC_INDEXDB].name , db_name);

	ptr = apassign_data;
	while(ptr)
	{
		apassign *ad = (apassign *)ptr->data;
		char *mt,*fv,*uv;

		mt = escape_str(ad->mimetype , "\\\"");
		fv = ad->fapplication ? escape_str(ad->fapplication , "\\\"") : g_strdup("");
		uv = ad->uapplication ? escape_str(ad->uapplication , "\\\"") : g_strdup("");
		fprintf(f , "%s \"%s\" \"%s\" \"%s\"\n" , cfgrc[NSC_VIEWER].name, mt, fv, uv);
		g_free(mt);
		g_free(fv);
		g_free(uv);
		ptr = ptr->next;
	}

	gaccel_save_keys(f);
	gprop_save(f);

	fclose(f);
	
}

static void usage(prgname)
char *prgname;
{
	printf(gettext("Usage: %s [OPTION]\n"), prgname);
	printf(gettext("  -f,  --db_file=FILENAME  set cache file to FILENAME\n"));
	printf(gettext("  -l,  --list              list cache directory contents to stdout\n"));
	printf(gettext("  -m,  --multi-line        print multi line info about each cache entry\n"
		       "                           listing when listing cache content\n"));
	printf(gettext("  -s,  --short             print short listing when listing cache content\n"));
	printf(gettext("  -v,  --version           display version information and exit\n"));
	printf(gettext("  -h,  --help              display this help and exit\n"));
	exit(0);
}

int cmd_setup(argc,argv)
int argc;
char **argv;
{
	char pom[2048];
	int short_list = TRUE;
	int just_list = FALSE;
	int c;
	int index;
	struct option options[] =
	{
		{"db_file", 1, NULL, 'f'},
		{"list", 0, NULL, 'l'},
		{"width", 0, NULL, 'w'},
		{"multi-line", 0, NULL, 'm'},
		{"short", 0, NULL, 's'},
		{"help", 0, NULL, 'h'},
		{"version", 0, NULL, 'v'},
		/* !!! GTK/GDK options below !!! */
		{"gtk-module", 1, NULL, 'g'},
		{"g-fatal-warnings", 0, NULL, 'g'},
		{"gtk-debug", 1, NULL, 'g'},
		{"gtk-no-debug", 1, NULL, 'g'},
		{"gdk-debug", 1, NULL, 'g'},
		{"gdk-no-debug", 1, NULL, 'g'},
		{"display", 1, NULL, 'g'},
		{"sync", 0, NULL, 'g'},
		{"no-xshm", 0, NULL, 'g'},
		{"name", 1, NULL, 'g'},
		{"class", 1, NULL, 'g'},
		{"gxid_host", 1, NULL, 'g'},
		{"gxid_port", 1, NULL, 'g'},
		{"xim-preedit", 1, NULL, 'g'},
		{"xim-status", 1, NULL, 'g'},
		{NULL, 0, NULL, 0}
	};

	for (;;)
	{
		c = getopt_long(argc, argv, "vhlsmf:", options, &index);
		if (c == -1) break;
		/*if (!c) c = options[index].val;*/
		switch (c)
		{
			case 'v':
				printf("%s-%s\n", PACKAGE, VERSION);
				exit(0);
			break;
			case 'h':
				usage(argv[0]);
			break;
			case 'f':
				db_name = g_strdup(optarg);
			break;
			case 'l':
				just_list = TRUE;
			break;
			case 'm':
				short_list = FALSE;
			break;
			case 's':
				short_list = TRUE;
			break;
			case 'g':
			break;
			default:
				return -1;
		}
	}

	if (optind < argc)
	{
		fprintf(stderr, gettext("Illegal argument: %s\n"), argv[optind]);
		return -1;
	}

	if (!db_name)
	{
		char *p;

		if ((p = g_get_home_dir()))
		{
			sprintf(pom , "%s/.netscape/cache/index.db" , p);
			db_name = g_strdup(pom);
		}
	}

	if (just_list)
	{
		if (!db_name)
		{
			fprintf(stderr, gettext("Cache file not specified!\n"));
			exit(1);
		}
		if (ns_cache_open_db(db_name))
		{
			sprintf(pom , gettext("Error opening cache index file : %s"), db_name);
			perror(pom);
			exit(2);
		}
		ns_cache_dump(short_list);
		ns_cache_close_db();
		exit(0);
	}

	return 0;
}

