// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/arch/ia32/base_natives/java_lang_thread_ia32.cpp,v 1.3 2001/11/20 11:06:08 xli18 Exp $
//


#include "platform.h"
#include <assert.h>
#include <iostream.h>

#ifndef ORP_POSIX
#include "orp_process.h"
#endif

#include "environment.h"
#include "orp_types.h"
#include "orp_utils.h"
#include "object_layout.h"
#include "Class.h"
#include "orp_threads.h"

#ifdef OBJECT_LOCK_V2
#include "thread_generic_olv2.h"
#else
#include "thread_generic.h"
#endif

///////////////
/////////////// WARNING: start_of_thread_busybit_critical_zone() MUST BE  THE FIRST
///////////////
/////////////// PROCEDURE IN java_lang_thread_ia32.cpp
///////////////
///////////////////////////////////////////////////////////////////////////////


void start_of_thread_ia32_busybit_critical_zone()
{
////////////// THIS MUST BE THE FIRST PROCEDURE IN java_lang_Object.cpp
////////////// SEE in_busybit_critical_zone() for details
}


void setup_gc_frame_context()
{
	memset(&(p_TLS_orpthread->gc_frame_context), 0, sizeof(p_TLS_orpthread->gc_frame_context) );
	p_TLS_orpthread->gc_frame_context.ljf = (uint32)p_TLS_orpthread->get_last_java_frame();
	p_TLS_orpthread->gc_frame_context.p_eip = &(p_TLS_orpthread->gc_frame_context_eip_var);
    assert(p_TLS_orpthread->gc_frame_context.ljf != 0);

}

void setup_floating_point_state(int *p_old_floating_point_state)
{
    int old_floating_point_state = 0;
    int floating_point_temp = 0;
#ifdef ORP_NT
    __asm {
        // the below set the significand to 53 bits for doubles
        // this is "non-strict" mode i.e., not Java Spec compliant
        fnstcw WORD PTR [old_floating_point_state]
        fnstcw WORD PTR [floating_point_temp]
        and DWORD PTR[floating_point_temp], 0feffH
        or DWORD PTR [floating_point_temp], 0200H
        fldcw WORD PTR [floating_point_temp] 
    }
#else
    //assert(0);
#endif
    *p_old_floating_point_state = old_floating_point_state;
}


void cleanup_floating_point_state(int old_floating_point_state)
{
#ifdef ORP_NT
     __asm {
        fldcw WORD PTR [old_floating_point_state] 
    }
#else
    // assert(0);
#endif
}

///////////////////////////////////////////////////////////////////////////////
///////////////
/////////////// WARNING: end_of_thread_busybit_critical_zone() MUST BE  THE LAST
///////////////
/////////////// PROCEDURE (excepting in_busybit_critical_zone) IN java_lang_thread_ia32.cpp
///////////////
///////////////////////////////////////////////////////////////////////////////

void end_of_thread_ia32_busybit_critical_zone()
{
////////////// THIS MUST BE THE LAST PROCEDURE IN java_lang_Thread.cpp
////////////// SEE in_busybit_critical_zone() for details
}



bool in_busybit_critical_zone(ORP_thread *p_thr)
{
    // reason for existence:  if a thread that is holding the busybit of
    // a java object is suspended, a second thread that is trying to acquire
    // the busybit on the same java object will then be deadlocked.
    // this procedure is used as a mechanism to flush a given thread OUT of
    // a busybit_critical_zone.
    //
    // An alternative (and far simpler) approach is to put an
    // EnterCriticalSection() at the top of all the following procedures.  This
    // causes two performance problems:  a) slows down monitor_enter()/exit()
    // which are already high overhead calls
    // and b) single threads all monitor_enter()/exit()'s --- not a good idea
    // on an SMP box.

    if (p_thr->app_status != thread_is_running) return false;

    CONTEXT nt_registers;

    memset( &nt_registers, 0, sizeof(CONTEXT) );

    nt_registers.ContextFlags = //  CONTEXT_DEBUG_REGISTERS |
                                //  CONTEXT_FLOATING_POINT |
                                //  CONTEXT_SEGMENTS |
                                //  CONTEXT_INTEGER |
                                    CONTEXT_CONTROL ;

    BOOL stat = GetThreadContext(p_thr->thread_handle, &nt_registers);

    if( (nt_registers.Eip > (unsigned long)start_of_object_busybit_critical_zone)  &&
        (nt_registers.Eip < (unsigned long)end_of_object_busybit_critical_zone)  )

        return true;
    
    if( (nt_registers.Eip > (unsigned long)start_of_thread_busybit_critical_zone)  &&
        (nt_registers.Eip < (unsigned long)end_of_thread_busybit_critical_zone)  )

        return true;

    if( (nt_registers.Eip > (unsigned long)start_of_thread_ia32_busybit_critical_zone)  &&
        (nt_registers.Eip < (unsigned long)end_of_thread_ia32_busybit_critical_zone)  )

        return true;

    if( (nt_registers.Eip > (unsigned long)start_of_thread_manager_busybit_critical_zone)  &&
        (nt_registers.Eip < (unsigned long)end_of_thread_manager_busybit_critical_zone)  )

        return true;

//    if (stat == 0) {
//        DWORD err1 = GetLastError();
//        orp_cout << "busybit critical zone problem err1 = " << err1 << endl;
//    }
//    assert(stat);


    return false;
}
