// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/arch/ia32/ia32_o3_jit/bit_vector_group.cpp,v 1.2 2001/08/13 09:54:55 xhshi Exp $
//

#include "defines.h"
#include <assert.h>
#include "bit_vector_group.h"

void Bit_Vector_Group_GC_jsr::mark_live(unsigned varno, O3_Jit_Type type)
{
    _dead->reset(varno);
    switch (type)
    {
    case JIT_TYPE_ARRAY:
    case JIT_TYPE_CLASS:
        _refs->set(varno);
        _nonrefs->reset(varno);
        _unknown->reset(varno);
        break;
    case JIT_TYPE_UNKNOWN: // spill location
        _refs->reset(varno);
        _nonrefs->reset(varno);
        _unknown->set(varno);
        break;
    default:
        _refs->reset(varno);
        _nonrefs->set(varno);
        _unknown->reset(varno);
        break;
    }
}

void Bit_Vector_Group_GC_jsr::merge_incoming(Bit_Vector_Group *incoming_in, Bit_Vector *scratch,
                                             MergeType mt)
{
    if (incoming_in == NULL)
        return;

    Bit_Vector_Group_GC_jsr *incoming = (Bit_Vector_Group_GC_jsr *) incoming_in;
    switch (mt)
    {
    case merge_jsr:
        // Assume that "this" is already initialized to be a copy of the liveness
        // information at the jsr target, and that "incoming" corresponds to the
        // successor of the jsr instruction.
        scratch->intersect_two(_unknown, incoming->_refs);
        _refs->union_from(scratch);

        scratch->intersect_two(_unknown, incoming->_nonrefs);
        _nonrefs->union_from(scratch);

        scratch->intersect_two(_unknown, incoming->_dead);
        _dead->union_from(scratch);

        // _unknown must be processed last, because its prior value is used above.
        _unknown->intersect_from(incoming->_unknown);
        break;
    case merge_ret:
        _refs->intersect_from(incoming->_refs);
        _nonrefs->intersect_from(incoming->_nonrefs);
        _dead->intersect_from(incoming->_dead);
        break;
    case merge_default:
        scratch->union_two(incoming->_refs, incoming->_dead);
        _refs->intersect_from(scratch);

        scratch->union_two(incoming->_nonrefs, incoming->_dead);
        _nonrefs->intersect_from(scratch);

        _dead->intersect_from(incoming->_dead);
        break;
    }
}

void Bit_Vector_Group_GC_jsr::fixup_final(MergeType mt)
{
    switch (mt)
    {
    case merge_jsr:
        break;
    case merge_ret:
        _unknown->subtract(_refs);
        _unknown->subtract(_nonrefs);
        _unknown->subtract(_dead);
        break;
    case merge_default:
        _refs->   subtract(_dead);
        _nonrefs->subtract(_dead);
        _unknown->subtract(_refs);
        _unknown->subtract(_nonrefs);
        _unknown->subtract(_dead);
        break;
    }
}

void Bit_Vector_Group_GC_nojsr::mark_live(unsigned varno, O3_Jit_Type type)
{
    _dead->reset(varno);
    switch (type)
    {
    case JIT_TYPE_ARRAY:
    case JIT_TYPE_CLASS:
        _refs->set(varno);
        _nonrefs->reset(varno);
        break;
    case JIT_TYPE_UNKNOWN: // spill location
        _refs->reset(varno);
        _nonrefs->reset(varno);
        //_unknown->set(varno);
        break;
    default:
        _refs->reset(varno);
        _nonrefs->set(varno);
        break;
    }
}

void Bit_Vector_Group_GC_nojsr::merge_incoming(Bit_Vector_Group *incoming_in, Bit_Vector *scratch,
                                               MergeType mt)
{
    if (incoming_in == NULL)
        return;

    Bit_Vector_Group_GC_nojsr *incoming = (Bit_Vector_Group_GC_nojsr *) incoming_in;
    switch (mt)
    {
    case merge_jsr:
    case merge_ret:
        assert(0);
        break;
    case merge_default:
        _refs->union_from(incoming->_refs);
        _nonrefs->union_from(incoming->_nonrefs);
        _dead->intersect_from(incoming->_dead);
        break;
    }
}

void Bit_Vector_Group_GC_nojsr::fixup_final(MergeType mt)
{
}

unsigned Bit_Vector_Group_Elim::num_live()
{
    return _dead->numbits() - _dead->bits_set();
}

#if 0
void Bit_Vector_Group_Elim::fill_in_live_array(unsigned *array)
{
    unsigned cur = 0;
    unsigned i;
    for (i=0; i<_dead->numbits(); i++)
    {
        if (!_dead->is_set(i))
            array[cur++] = i;
    }
}
#endif // 0
