// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/base_natives/gnu_classpath/gnu_classpath_jni_utils.cpp,v 1.3 2002/01/09 03:28:37 gwu2 Exp $
//


#include "platform.h"
#include "Class.h"
#include "Class_Loader.h"
#include "ini.h"

#include "jni_utils.h"
#include "jni_direct.h"
#include "orp_utils.h"
#include "environment.h"
#include "exceptions.h"



/* Utility function for throwing exceptions from JNI
 */

void throw_exception_from_jni(JNIEnv *jenv, const char *exc, const char *msg)
{
	//??jclass exclazz = jenv->FindClass(exc);
	// wgs: I wonder if context class loader is always correct here, if not, must always
	//  let current class loader be transferred as a parameter
	jclass exclazz = FindClassWithContextClassLoader(exc);
	assert(exclazz);

    // Clear pending exceptions
    if (jenv->ExceptionOccurred())
        jenv->ExceptionClear();

	jint result = jenv->ThrowNew(exclazz, msg);
} // throw_exception_from_jni

