// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/gc_v2/gc_debug.cpp,v 1.6 2002/01/11 15:47:38 weldon Exp $
//

#include "platform.h"

#include "gc_space.h"
#include "remembered_set.h"
#include "block_store.h"
#include "card_table.h"
#include "descendents.h"
#include "gc_hooks.h"
#include "generation.h"
#include "nursery_step_gen.h"
#include "car.h"
#include "train.h"
#include "obsolete_space.h"
#include "Class.h"
#ifdef _DEBUG
// If GC_DEBUG is 0 then this is an inline empty latency free routine..

// We have a selection of 4 objects that are normally NULL.
// If we want to trace an object we set the address of one
// of the objectn to the object we want to trace.
void *object1 = (void *)0x0 ; // 166f490; //0x01c5a928; 
void *object2 = (void *)0x0 ; // The object holding the slot pointing to 13e9144 .
void *object3 = (void *)0x0 ; // object is moved from step into oldest car during gc 1 a YOS gc.
void *object4 = (void *)0x0 ; // The object pointing to the object with the slot pointing to the array...

// This is called from a lot of places and if the object passed in
// and non-NULL and equal one of the objects being traced then
// string_x is printed out along with the object. 
void gc_trace (void *object, const char *string_x)
{
    // The NULL object is not interesting
    if (!object) {
        return;
    }
    if ((object==object1)||(object==object2)||(object==object3)||(object==object4)) {
        orp_cout << " GC Trace " << object << " " << string_x << endl;
        if (((Java_java_lang_Object *)object)->vt) {
            // Sometimes the JIT doesn't give us the base so be careful
            orp_cout << " The vt is " << ((Java_java_lang_Object *)object)->vt << endl;
            orp_cout << " The class is " << ((VTable *)((Java_java_lang_Object *)object)->vt)->clss << endl;
        } else {
            // On IA32, some of the JITs don't pass the base of the object instead
            // they pass the slot. This is not what the interface says but for historical 
            // reasons (Changing the JIT would require too much effort) this has not
            // been done.
            orp_cout << " This object has a null vtable, it might be broken." << endl;
        }
    }
    return;
}


void **object_slot1 = (void **)0x0;
void **object_slot2 = (void **)0x0;
void **object_slot3 = (void **)0x0;
void **object_slot4 = (void **)0x0;
void **object_slot5 = (void **)0x0;
void gc_trace_slot (void **object_slot, void *object, const char *string_x) {
    
    if ((object_slot==object_slot1)||(object_slot==object_slot2)||(object_slot==object_slot3)
        ||(object_slot==object_slot4)||(object_slot==object_slot5)) {
        orp_cout << " GC Slot Trace " << object_slot << " with value " << object << " " << string_x << endl;
    }
    return;
}

block_info *block1 = (block_info *)0x0;
block_info *block2 = (block_info *)0x0;
block_info *block3 = (block_info *)0x0;
block_info *block4 = (block_info *)0x0;

void gc_trace_block (void *the_block, const char *string_x) {
    assert (the_block);
    if (((block_info *)the_block == block1) || ((block_info *)the_block == block2) || 
        ((block_info *)the_block == block3) || ((block_info *)the_block == block4)) {
        orp_cout << (void *)the_block << " " << string_x  << "------ block trace --------" << endl;
    }
}

#endif // (GC_DEBUG>0) 
//
// This API can be called at debug time by the ORP to determine
// if the specified reference is to a live, valid Java object.
// The answer is approximate, however, since live objects can
// take the places of previous dead objects. (I.e. the response
// may occasionally mislead the ORP.)
//
bool is_valid_java_object(Java_java_lang_Object *p_obj_ref)
{
	//
	// Finally the acid test. We can tell definitively if
	// this is an object by checking to see if the VTable
	// pointer is to a known VTable. (We maintain a database
	// of valid VTable pointers in the class loader code.)
	//
	if (is_java_object(p_obj_ref)) {
		return true;
	}

	return false;
}

// end file gc_space.cpp


