// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/include/Loader_Result.h,v 1.2 2001/08/02 01:34:00 Michal Exp $
//



#ifndef include_loader_result_h
#define include_loader_result_h
    
//
// class loader error conditions
//
enum Loader_Result {
	LD_OK,
	LD_ParseError,	// parse error occured
	LD_ConstPoolError,	// bad constant pool format
};
//
// class loader exceptions -- see pg 611 of the language definition to see list
// of exceptions
//
// see pg 39 of the JVM spec for an overview of the LinkageError exceptions
// see pg 45 of the JVM spec for an overview of the 
// IncompatibleClassChangeError exceptions
//
// Error
//   LinkageError
//     ClassCircularityError		Loader
//	   ClassFormatError				Loader
//	   NoClassDefFoundError			Loader
//	   IncompatibleClassChangeError			Linker				pg 45
//       AbstractMethodError						Preperation
//		 IllegalAccessError					Linker
//		 InstantiationError					Linker
//		 NoSuchFieldError					Linker
//		 NoSuchMethodError					Linker
//     UnsatisfiedLinkError									
//     VerifyError
//
// IncompatibleClassChangeError exceptions
//
// IllegalAccessError occurs when a a field, method or class reference 
// occurs and the referenced field (method) is private, protected or not public
// or the accessed class is not public.
//
// InstantiationError occurs when an interface or abstract class is 
// being instantiated by the byte codes.
//
// NoSuchField(Method)Error occurs when a reference refers to a specific field
// (method) of a specific field or interface, but the class or interface does 
// not declare a field of that name (it is specifically not sufficient for it 
// simply to be an inherited field (method) of that class or interface).
//
//
enum Loader_Exception {
	LD_NoException,
	LD_NoClassDefFoundError,
	LD_ClassFormatError,
	LD_ClassCircularityError,
	LD_IncompatibleClassChangeError,
	LD_AbstractMethodError,		// occurs during preparation
	LD_IllegalAccessError,
	LD_InstantiationError,
	LD_NoSuchFieldError,
	LD_NoSuchMethodError,
	LD_UnsatisfiedLinkError,
	LD_VerifyError
};

#endif // include_loader_result_h

