// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/include/exceptions.h,v 1.1.1.1 2001/07/23 07:25:39 xli18 Exp $
//



#ifndef _EXCEPTIONS_H_
#define _EXCEPTIONS_H_



#include "orp_types.h"
#include "object_layout.h"
#include "Class.h"


void __stdcall orp_athrow(Boolean is_first,
                          volatile uint32 edi_arg,
                          volatile uint32 esi_arg,
                          volatile uint32 ebx_arg,
                          volatile uint32 ebp_arg,
                          volatile uint32 esp_arg,
                          volatile uint32 eip_arg,
                          volatile Java_java_lang_Object *obj);

void  __stdcall orp_null_ptr_throw(Frame_Context *context,
                                   volatile Java_java_lang_Object **obj);


//
// WARNING! WARNING! WARNING! WARNING! WARNING! WARNING! WARNING! WARNING!
//
// Those methods only work when involved from native code that was entered
// using a stub which saved away some info which can be used to unwind the stack
// to the last Java frame.
//
void throw_java_exception_from_native(void *exc);
ORPExport void throw_java_exception(const char *exception_name);
ORPExport void throw_java_exception(const char *exception_name, const char *message);



void print_stack_trace(FILE *f, Java_java_lang_Throwable *untyped_exc);
void print_uncaught_exception_message(FILE *f, Java_java_lang_Throwable *exc);



//
// Functions to manipulate the per-thread exception object.
// 
void *get_current_thread_exception();
void __stdcall set_current_thread_exception(void *obj);
void clear_current_thread_exception();
void rethrow_current_thread_exception();
void rethrow_current_thread_exception_if_pending();


void *getaddress__orp_athrow_naked();
void *getaddress__orp_athrow_lazy_naked();
void *getaddress__orp_exception_arrayindexoutofbounds_naked();
void *getaddress__orp_exception_nullpointer_naked();
void *getaddress__orp_exception_arraystore_naked();

void orp_athrow_naked(void *obj);
void orp_athrow_lazy_naked(Class *clss);
void orp_exception_arrayindexoutofbounds_naked();
void orp_exception_arraystore_naked();



void gc_safepoint_check(Frame_Context *context,
                        volatile Java_java_lang_Object **p_obj, 
                        Boolean no_exc_obj);


void  __stdcall orp_throw(Frame_Context *context,
                          volatile Java_java_lang_Object **p_obj,
                          Boolean is_first,
                          Method *constructor = 0,
                          uint8 *constructor_args = 0);

#endif //_EXCEPTIONS_H_
