// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/os/linux/platform_utils.cpp,v 1.2 2001/11/20 11:06:08 xli18 Exp $
//


#include <stdio.h>
#include <signal.h>
#include <pthread.h>
#include <unistd.h>
#include <sys/time.h>
#include <asm/sigcontext.h>
#include <assert.h>
#include <asm/errno.h>
#include <malloc.h>
#include <string.h>

#include <sys/types.h>
#include <dirent.h>

#include "platform.h"

#ifdef OBJECT_LOCK_V2
#include "platform_utils_olv2.h"
#else
#include "platform_utils.h"
#endif


int generic_get_num_dir_entries(const char *dir_path)
{
    DIR *p_dirx = opendir(dir_path);

    if (p_dirx == 0)
        orp_cout << "generic_get_num_dir_entries() can't open " 
                    << dir_path << endl;

    int32 count = 0;

    while (true) {
        struct dirent *p_dent = readdir(p_dirx);
        if (p_dent == 0)
            break;
        count++;
    }

    int32 stat = closedir(p_dirx);
    if (stat != 0)
        orp_cout << "generic_get_num_dir_entries() can't close " 
                    << dir_path << endl;

    return count;
}



__int64 generic_first_dir_ent(const char *dir_path, char **name) 
{
    DIR *p_dirx = opendir(dir_path);

    if (p_dirx == 0)
        orp_cout << "generic_first_dir_ent() can't open " 
                    << dir_path << endl;

    struct dirent *p_dent = readdir(p_dirx);

    char *new_name = (char *)malloc(NAME_MAX + 1);
    strcpy(new_name, p_dent->d_name);

    *name = new_name;
    return (__int64)p_dirx;
}


const char * generic_get_next_dir_entry(__int64 handle, const char *dir_path)
{
    DIR *p_dirx = (DIR *)handle;

    if (p_dirx == 0)
        orp_cout << "generic_get_next_dir_entry() bad handle " 
                    << dir_path << endl;

    struct dirent *p_dent = readdir(p_dirx);

    if (p_dent == 0) {

        int32 stat = closedir(p_dirx);
        if (stat != 0)
            orp_cout << "generic_get_next_dir_entry() can't close " 
                        << dir_path << endl;
        
        return 0;
    }

    char *new_name = (char *)malloc(NAME_MAX + 1);
    strcpy(new_name, p_dent->d_name);

    return new_name;
}








