/*
 *	penguin_prototypes.h
 *
 *	Rob --
 *
 *	This file contains some function prototypes that you should add.
 *
 *	Just makes things cleaner
 */

//#include "penguin.h"

/* from Aliases.h*/
#if !defined(__ALIASES__)
#include <MacTypes.h>
struct AliasRecord {
	OSType 							userType;					/* appl stored type like creator type */
	unsigned short 					aliasSize;					/* alias record size in bytes, for appl usage */
};
typedef struct AliasRecord				AliasRecord;

typedef AliasRecord *					AliasPtr;
typedef AliasPtr *						AliasHandle;
#endif

#define PREFS_FORMAT_VERSION 1;

#define COMMAND_LINE_TAG	'Cmdl'
typedef char cmd_ln[256]; /* Commandline. Fun, no? */

/* The header that goes before each of the following structs in the prefs file */
typedef struct {
	UInt32 length;	/* Length, not including this header */
	UInt32 type;	/* What kind of cruft this is */
} tag_header;

#define RAMDISK_BITS_V1_TAG	'Rb01'
typedef struct { /* bits that affect the ramdisk */
	UInt32	do_ramdisk				:1;
	/* Mmm, what a waste of space. :) - TM */
} ramdisk_bits_v1; /* Don't forget to load the Ramdisk alias resource */

#define LOGFILE_BITS_V1_TAG	'Lb01'
typedef struct { /* bits that affect the logfile */
	UInt32	do_logfile				:1,
			logfile_append			:1,
			debug_boot_info			:1,
			debug_segment_info		:1,
			debug_mach_specs		:1,
			debug_copy_and_go		:1;
} logfile_bits_v1; /* Don't forget to load the Logfile alias resource */

#define PENGUIN_BITS_V1_TAG	'Pb01'
typedef struct { /* bits that affect general stuff in penguin */
	UInt32	auto_boot				:1,
			no_boot					:1,
			color_by_penguin		:1,
			boot_into_linux			:1;
} penguin_bits_v1;

#define SERIAL_BITS_V1_TAG	'Sb01'
typedef struct { /* bits that affect the serial ports */
	UInt32	disable_appletalk		:1,
			do_config_modem_port	:1,
			do_config_printer_port	:1;
} serial_bits_v1;

#define SERIAL_PREFS_V1_TAG	'Sp01'
typedef struct { /* other cruft that affects the serial ports */
	UInt8 modem_port_speed;
	UInt8 printer_port_speed;
	UInt8 modem_data_size;
	UInt8 printer_data_size;
	UInt8 modem_parity;
	UInt8 printer_parity;
	UInt8 modem_stop_bits;
	UInt8 printer_stop_bits;
} serial_prefs_v1;

#define BOOT_DELAY_PREFS_TAG 'BDly'
typedef struct { /* Boot delay value. 0 = don't delay, obviously. */
	UInt32	boot_delay_time;
} boot_delay_prefs;

typedef struct {
	short do_config_port:1; /* put more stuff here later, if needed */
	char port_speed;
	char data_size;
	char parity;
	char stop_bits;
} serial_config;

#ifndef PENGUIN_PREFS
	#define PENGUIN_PREFS

/* Old Prefs format, Don't mess with this struct */
typedef struct {
	short			version;				/* = 0x0100 */
	short			pad;					/* 32 bit alignment */
	AliasHandle		kernel_alias;
	AliasHandle		ramdisk_alias;
	AliasHandle		logfile_alias;
	char			command_line[256];
	unsigned int	do_ramdisk			:1,
					do_logfile			:1,
					logfile_append		:1,
					debug_boot_info		:1,
					debug_segment_info	:1,
					debug_mach_specs	:1,
					debug_copy_and_go	:1,
					auto_boot			:1,
					/* --- cut here, 8 bits --- */
					Xdisable_mmu		:1,	/* not used, removed */
					disable_vbl			:1,
					jump_to_start		:1,	/* not used */
					no_boot				:1,
					Xnoforce_bank_b		:1,	/* not used, removed */
					Xdisable_ext_cache	:1,	/* not used, removed */
					reverse_video		:1, /* Colour by Penguin. Rename this */
					enable_ext_cache	:1,
					/* --- cut here, 16 bits --- */
					use_old_mappings	:1,
					noforce_020_bank_a	:1,
					boot_into_linux		:1;
} penguin_prefs;

/* New globals format, no binary compatibility issues */
typedef struct {
	AliasHandle		kernel_alias;
	AliasHandle		ramdisk_alias;
	AliasHandle		logfile_alias;
	cmd_ln			command_line;
	unsigned int	do_ramdisk			:1,
					do_logfile			:1,
					logfile_append		:1,
					debug_boot_info		:1,
					debug_segment_info	:1,
					debug_mach_specs	:1,
					debug_copy_and_go	:1,
					auto_boot			:1,
					no_boot				:1,
					color_by_penguin	:1,
					boot_into_linux		:1,
					disable_appletalk	:1,
					delay_boot			:1;
	long			boot_delay_time; /* in seconds */
	serial_config	modem_port;
	serial_config	printer_port;
} penguin_config;

#endif /* PENGUIN_PREFS */

// Defs
#define GZIP_RDBUF_SIZE	(32L*1024L)

// Types
typedef unsigned char	u_char;
typedef unsigned short	u_short;
typedef unsigned long	u_long;


// penguin.c
extern penguin_config	config;
extern char				*gzip_rdbuf;

void			cprintf (char *format, ...);
OSErr			start_logging (void);
void			stop_logging (void);
