#ifndef SEAVIEW_H
#define SEAVIEW_H
#include "forms.h"

#if FL_INCLUDE_VERSION <= 81
#define fl_drw_text_cursor(a,x,y,w,h,c,st,si,t,cc,p)  \
			fl_drw_text_cursor(a,x,y,w,h,c,si,st,t,cc,p)
#define fl_show_question(q, i) fl_show_question(q, "", "")
#define fl_ringbell(a) ringbell()
#endif

#define MAXNSEQS 3000 /* max # of seqs per mase file */
#define MAXLENCOM 50000 /* long max des commentaires sous mase */
#define MAX_SPECIES_SETS 50 /* nbre max de species sets */
#define PHYNAME 10
#define CLU_WID_NAME 16
#define MSF_WID_NAME 15
#define CLU_BLOCK_LEN 5000 /* block pour allocation mem format Clustal */
#define MAX_GAP_SITES 1000

typedef struct _list_segments { /* one segment + pointer to its successor */
	int debut, fin;
	struct _list_segments *next;
	} list_segments;
	
typedef struct { /* one region = name + pointer to list of segments */
	char *name;
	list_segments *list;
	} region;

typedef struct _list_regions { /* region list = pointer to region + 
				pointer to successor in list */
	region *element;
	struct _list_regions *next;
	} list_regions;

typedef struct {
	int pos;
	int l[2];
	} gap_site;
	
typedef enum {MASE_FORMAT, PHYLIP_FORMAT, CLUSTAL_FORMAT, MSF_FORMAT, 
	FASTA_FORMAT} 
	known_format;

typedef enum {OPEN_MASE = 1, OPEN_PHYLIP, OPEN_CLUSTAL, OPEN_MSF, OPEN_FASTA,
	SAVE, SAVE_AS, SAVE_REGIONS, PRINTOUT,
	QUIT} file_menu_choice;

typedef enum {NO_ALT_COLORS, USING_STANDARD_COLORS, USING_ALT_COLORS}
	color_choice;

typedef enum {RENAME_SEQ = 1, EDIT_COMMENTS, DELETE_SEQ, CREATE_SEQ, LOAD_SEQ, 
	DUPLICATE_SEQ,
	COMPLEMENT_SEQ, REVERSE_SEQ, EXCHANGE_UT, ALIGN_SEQS, DOT_PLOT,
	CONSENSUS_SEQ, DELETE_GAP_ONLY_SITES}
	edit_choice;

typedef enum {SHOW_HIDE_FOOTERS = 1, CREATE_FOOTER, DELETE_FOOTER }
	footers_menu_choice;

typedef struct {
	FL_OBJECT *DNA_obj; /* free object for names + seqs */
	FL_OBJECT *horsli; /* horizontal slider */
	FL_OBJECT *vertsli; /* vertical slider */
	FL_OBJECT *left_arrow, *right_arrow, *up_arrow, *down_arrow;/*4 arrows*/
	FL_OBJECT *right_screen_move, *left_screen_move, *up_screen_move, 
			*down_screen_move; /* 4 pageful arrows */
	FL_OBJECT *multipl; /* box displaying the multiplier value */
	FL_OBJECT *menu_regions; /* menu of region operations */
	FL_OBJECT *menu_file; /* menu of file operations */
	FL_OBJECT *menu_edit; /* menu of edit operations */
	FL_OBJECT *bouton_props; /* menu of properties */
	FL_OBJECT *menu_species; /* menu of species */
	FL_OBJECT *menu_footers; /* menu of footers */
	FL_OBJECT *bouton_reference; /* bouton_reference */
	char **sequence; /* array of sequences */
	char **comments; /* array of sequence comments */
	char *header; /* header of mase file */
	char ***col_seq; /* array of sequences split by color */
	char ***alt_col_seq; /* alternate array of sequences split by color */
	char **seqname; /* array of sequence names */
	char *masename; /* mase file name */
	int protein; /* TRUE iff protein data */
	known_format format_for_save; /* what file format used when saving */
	int wid_names; /* width of largest sequence name */
	int first_seq, first_site; /* first seq and site currently displayed */
	int tot_seqs; /* total number of sequences in memory */
	int seq_length; /* current length of longest sequence */
	int max_seq_length; /*max length allowed for longest sequence to grow */
	int *each_length; /* array of each individual sequence length */
	int tot_sites, tot_lines; /* sites and lines fitting in DNA_obj */
	int x_name, y_name, x_seq, y_seq; /* top left to start writing 
						names and sequences */
	int draw_names; /*controle ecriture noms 0: pas ecrits; 
			-1: tous ecrits puis aussi les seqs;
			-2: tous ecrits mais pas les seqs;
			>=1: 1 seul ecrit et pas de seq ni de curseur ecrit*/
	int mod_seq; /* -1: seqs selectionnees; 
			0: normal; 
			>= 1: 1 seul seq ecrite */
	int mod_cursor; /* FALSE: cursor ancien ignore; TRUE: ancien efface */
	int char_width, line_height; /* taille en pixels des caracteres */
	int cursor_seq, cursor_site; /* position courante du curseur */
	int old_cursor_seq, old_cursor_site; /* position precedente du curseur*/
	int tot_sel_seqs; /* nbre courant de seqs selectionnees */
	int *sel_seqs; /* tableau des seqs selectionnees: T/F pour chacune */
	FL_COLOR *curr_colors; /*tableau des couleurs pour chaque elt col_seq*/
	int inverted_colors; /* TRUE iff use black letters on colored square */
	FL_COLOR namecolor; /* couleur utilisee pour les noms */
	int numb_gc; /* 1 en N&B, >1 en couleurs */
	FL_COLOR *dnacolors; /* tableau des couleurs pour DNA/RNA */
	int numb_dnacolors; /* nbre de couleurs pour DNA/RNA */
	FL_COLOR *stdprotcolors; /*tableau des couleurs standard pour prots*/
	int numb_stdprotcolors; /* nbre de couleurs standard pour prots */
	FL_COLOR *altprotcolors;/*tableau des couleurs alternatives pour prots*/
	int numb_altprotcolors; /*nbre de couleurs alternatives pour prots*/
	color_choice alt_colors; /* current aa color use */
	list_regions *regions; /* list of known regions */
	region *active_region; /* active region (NULL when none) */
	char *region_line; /* region line (of length region_length) */
	FL_COLOR region_color; /* color used to display region line */
	int region_length; /* length of region_line (==seq_length) */
	int mod_region_line; /* TRUE region line changed=>redraw only it */
	int numb_species_sets; /* number of known species sets */
	int *list_species_sets[MAX_SPECIES_SETS];/*list of known species sets*/
	char *name_species_sets[MAX_SPECIES_SETS];/*names of species sets*/
	int allow_seq_edit; /* when TRUE can type sequence data in */
	int hjkl; /* when TRUE, keys hjklHJKL produce TCGA */
	int modif_but_not_saved;
	Window dnawin; /* window of DNA_obj */
	int reducefonts; /* TRUE when need smaller fonts (e.g. 100dpi) */
	int double_buffer; /* true iff DNA_obj is double buffered */
	char *clustal_options; /* options for clustalw if != NULL */
	int consensus_threshold; /* min threshold (%) for residue in consensus*/
	int tot_comment_lines; /* number of comment lines */
	char **comment_line; /* array of comment lines */
	char **comment_name; /* array of comment names */
	int *comment_length; /* array of comment lengths */
	int show_comment_lines; /* TRUE when displayed */
	int pos_first_comment_line; /* rank on screen of this line */
	int mod_comment_line; /* 0: normal, >=1 celle-ci ecrite */
	int active_comment_line; /* 0: none, >=1 target of keyboard */
	int cursor_in_comment; /* TRUE when cursor is in comments not in seqs */
	int old_cursor_in_comment; /*previous place of cursor seq vs. comments*/
	} SEA_VIEW;
	

extern void out_of_memory(void);
extern void init_dna_scroller(FL_OBJECT *, char **, char **, int, char **,
	const char *, int, char *);
extern const char *extract_filename( const char *fname);
extern void draw_region_line(FL_OBJECT *ob, SEA_VIEW *view);
extern void props_button_callback(FL_OBJECT *ob, long mainpop);
extern void regions_menu_callback(FL_OBJECT *ob, long which);
extern void species_menu_callback(FL_OBJECT *ob, long which);
extern void footers_menu_callback(FL_OBJECT *ob, long which);
extern int suppr_segment(region *maregion, int site, char *line);
extern int begin_change_segment(SEA_VIEW *view, int new_site);
extern int continue_change_segment(SEA_VIEW *view, int new_site);
extern void end_change_segment(SEA_VIEW *view);
extern int extend_segment_at_left(SEA_VIEW *view, int new_site);
extern void delete_region_part(SEA_VIEW *view, int numsite, int total);
extern void insert_region_part(SEA_VIEW *view, int numsite, int total);
extern void delete_region(SEA_VIEW *view, int rang);
extern list_regions *parse_regions_from_header(char *header);
extern int parse_species_sets_from_header(char *header, int **list_species_sets,
	char **name_species_sets, int totseqs);
extern void set_tot_lines(SEA_VIEW *view, int new_val);
extern int read_mase_seqs_header(const char *,char **,char **,
		char **, char **, int, char **);
extern int read_fasta_align(const char *fname, char **seq, char **seqname, 
		char ** comments, char **pheader, int maxnseqs, 
		char **err_message);
extern int read_phylip_align(const char *fname, char **seq, char **seqname, 
		char ** comments, char **pheader, int maxnseqs, char **);
extern int read_clustal_align(const char *fname, char **seq, char **seqname, 
		char ** comments, char **pheader, int maxnseqs,
		char **err_message);
extern int read_msf_align(const char *fname, char **seq, char **seqname, 
		char ** comments, char **pheader, int maxnseqs,
		char **err_message);
extern char *save_alignment_or_region(const char *fname, char **seq, 
	char **comments,
	char *header, char **seqname, int totseqs, int *eachlength,
	list_regions *regions, region *region_used, known_format format,
	int numb_species_sets, int **list_species_sets, 
	char **name_species_sets, int *sel_seqs, int tot_sel_seqs, int protein,
	int tot_comment_lines, char **comment_name, char **comment_line);
extern void load_alignment_file(FL_OBJECT *scroller, char *filename, 
	char *message, char *pattern, known_format file_format);
extern int is_a_protein_seq(char *seq);
extern int prepare_printout(const char *filename, char **seq, int totseqs,  
	char **seqname,
	int *eachlength, int char_per_line,
	int block_size, int lines_per_page, char *align_name, int ref0);
extern FILE *open_path(char *fname);
extern int check_path(char *fname);
extern void draw_region_background(SEA_VIEW *view, int f_seq0, int l_seq0);
extern void load_seq_dialog(FL_OBJECT *scroller);
extern void edit_comments_dialog(FL_OBJECT *scroller);
extern void add_seq_to_align(FL_OBJECT *scroller, char *newname, char *newseq, 
	int lenseq);
extern int get_color_for_base( int key );
extern int get_color_for_aa( int key );
extern char ***prepcolseqs(char **seq, int totseqs, int maxlen, int *eachlength,
	int (*calc_color_function)( int ), int numb_gc);
extern int simple_close_callback(FL_FORM *form, void *data);
extern char complement_base(char old);
extern void select_deselect_seq(SEA_VIEW *view, int new_seq);
extern void save_active_region(SEA_VIEW *view, int ask_confirm);
extern void align_selected_parts(SEA_VIEW *view);
extern void free_region(region *reg);
extern void my_watch_cursor(Window win);
extern void my_open_and_raise_form(FL_FORM *form);
extern void update_current_seq_length(int newlength, SEA_VIEW *view);
extern char *cre_consensus(SEA_VIEW *view, char *newname);
extern int parse_comment_lines_from_header(char *header, char ***plines, 
	char ***pnames, int **plengths, int max_seq_length);
extern int insert_char_in_comment(int key, int num, SEA_VIEW *view);
extern int delete_char_in_comment(SEA_VIEW *view, int count, int comnum, 
	int depart, int protect);
extern void update_menu_footers(SEA_VIEW *view);
extern int insert_gap_all_comments(int numgaps, int pos,  SEA_VIEW *view);
extern int delete_in_all_comments(int numdels, int pos,  SEA_VIEW *view);
#endif
