#include "seaview.h"
#include "FL/Fl_Group.H"
#include "FL/Fl_Menu.H"
#include "FL/Fl_Menu_.H"
#include "FL/Fl_Browser_.H"
#include "FL/filename.H"
#include "FL/Fl_Button.H"
#include "FL/Fl_Check_Button.H"


/* included functions */
char* fl_file_chooser_plus(const char* message, const char* pat, 
	const char* fname, int use_only_button);
char* fl_file_chooser_save_as(const char* message, const char* pat, 
	const char* fname, void *view);
#ifdef __APPLE__
int MG_GetOutputFName_Popup(char *fname, int maxl, char *dfault, void *data, int defaultformat);
int MG_GetOutputFName_Plus(char *fname, int maxl, char *dfault, char *message);
#else
int change_bouton_label(Fl_Widget *obj, char *message);
void change_block(Fl_Widget *obj, void *data);
void change_cpl(Fl_Widget *obj, void *data);
void change_lpp(Fl_Widget *obj, void *data);
void change_vary(Fl_Widget *obj, void *data);
#endif



// needed functions
#ifdef __APPLE__
extern "C" {  
	void MG_FSSpecToPathname (FSSpec *myFSS, char *fname, int maxl);
	void PtoC(const void *in, void *out);
	void CtoP(const void *in, void *out);
	}
extern void set_save_format(SEA_VIEW *view, int val);
#else
extern void change_format(Fl_Widget *obj, void *data);
#endif

extern int nbr_formats;
extern char *f_format_names[];
extern int printout_block, printout_cpl, printout_lpp;
extern int printout_vary;


#ifdef __APPLE__


static pascal void MyNavEventProc_popup (NavEventCallbackMessage callBackSelector,
                                   NavCBRecPtr callBackParms,
                                   NavCallBackUserData callBackUD)
{
NavMenuItemSpec *p;
SEA_VIEW *view;
int num;
char f_name[20];
OSErr err;

view = (SEA_VIEW *)callBackUD;
if(callBackSelector == kNavCBStart) {
/*	il faut beaucoup d'imagination pour arriver  faire marcher ce call */
	NavMenuItemSpec item;
	CtoP(f_format_names[view->format_for_save], item.menuItemName);
	item.version = kNavMenuItemSpecVersion;
	item.menuCreator = 'extn';  // ncessaire
	item.menuType = view->format_for_save ;
	err = NavCustomControl(callBackParms->context, kNavCtlSelectCustomType, &item ); 
	}
else if(callBackSelector == kNavCBPopupMenuSelect) {
	p = (NavMenuItemSpec *)(callBackParms->eventData.eventDataParms.param);
	PtoC(p->menuItemName, f_name);
	for(num = 0; num < nbr_formats; num++ ) {
		if(strcmp(f_format_names[num], f_name) == 0) break;
		}
	set_save_format(view, num);
	}
return;
}


int MG_GetOutputFName_Popup(char *fname, int maxl, char *dfault, void *data, int defaultformat)
{
    OSErr               anErr = noErr;
    NavReplyRecord      reply;
    NavDialogOptions    dialogOptions;
    FSSpec              fss;
    OSType              fileTypeToSave = 'TEXT';
    OSType              creatorType;
    NavEventUPP         eventProc = NewNavEventUPP (MyNavEventProc_popup);
	char                filename [256];
 	Handle h; 
 	NavMenuItemSpec *p;
	int    i, rsult = FALSE;

    anErr = NavGetDefaultDialogOptions (&dialogOptions);
    if (anErr == noErr)
    {
    CtoP("seaview : save", dialogOptions.windowTitle);
    dialogOptions.dialogOptionFlags &= ~ kNavNoTypePopup;
    dialogOptions.dialogOptionFlags &= ~ kNavAllowStationery;
	h = NewHandle(nbr_formats * sizeof(NavMenuItemSpec));
	HLock(h);	p = (NavMenuItemSpec *)*h;
	for(i = 0; i < nbr_formats; i++) {
		p->version = kNavMenuItemSpecVersion;
		CtoP(f_format_names[i], p->menuItemName);
		p->menuCreator = 'extn';  // ncessaire
		p->menuType = i ;  // ncessaire
		p++;
		}
	HUnlock(h);
    dialogOptions.popupExtension = (NavMenuItemSpecArrayHandle)h;
    reply.translationNeeded = false;


            //  One way to get the name for the file to be saved.
			CtoP(dfault, dialogOptions.savedFileName);

            creatorType = kNavGenericSignature;
            anErr = NavPutFile( NULL, &reply, &dialogOptions, eventProc,
                                fileTypeToSave, creatorType, data );
            if (anErr == noErr && reply.validRecord)
            {
                AEKeyword   theKeyword;
                DescType    actualType;
                Size        actualSize;
                FSSpec      documentFSSpec;

                anErr = AEGetNthPtr(&(reply.selection), 1, typeFSS,
                                    &theKeyword, &actualType,
                                    &documentFSSpec, sizeof(documentFSSpec),
                                    &actualSize );
                if (anErr == noErr)
                {
                    if (reply.replacing)
                    { /* compute the pathname of the pre-existing file */
                        MG_FSSpecToPathname (&documentFSSpec, fname, maxl);
                        rsult = TRUE;
                    }
                    else
                    { /* the chosen file is new, compute pathname to its directory
                    and append new filename */
                        char empty[256];
                        FSSpec pfss;
                        empty[0] = 0;
                   /* make an FSSpec from volume + parentID of documentFSSpec
                   */
                        FSMakeFSSpec(documentFSSpec.vRefNum, documentFSSpec.parID,
                        	(StringPtr) empty, &pfss);
                   /* compute pathname for this FSSpec
                   */
                        MG_FSSpecToPathname (&pfss, fname, maxl);
                        /* append : new filename to this path
                        */
                        strcat(fname, ":");
                        PtoC(documentFSSpec.name, fname + strlen(fname) );

                        rsult = TRUE;
                    }

                        // DO NOT call NavCompleteSave() to complete
                         anErr = NavCompleteSave(&reply,
                                                kNavTranslateInPlace); 
                }
                (void) NavDisposeReply(&reply);
            }
        DisposeNavEventUPP(eventProc);
    }
    return rsult;
}


char* fl_file_chooser_save_as(const char* message, const char* pat, 
	const char* fname, void *data)
{
	static char pathname[FL_PATH_MAX];
	SEA_VIEW *view = (SEA_VIEW *)data;
	if( MG_GetOutputFName_Popup(pathname, FL_PATH_MAX, (char *)fname, data, 
						view->format_for_save) ) return pathname;
	else return NULL;
}


static pascal void MyNavEventProc_Plus (NavEventCallbackMessage callBackSelector,
                                   NavCBRecPtr callBackParms,
                                   NavCallBackUserData callBackUD)
{
OSErr err;
static Handle gDitlList;
static DialogItemIndex index;
static DialogRef ref;
Rect rect; Handle h; DialogItemType dtype; Str255 text;
char text2[256];

if(callBackSelector == kNavCBCustomize) {
	if(callBackParms->customRect.bottom == 0) 
			callBackParms->customRect.bottom = callBackParms->customRect.top + 35;
	if(callBackParms->customRect.right == 0) 
			callBackParms->customRect.right = callBackParms->customRect.left + 400;
	}
else if(callBackSelector == kNavCBStart) {
	gDitlList = GetResource ('DITL', 128);
	if(gDitlList != NULL) err = NavCustomControl(callBackParms->context, 
                            kNavCtlAddControlList, gDitlList);
    err = NavCustomControl(callBackParms->context, kNavCtlGetFirstControlID, &index);
    index++;
    ref = GetDialogFromWindow(callBackParms->window);
	sprintf(text2,"%3d", printout_block);
	CtoP(text2, text);
	GetDialogItem(ref, index + 1, &dtype, &h, &rect);
	SetDialogItemText(h, text);
	sprintf(text2,"%3d", printout_cpl);
	CtoP(text2, text);
	GetDialogItem(ref, index + 3, &dtype, &h, &rect);
	SetDialogItemText(h, text);
	sprintf(text2,"%3d", printout_lpp);
	CtoP(text2, text);
	GetDialogItem(ref, index + 5, &dtype, &h, &rect);
	SetDialogItemText(h, text);
	}
else if(callBackSelector == kNavCBTerminate) {
	GetDialogItem(ref, index + 1, &dtype, &h, &rect);
	GetDialogItemText(h, text);
	PtoC(text, text2);
	sscanf(text2,"%d", &printout_block);
	GetDialogItem(ref, index + 3, &dtype, &h, &rect);
	GetDialogItemText(h, text);
	PtoC(text, text2);
	sscanf(text2,"%d", &printout_cpl);
	GetDialogItem(ref, index + 5, &dtype, &h, &rect);
	GetDialogItemText(h, text);
	PtoC(text, text2);
	sscanf(text2,"%d", &printout_lpp);
	if(gDitlList != NULL) ReleaseResource( gDitlList );
	}
return;
}


int MG_GetOutputFName_Plus(char *fname, int maxl, char *dfault, char *message)
{
    OSErr               anErr = noErr;
    NavReplyRecord      reply;
    NavDialogOptions    dialogOptions;
    FSSpec              fss;
    OSType              fileTypeToSave = 'TEXT';
    OSType              creatorType;
    NavEventUPP         eventProc = NewNavEventUPP (MyNavEventProc_Plus);
	char                filename [256];
 	NavMenuItemSpec *p;
	int    i, rsult = FALSE;

    anErr = NavGetDefaultDialogOptions (&dialogOptions);
    if (anErr == noErr)
    {
    CtoP(message, dialogOptions.windowTitle);
    dialogOptions.dialogOptionFlags |= kNavNoTypePopup;
    dialogOptions.dialogOptionFlags &= ~ kNavAllowStationery;
    reply.translationNeeded = false;


            //  One way to get the name for the file to be saved.
			CtoP(dfault, dialogOptions.savedFileName);

            creatorType = kNavGenericSignature;
            anErr = NavPutFile( NULL, &reply, &dialogOptions, eventProc,
                                fileTypeToSave, creatorType, NULL );
            if (anErr == noErr && reply.validRecord)
            {
                AEKeyword   theKeyword;
                DescType    actualType;
                Size        actualSize;
                FSSpec      documentFSSpec;

                anErr = AEGetNthPtr(&(reply.selection), 1, typeFSS,
                                    &theKeyword, &actualType,
                                    &documentFSSpec, sizeof(documentFSSpec),
                                    &actualSize );
                if (anErr == noErr)
                {
                    if (reply.replacing)
                    { /* compute the pathname of the pre-existing file */
                        MG_FSSpecToPathname (&documentFSSpec, fname, maxl);
                        rsult = TRUE;
                    }
                    else
                    { /* the chosen file is new, compute pathname to its directory
                    and append new filename */
                        char empty[256];
                        FSSpec pfss;
                        empty[0] = 0;
                   /* make an FSSpec from volume + parentID of documentFSSpec
                   */
                        FSMakeFSSpec(documentFSSpec.vRefNum, documentFSSpec.parID,
                        	(StringPtr) empty, &pfss);
                   /* compute pathname for this FSSpec
                   */
                        MG_FSSpecToPathname (&pfss, fname, maxl);
                        /* append : new filename to this path
                        */
                        strcat(fname, ":");
                        PtoC(documentFSSpec.name, fname + strlen(fname) );

                        rsult = TRUE;
                    }

                        // DO NOT call NavCompleteSave() to complete
                         anErr = NavCompleteSave(&reply,
                                                kNavTranslateInPlace); 
                }
                (void) NavDisposeReply(&reply);
            }
        DisposeNavEventUPP(eventProc);
    }
    return rsult;
}


char* fl_file_chooser_plus(const char* message, const char* pat, 
	const char* fname, int use_only_button)
{
	static char pathname[FL_PATH_MAX];
	if( MG_GetOutputFName_Plus(pathname, FL_PATH_MAX, (char *)fname, (char *)message ) ) return pathname;
	else return NULL;
}


#else



class FCB : public Fl_Browser_ {
  void* item_first() const ;
  void* item_next(void*) const ;
  void* item_prev(void*) const ;
  int item_height(const dirent*, int) const ;
  int item_height(void*) const ;
  int item_width(const dirent*) const ;
  int item_width(void*) const ;
  int item_quick_height(void*) const ;
  int incr_height() const ;
  void item_draw(void*, int, int, int, int) const ;
  int checkdir(const dirent*, char*) const ;
  void draw();
  void clear_prev();
public:
  char listed[FL_PATH_MAX];// current dir & starname
  int dirend;		// points after last / before starname
  int nameend;		// length to trailing '*' or '\0'
  const char* pattern;	// default pattern
  dirent** list;	// the file names
  dirent** last;	// pointer after end of list
  const char* message;	// message if no file names
  char preved[FL_PATH_MAX];// directory listed in prev
  dirent** prev;	// cached list of another directory
  dirent** prev_last;	// end of that list
  int prev_count;
  FCB(int x, int y, int w, int h) : Fl_Browser_(x, y, w, h, 0) {
    type(FL_HOLD_BROWSER);
    listed[0] = 0;
    dirend = nameend = 1;
    pattern = 0;
    list = prev = 0;
    message = 0;
  }
  // ~FCB nyi
  void clear();
  void set(const char*);
  int get(char*);
};

class FCW : public Fl_Window {
public:
  int handle(int);
  Fl_Input input;
  Fl_Button* ok_button;
  Fl_Button* cancel_button;
  Fl_Button* normal_button;
  Fl_Button* cwd_button;
  FCB browser;
  FCW() ;
};

#define PRINTOUT_LABEL_SIZE 30
static char printout_label_block[PRINTOUT_LABEL_SIZE] = "block size=";
static char printout_label_cpl[PRINTOUT_LABEL_SIZE] = "chars/line=";
static char printout_label_lpp[PRINTOUT_LABEL_SIZE] = "lines/page=";
static char printout_label_vary[PRINTOUT_LABEL_SIZE] = "variable sites only";


int change_bouton_label(Fl_Widget *obj, char *message)
{
char *p, defaut[PRINTOUT_LABEL_SIZE], *b_label;
int old_val, new_val;
p = (char *)obj->label();
p = strchr(p, '=') + 1;
sscanf(p, "%d", &old_val);
sprintf(defaut, "%d", old_val);
p = (char *)fl_input(message, defaut);
if(p == NULL) return old_val;
new_val = -1; sscanf(p, "%d", &new_val);
if( new_val == old_val || new_val <= 0) return old_val;
b_label = (char *)malloc(PRINTOUT_LABEL_SIZE);
strcpy(b_label, obj->label());
p = strchr(b_label, '=') + 1;
sprintf(p, "%d", new_val);
free( (void *)obj->label() );
obj->label(b_label);
return new_val;
}

void change_block(Fl_Widget *obj, void *data)
{
printout_block = change_bouton_label(obj, "Enter desired printout block size");
}

void change_cpl(Fl_Widget *obj, void *data)
{
printout_cpl = change_bouton_label(obj, 
	"Enter desired number of residues per line");
}

void change_lpp(Fl_Widget *obj, void *data)
{
printout_lpp = change_bouton_label(obj, 
	"Enter desired number of lines per page");
}


void change_vary(Fl_Widget *obj, void *data)
{
Fl_Button *b = (Fl_Button *)obj;
int etat = b->value();
printout_vary = etat;
}


#define labelSize 10
#define calc_width(nom) \
	(fl_font(FL_HELVETICA, labelSize), (int)fl_width(nom) + 20)


char* fl_file_chooser_save_as(const char* message, const char* pat, 
	const char* fname, void *view)
{
  static FCW* f; if (!f) f = new FCW();
  f->ok_button->label(fl_ok);
  f->cancel_button->label(fl_cancel);

  if (pat && !*pat) pat = 0;
  if (fname && *fname) {
    f->input.value(fname);
  } else if (f->browser.pattern != pat && (!pat || !f->browser.pattern ||
					   strcmp(pat,f->browser.pattern))) {
    // if pattern is different, remove name but leave old directory:
    const char* p = f->input.value();
    const char* q = fl_filename_name(p);
    f->input.value(p, q-p);
  }
  f->browser.pattern = pat;
  f->normal_button->label(pat ? pat : "visible files");
  f->browser.set(f->input.value());
  f->input.position(10000, f->browser.dirend);

  f->label(message);
  f->hotspot(f);

Fl_Button *bouton;

bouton = new Fl_Button(2, f->ok_button->y(), 5, f->ok_button->h());
char b_label[] = "change file format";
fl_font(f->ok_button->labelfont(), f->ok_button->labelsize()); 
bouton->size( (int)fl_width(b_label) + 10 , bouton->h() );
bouton->label(b_label);
bouton->callback(change_format, view);
f->add(bouton);


  f->show();
  int ok = 0;
  for (;;) {
    Fl::wait();
    Fl_Widget* o = Fl::readqueue();
    if (o == f->ok_button) {ok = 1; break;}
    else if (o == f->cancel_button || o == f) break;
  }
  f->hide();
  f->browser.clear();

  if (!ok) return 0;
  const char* r = f->input.value();
  const char *p;
  for (p=r+f->browser.dirend; *p; p++)
    if (*p=='*' || *p=='?' || *p=='[' || *p=='{') return 0;
  static char final[FL_PATH_MAX];
  strcpy(final, r);
  return final;
}


char* fl_file_chooser_plus(const char* message, const char* pat, 
	const char* fname, int use_only_button)
{
static int first = TRUE;
static Fl_Button *b_vary;
  static FCW* f; if (!f) f = new FCW();
  f->ok_button->label(fl_ok);
  f->cancel_button->label(fl_cancel);

  if (pat && !*pat) pat = 0;
  if (fname && *fname) {
    f->input.value(fname);
  } else if (f->browser.pattern != pat && (!pat || !f->browser.pattern ||
					   strcmp(pat,f->browser.pattern))) {
    // if pattern is different, remove name but leave old directory:
    const char* p = f->input.value();
    const char* q = fl_filename_name(p);
    f->input.value(p, q-p);
  }
  f->browser.pattern = pat;
  f->normal_button->label(pat ? pat : "visible files");
  f->browser.set(f->input.value());
  f->input.position(10000, f->browser.dirend);

  f->label(message);
  f->hotspot(f);

if(first) {
	first = FALSE;
	int gauche = 2; char *q; Fl_Button *bouton; char *b_label;
	
	bouton = new Fl_Button(gauche, f->ok_button->y(), 5, f->ok_button->h());
	b_label = (char *)malloc(50);
	strcpy(b_label, printout_label_block);
	q = strchr(b_label,'=');
	sprintf(q+1, "%d", printout_block);
	bouton->size( calc_width(b_label) , bouton->h() );
	bouton->label(b_label);
	bouton->callback(change_block, NULL);
	bouton->labelsize(labelSize);
	f->add(bouton);
	gauche += bouton->w() + 2;
	
	bouton = new Fl_Button(gauche, f->ok_button->y(), 5, f->ok_button->h());
	b_label = (char *)malloc(50);
	strcpy(b_label, printout_label_cpl);
	q = strchr(b_label,'=');
	sprintf(q+1, "%d", printout_cpl);
	bouton->size( calc_width(b_label) , bouton->h() );
	bouton->label(b_label);
	bouton->callback(change_cpl, NULL);
	bouton->labelsize(labelSize);
	f->add(bouton);
	gauche += bouton->w() + 2;
	
	bouton = new Fl_Button(gauche, f->ok_button->y(), 5, f->ok_button->h());
	b_label = (char *)malloc(50);
	strcpy(b_label, printout_label_lpp);
	q = strchr(b_label,'=');
	sprintf(q+1, "%d", printout_lpp);
	bouton->size( calc_width(b_label) , bouton->h() );
	bouton->label(b_label);
	bouton->callback(change_lpp, NULL);
	bouton->labelsize(labelSize);
	f->add(bouton);
	gauche += bouton->w() + 2;
	
	b_vary = new Fl_Check_Button(gauche, f->ok_button->y(), 5, 
		f->ok_button->h());
	b_vary->size( calc_width(printout_label_vary) , bouton->h() );
	b_vary->label(printout_label_vary);
	b_vary->callback(change_vary, NULL);
	b_vary->labelsize(labelSize);
	b_vary->value(printout_vary);
	f->add(b_vary);
}

f->show();
if(use_only_button) b_vary->show();
else b_vary->hide();

  int ok = 0;
  for (;;) {
    Fl::wait();
    Fl_Widget* o = Fl::readqueue();
    if (o == f->ok_button) {ok = 1; break;}
    else if (o == f->cancel_button || o == f) break;
  }
  f->hide();
  f->browser.clear();

  if (!ok) return 0;
  const char* r = f->input.value();
  const char *p;
  for (p=r+f->browser.dirend; *p; p++)
    if (*p=='*' || *p=='?' || *p=='[' || *p=='{') return 0;
  return (char*)r;
}

#endif
