
#include <iostream>
#include <fstream>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <sys/stat.h>
#include "defines.h"
#include "frend.h"
#include "misc.h"

s9x_FileOps::s9x_FileOps(const char*name):
fstream(), Filename(0), FileBasename(0)
{
   SetFilename(name);
}

/// @return $HOME/S9X_SUBDIR/name
char*s9x_FileOps::ExpandFilename(const char*name) {
   char *Home;
   if(!(Home = fr_HomeDir()))
     Home = ".";
   char* SD = S9X_SUBDIR;
   int namesize = strlen(Home) + (SD?strlen(SD):0) + (name?strlen(name):0) + 4;
   char* Fullname = new char[namesize];
   sprintf(Fullname, "%s/%s%s%s", Home, S9X_SUBDIR, name?"/":"", name?name:"");
   return Fullname;
}

/// make the s9x directory for the user
void s9x_FileOps::MkDir() {
   char *DirName = ExpandFilename(0);
   mode_t m = S_IRUSR|S_IWUSR|S_IXUSR|S_IRGRP|S_IXGRP|S_IROTH|S_IXOTH;
   mkdir(DirName, m);
   delete[] DirName;
}
/// remove the s9x directory, if it is empty
void s9x_FileOps::RmDir() {
   char *DirName = ExpandFilename(0);
   rmdir(DirName);
   delete[] DirName;
}

void s9x_FileOps::SetFilename(const char*name) {
   if (Filename) delete[] Filename;
   Filename = ExpandFilename(name);
   FileBasename = strrchr(Filename, '/');
   if(!FileBasename) FileBasename = Filename;
   else FileBasename++;
}

void s9x_FileOps::open(int mode, int prot) {
   MkDir();
   fstream::open(Filename, mode, prot);
}

void s9x_FileOps::erase() {
   unlink(Filename);
   RmDir();
}

int s9x_FileOps::stat(struct stat& statbuf) {
   return ::stat(Filename, &statbuf);
}

// take another stream's output as input (or vice versa)
void s9x_FileOps::funnel(ios& s) {
   dup2(rdbuf()->_fileno, s.rdbuf()->_fileno);
}

s9x_FileOps::~s9x_FileOps() {
   if (Filename) delete[] Filename;
}
