#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <glib.h>
#include "../src/object.h"
#include "../src/coordutils.h"
#include "../src/stack.h"

#define STACKSIZE 100000

int wgets(char *line, FILE *in)
{
	int i;

	for(;;)
	{
		fgets(line, 999, in);
		if(feof(in)) return -1;
		for(i = 0; line[i] >= ' ' && line[i] != '#'; i++);
		line[i] = 0;
		if(line[0] != 0) return i;
	}
}

void fail(const char *str)
{
	fprintf(stderr, str);
	exit(0);
}

void fprintstr(FILE *out, char *line, int l, int start, int stop)
{
	char temp[100];
	int i, j=0;
	if(l <= stop) for(i = start; i <= stop; i++) temp[j++] = ' ';
	else for(i = start; i <= stop; i++) temp[j++] = line[i];
	
	temp[j] = 0;
	fprintf(out, temp);
}

/* Warning -- destructive to str */
char *getstring(char *str)
{
	int j;

	for(j = strlen(str); j >= 0; j--) if(str[j] == '\"') break;
	if(j < 0) return 0;
	str[j] = 0;
	for(j = 0; str[j] > 0; j++) if(str[j] == '\"') break;
	if(str[j] == 0) return 0;

	return g_strdup(str+j+1);
}


int main(int argc, char **argv)
{
	char infile[100], infofile[100], catfile[100], 
		rawfile[100], deffile[100];
	FILE *in, *infoout = 0, *catout, *out;
	char line[1000];
	int i, l, n;
	double coordstack[100];
	int coordlen, iconlen;

	int numinfo, sum = 0, numextra;
	int start[100], stop[100];
	float stack[STACKSIZE], iconstack[100];
	char *name[100];
	opcode *code = 0, *coordcode, *iconcode;
	int index = 0;

	double ra, dec, mag;
	double x, y, z;
	struct object obj;

	if(argc != 2)
	{
		fprintf(stderr, "Usage %s <infile>\n", argv[0]);
		fprintf(stderr, "where <infile> is "
				"the .des file in this directory\n");
		return 0;
	}

	l = strlen(argv[1]);
	if(strcmp(argv[1]+l-4, ".des") == 0) argv[1][l-4] = 0;

	sprintf(infile, "%s.des", argv[1]);

	in = fopen(infile, "r");
	if(in == 0)
	{
		fprintf(stderr, "file not found : %s\n", infile);
		return 0;
	}

	sprintf(deffile, "%s.dex", argv[1]);
	out = fopen(deffile, "w");

//	wgets(line, in);
//	fprintf(out, "%s\n", line);

//	wgets(line, in);
//	fprintf(out, "%s\n", line);

//	wgets(line, in);
//	fprintf(out, "%s\n", line);

//	wgets(line, in);
//	fprintf(out, "%s\n", line);

	wgets(line, in);
	sprintf(rawfile, line);
	printf("Rawfile = %s\n", rawfile);

	wgets(line, in);
	coordcode = compile(line);

	wgets(line, in);
	iconcode = compile(line);

	wgets(line, in);
	code = compile(line);

	wgets(line, in);
	numextra = atoi(line);
	fprintf(out, "%d\n", numextra);
	printf("%d named extra params\n", numextra);

	if(numextra)
	{
		for(i = 0; i < numextra; i++)
		{
			wgets(line, in);
			fprintf(out, "%s\n", line);
			printf("Extra: %s\n", line);
		}
	}

	wgets(line, in);
	sscanf(line, "%d", &numinfo);
	
	printf("%d info fields\n", numinfo);
	
	if(numinfo > 0)
	{
		sprintf(infofile, "%s.info", argv[1]);
		infoout = fopen(infofile, "w");
	
		for(i = 0; i < numinfo; i++)
		{
			l = wgets(line, in);
			if(sscanf(line, "%d%d", start + i, stop + i) < 2)
				fail("Not enough ints in info section\n");
			if(start[i] > stop[i])
				fail("start > stop\n");

			name[i] = getstring(line);
			if(name[i] == 0)
				fail("info section : no string?\n");
			printf("Info : %d %d %s\n", start[i], stop[i], name[i]);
			sum = sum + stop[i] - start[i] + 1;
		}
	
		sum+=strlen("\n");
		fprintf(out, "%d %d\n", numinfo, sum);
		fprintf(out, "%s\n", infofile);

		sum = 0;
		for(i = 0; i < numinfo; i++)
		{
			l = stop[i] - start[i] + 1;
			fprintf(out, "%d %d \"%s\"\n", sum, sum+l-1, name[i]);
			printf("Info params: %d %d %s\n" , sum, sum+l-1, name[i]);
			sum += l;
		}
	}
	else fprintf(out, "0 0\n");

	fclose(in);

	sprintf(catfile, "%s.cat",  argv[1]);
	catout = fopen(catfile,  "w");
	printf("catout = %s\n", catfile);
	in     = fopen(rawfile, "r");
	if(!in) 
	{
		printf("%s not found\n", rawfile);
		fail("Cant open raw file :\n");
	}
	for(n = 0; ; n++)
	{
		l = wgets(line, in);
		if(feof(in)) break;

		coordlen = 0;
		coordstack[0] = n;	// Make available with "u" command
		executed(coordcode, line, coordstack, &coordlen);

		if(coordlen >= 2)
		{
			ra = coordstack[0];
			dec = coordstack[1];
			if(coordlen > 2) mag = coordstack[2]; 
			else mag = 30.0;

			x = cos(ra)*cos(dec);
			y = -sin(ra)*cos(dec);
			z = sin(dec);
	
			obj.x = (long)(x*(double)(1<<30));
			obj.y = (long)(y*(double)(1<<30));
			obj.z = (long)(z*(double)(1<<30));
	
			obj.mag = (int)((mag+2.0)*10.0);
	
			iconlen = 0;
			execute(iconcode, line, iconstack, &iconlen);
	
			obj.type = iconstack[0];
			if(iconlen > 1) obj.icon = iconstack[1];
			else obj.icon = 0;

			obj.mask = 0x0F;
		}
		else 
		{
			printf("n = %d skipped\n", n);
			obj.mask = 0x8F;
		}

		fwrite(&obj, 1, sizeof(obj), catout);

		if(code != 0) execute(code, line, stack, &index);

		if(numinfo > 0) 
		{
			for(i = 0; i < numinfo; i++)
				fprintstr(infoout, line, l, start[i], stop[i]);
			fprintf(infoout, "\n");
		}

		if(index >= STACKSIZE-10)
		{
			printf("Aborting early.  stack overflow.\n");
			break;
		}
	}

	printf("Writing %d extra items\n", index);	

	if(index) fwrite(stack, sizeof(float), index, catout);

	fclose(catout);

	if(numinfo > 0) fclose(infoout);

	printf("%d objects converted\n", n);

	fprintf(out, "%d\n", n);
	fclose(out);

	return 0;
}
