/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath;

import java.io.IOException;
import java.util.Vector;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.xalan.stree.SourceTreeHandler;
import org.apache.xml.utils.SystemIDResolver;
import org.apache.xpath.SourceTree;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.DTDHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class SourceTreeManager {
    private Vector m_sourceTree = new Vector();
    URIResolver m_uriResolver;

    public String findURIFromDoc(Document document) {
        Document document2 = document.getOwnerDocument();
        if (document2 == null) {
            document2 = document;
        }
        String string = null;
        int n = this.m_sourceTree.size();
        int n2 = 0;
        while (n2 < n) {
            SourceTree sourceTree = (SourceTree)this.m_sourceTree.elementAt(n2);
            if (document2 == sourceTree.m_root) {
                string = sourceTree.m_url;
                break;
            }
            ++n2;
        }
        return string;
    }

    public Node getDOMNode(Source source, SourceLocator sourceLocator) throws TransformerException {
        if (source instanceof DOMSource) {
            return ((DOMSource)source).getNode();
        }
        Node node = null;
        try {
            XMLReader xMLReader = this.getXMLReader(source, sourceLocator);
            SourceTreeHandler sourceTreeHandler = new SourceTreeHandler();
            if (sourceTreeHandler instanceof SourceTreeHandler) {
                sourceTreeHandler.setUseMultiThreading(false);
            }
            xMLReader.setContentHandler(sourceTreeHandler);
            if (sourceTreeHandler instanceof DTDHandler) {
                xMLReader.setDTDHandler(sourceTreeHandler);
            }
            try {
                if (sourceTreeHandler instanceof LexicalHandler) {
                    xMLReader.setProperty("http://xml.org/sax/properties/lexical-handler", sourceTreeHandler);
                }
                if (sourceTreeHandler instanceof DeclHandler) {
                    xMLReader.setProperty("http://xml.org/sax/properties/declaration-handler", sourceTreeHandler);
                }
            }
            catch (SAXException sAXException) {}
            try {
                if (sourceTreeHandler instanceof LexicalHandler) {
                    xMLReader.setProperty("http://xml.org/sax/handlers/LexicalHandler", sourceTreeHandler);
                }
                if (sourceTreeHandler instanceof DeclHandler) {
                    xMLReader.setProperty("http://xml.org/sax/handlers/DeclHandler", sourceTreeHandler);
                }
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {}
            InputSource inputSource = SAXSource.sourceToInputSource(source);
            xMLReader.parse(inputSource);
            if (sourceTreeHandler instanceof SourceTreeHandler) {
                node = sourceTreeHandler.getRoot();
            }
        }
        catch (IOException iOException) {
            throw new TransformerException(iOException.getMessage(), sourceLocator, iOException);
        }
        catch (SAXException sAXException) {
            throw new TransformerException(sAXException.getMessage(), sourceLocator, sAXException);
        }
        return node;
    }

    public Node getNode(Source source) {
        String string = source.getSystemId();
        if (string == null) {
            return null;
        }
        Node node = null;
        int n = this.m_sourceTree.size();
        int n2 = 0;
        while (n2 < n) {
            SourceTree sourceTree = (SourceTree)this.m_sourceTree.elementAt(n2);
            if (string.equals(sourceTree.m_url)) {
                node = sourceTree.m_root;
                break;
            }
            ++n2;
        }
        return node;
    }

    public Node getSourceTree(String string, String string2, SourceLocator sourceLocator) throws TransformerException {
        try {
            Source source = this.resolveURI(string, string2, sourceLocator);
            return this.getSourceTree(source, sourceLocator);
        }
        catch (IOException iOException) {
            throw new TransformerException(iOException.getMessage(), sourceLocator, iOException);
        }
    }

    public Node getSourceTree(Source source, SourceLocator sourceLocator) throws TransformerException {
        Node node = this.getNode(source);
        if (node != null) {
            return node;
        }
        node = this.getDOMNode(source, sourceLocator);
        if (node != null) {
            this.putDocumentInCache(node, source);
        }
        return node;
    }

    public URIResolver getURIResolver() {
        return this.m_uriResolver;
    }

    public XMLReader getXMLReader(Source source, SourceLocator sourceLocator) throws TransformerException {
        try {
            XMLReader xMLReader;
            XMLReader xMLReader2 = xMLReader = source instanceof SAXSource ? ((SAXSource)source).getXMLReader() : null;
            if (xMLReader == null) {
                try {
                    SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
                    sAXParserFactory.setNamespaceAware(true);
                    SAXParser sAXParser = sAXParserFactory.newSAXParser();
                    xMLReader = sAXParser.getXMLReader();
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    throw new SAXException(parserConfigurationException);
                }
                catch (FactoryConfigurationError factoryConfigurationError) {
                    throw new SAXException(factoryConfigurationError.toString());
                }
                catch (NoSuchMethodError noSuchMethodError) {
                }
                catch (AbstractMethodError abstractMethodError) {}
                if (xMLReader == null) {
                    xMLReader = XMLReaderFactory.createXMLReader();
                }
            }
            try {
                xMLReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
                xMLReader.setFeature("http://apache.org/xml/features/validation/dynamic", true);
            }
            catch (SAXException sAXException) {}
            return xMLReader;
        }
        catch (SAXException sAXException) {
            throw new TransformerException(sAXException.getMessage(), sourceLocator, sAXException);
        }
    }

    public void putDocumentInCache(Node node, Source source) {
        Node node2 = this.getNode(source);
        if (node2 != null) {
            if (!node2.equals(node)) {
                throw new RuntimeException("Programmer's Error!  putDocumentInCache found reparse of doc: " + source.getSystemId());
            }
            return;
        }
        if (source.getSystemId() != null) {
            this.m_sourceTree.addElement(new SourceTree(node, source.getSystemId()));
        }
    }

    public void reset() {
        this.m_sourceTree = new Vector();
    }

    public Source resolveURI(String string, String string2, SourceLocator sourceLocator) throws TransformerException, IOException {
        Source source = null;
        if (this.m_uriResolver != null) {
            source = this.m_uriResolver.resolve(string2, string);
        }
        if (source == null) {
            String string3 = SystemIDResolver.getAbsoluteURI(string2, string);
            source = new StreamSource(string3);
        }
        return source;
    }

    public void setURIResolver(URIResolver uRIResolver) {
        this.m_uriResolver = uRIResolver;
    }
}

