/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional;

import com.ibm.bsf.BSFException;
import com.ibm.bsf.BSFManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class Script
extends Task {
    private String language;
    private String script = "";
    private Hashtable beans = new Hashtable();

    private void addBeans(Hashtable dictionary) {
        Enumeration e = dictionary.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            boolean isValid = key.length() > 0 && Character.isJavaIdentifierStart(key.charAt(0));
            int i = 1;
            while (isValid && i < key.length()) {
                isValid = Character.isJavaIdentifierPart(key.charAt(i));
                ++i;
            }
            if (!isValid) continue;
            this.beans.put(key, dictionary.get(key));
        }
    }

    public void execute() throws BuildException {
        try {
            this.addBeans(this.project.getProperties());
            this.addBeans(this.project.getUserProperties());
            this.addBeans(this.project.getTargets());
            this.addBeans(this.project.getReferences());
            BSFManager manager = new BSFManager();
            Enumeration e = this.beans.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                Object value = this.beans.get(key);
                manager.declareBean(key, value, value.getClass());
            }
            manager.exec(this.language, "<ANT>", 0, 0, (Object)this.script);
        }
        catch (BSFException be) {
            Throwable t = be;
            Throwable te = be.getTargetException();
            if (te != null) {
                if (te instanceof BuildException) {
                    throw (BuildException)te;
                }
                t = te;
            }
            throw new BuildException(t);
        }
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setSrc(String fileName) {
        File file = new File(fileName);
        if (!file.exists()) {
            throw new BuildException("file " + fileName + " not found.");
        }
        int count = (int)file.length();
        byte[] data = new byte[count];
        try {
            FileInputStream inStream = new FileInputStream(file);
            inStream.read(data);
            inStream.close();
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
        this.script = this.script + new String(data);
    }

    public void addText(String text) {
        this.script = this.script + text;
    }
}

