/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.mm.mysql;

import java.io.UnsupportedEncodingException;

class Buffer {
    byte[] buf;
    int buf_length = 0;
    int pos = 0;
    int send_length = 0;
    static final int NO_LENGTH_LIMIT = -1;
    int max_length = -1;
    static long NULL_LENGTH = -1L;

    Buffer(byte[] buf) {
        this.buf = buf;
        this.buf_length = buf.length;
    }

    Buffer(int size, int max_packet_size) {
        this.buf = new byte[size];
        this.buf_length = this.buf.length;
        this.pos = 4;
        this.max_length = max_packet_size;
    }

    Buffer(int size) {
        this(size, -1);
    }

    final void setBytes(byte[] buf) {
        this.send_length = this.buf_length;
        System.arraycopy(buf, 0, this.buf, 0, this.buf_length);
    }

    final byte readByte() {
        return this.buf[this.pos++];
    }

    final int readInt() {
        byte[] b = this.buf;
        return b[this.pos++] & 0xFF | (b[this.pos++] & 0xFF) << 8;
    }

    final int readLongInt() {
        byte[] b = this.buf;
        return b[this.pos++] & 0xFF | (b[this.pos++] & 0xFF) << 8 | (b[this.pos++] & 0xFF) << 16;
    }

    final long readLong() {
        byte[] b = this.buf;
        return b[this.pos++] & 0xFF | (b[this.pos++] & 0xFF) << 8 | (b[this.pos++] & 0xFF) << 16 | (b[this.pos++] & 0xFF) << 24;
    }

    final long readLongLong() {
        byte[] b = this.buf;
        return (long)(b[this.pos++] & 0xFF) | (long)(b[this.pos++] & 0xFF) << 8 | (long)(b[this.pos++] & 0xFF) << 16 | (long)(b[this.pos++] & 0xFF) << 24 | (long)(b[this.pos++] & 0xFF) << 32 | (long)(b[this.pos++] & 0xFF) << 40 | (long)(b[this.pos++] & 0xFF) << 48 | (long)(b[this.pos++] & 0xFF) << 56;
    }

    final int readnBytes() {
        int sw = this.buf[this.pos++] & 0xFF;
        switch (sw) {
            case 1: {
                return this.buf[this.pos++] & 0xFF;
            }
            case 2: {
                return this.readInt();
            }
            case 3: {
                return this.readLongInt();
            }
            case 4: {
                return (int)this.readLong();
            }
        }
        return 255;
    }

    final long readLength() {
        int sw = this.buf[this.pos++] & 0xFF;
        switch (sw) {
            case 251: {
                return 0L;
            }
            case 252: {
                return this.readInt();
            }
            case 253: {
                return this.readLongInt();
            }
            case 254: {
                return this.readLong();
            }
        }
        return sw;
    }

    final long newReadLength() {
        int sw = this.buf[this.pos++] & 0xFF;
        switch (sw) {
            case 251: {
                return 0L;
            }
            case 252: {
                return this.readInt();
            }
            case 253: {
                return this.readLongInt();
            }
            case 254: {
                return this.readLongLong();
            }
        }
        return sw;
    }

    final long readFieldLength() {
        int sw = this.buf[this.pos++] & 0xFF;
        switch (sw) {
            case 251: {
                return NULL_LENGTH;
            }
            case 252: {
                return this.readInt();
            }
            case 253: {
                return this.readLongInt();
            }
            case 254: {
                return this.readLong();
            }
        }
        return sw;
    }

    final byte[] readByteArray() {
        return this.getNullTerminatedBytes();
    }

    final byte[] readLenByteArray() {
        long len = this.readFieldLength();
        if (len == NULL_LENGTH) {
            return null;
        }
        if (len == 0L) {
            return new byte[0];
        }
        return this.getBytes((int)len);
    }

    final String readString() {
        int i = this.pos;
        int len = 0;
        while (this.buf[i] != 0 && i < this.buf_length) {
            ++len;
            ++i;
        }
        String S = new String(this.buf, this.pos, len);
        this.pos += len + 1;
        return S;
    }

    final String readLenString() {
        long len = this.readFieldLength();
        if (len == NULL_LENGTH) {
            return null;
        }
        if (len == 0L) {
            return "";
        }
        String S = new String(this.buf, this.pos, (int)len);
        this.pos = (int)((long)this.pos + len);
        return S;
    }

    final byte[] getBytes(int len) {
        byte[] b = new byte[len];
        System.arraycopy(this.buf, this.pos, b, 0, len);
        this.pos += len;
        return b;
    }

    final byte[] getNullTerminatedBytes() {
        int i = this.pos;
        int len = 0;
        while (this.buf[i] != 0 && i < this.buf_length) {
            ++len;
            ++i;
        }
        byte[] b = new byte[len];
        System.arraycopy(this.buf, this.pos, b, 0, len);
        this.pos += len + 1;
        return b;
    }

    final boolean isLastDataPacket() {
        return this.buf_length <= 2 && (this.buf[0] & 0xFF) == 254;
    }

    final void clear() {
        this.pos = 4;
    }

    final void writeByte(byte b) {
        this.buf[this.pos++] = b;
    }

    final void writeInt(int i) {
        byte[] b = this.buf;
        b[this.pos++] = (byte)(i & 0xFF);
        b[this.pos++] = (byte)(i >>> 8);
    }

    final void writeLongInt(int i) {
        byte[] b = this.buf;
        b[this.pos++] = (byte)(i & 0xFF);
        b[this.pos++] = (byte)(i >>> 8);
        b[this.pos++] = (byte)(i >>> 16);
    }

    final void writeLong(long i) {
        byte[] b = this.buf;
        b[this.pos++] = (byte)(i & 0xFFL);
        b[this.pos++] = (byte)(i >>> 8);
        b[this.pos++] = (byte)(i >>> 16);
        b[this.pos++] = (byte)(i >>> 24);
    }

    final void writeString(String S) {
        this.writeStringNoNull(S);
        this.buf[this.pos++] = 0;
    }

    final void writeStringNoNull(String S) {
        int len = S.length();
        this.ensureCapacity(len);
        int i = 0;
        while (i < len) {
            this.buf[this.pos++] = (byte)S.charAt(i);
            ++i;
        }
    }

    final void writeStringNoNull(String S, String Encoding) throws UnsupportedEncodingException {
        byte[] b = S.getBytes(Encoding);
        int len = b.length;
        this.ensureCapacity(len);
        System.arraycopy(b, 0, this.buf, this.pos, len);
        this.pos += len;
    }

    final void writeBytesNoNull(byte[] Bytes) {
        int len = Bytes.length;
        this.ensureCapacity(len);
        System.arraycopy(Bytes, 0, this.buf, this.pos, len);
        this.pos += len;
    }

    final void ensureCapacity(int additional_data) {
        if (this.pos + additional_data > this.buf_length) {
            if (this.max_length != -1 && this.buf_length + (int)(1.25 * (double)additional_data) > this.max_length) {
                throw new IllegalArgumentException("Packet is larger than max_allowed_packet from server configuration of " + this.max_length + " bytes");
            }
            int new_length = this.buf_length + (int)(1.25 * (double)additional_data);
            byte[] NewBytes = new byte[new_length];
            System.arraycopy(this.buf, 0, NewBytes, 0, this.buf.length);
            this.buf = NewBytes;
            this.buf_length = this.buf.length;
        }
    }

    final void dump() {
        int p = 0;
        int rows = this.buf_length / 8;
        int i = 0;
        while (i < rows) {
            int ptemp = p;
            int j = 0;
            while (j < 8) {
                String HexVal = Integer.toHexString(this.buf[ptemp]);
                if (HexVal.length() == 1) {
                    HexVal = "0" + HexVal;
                }
                System.out.print(String.valueOf(HexVal) + " ");
                ++ptemp;
                ++j;
            }
            System.out.print("    ");
            j = 0;
            while (j < 8) {
                if (this.buf[p] > 32 && this.buf[p] < 127) {
                    System.out.print((char)this.buf[p] + " ");
                } else {
                    System.out.print(". ");
                }
                ++p;
                ++j;
            }
            System.out.println();
            ++i;
        }
        int n = 0;
        int i2 = p;
        while (i2 < this.buf_length) {
            String HexVal = Integer.toHexString(this.buf[i2]);
            if (HexVal.length() == 1) {
                HexVal = "0" + HexVal;
            }
            System.out.print(String.valueOf(HexVal) + " ");
            ++n;
            ++i2;
        }
        i2 = n;
        while (i2 < 8) {
            System.out.print("   ");
            ++i2;
        }
        System.out.print("    ");
        i2 = p;
        while (i2 < this.buf_length) {
            if (this.buf[i2] > 32 && this.buf[i2] < 127) {
                System.out.print((char)this.buf[i2] + " ");
            } else {
                System.out.print(". ");
            }
            ++i2;
        }
        System.out.println();
    }
}

