/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.net;

import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.helpers.CyclicBuffer;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.net.DefaultEvaluator;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.TriggeringEventEvaluator;

public class SMTPAppender
extends AppenderSkeleton {
    public static final String TO_OPTION = "To";
    public static final String FROM_OPTION = "From";
    public static final String SUBJECT_OPTION = "Subject";
    public static final String SMTP_HOST_OPTION = "SMTPHost";
    public static final String BUFFER_SIZE_OPTION = "BufferSize";
    public static final String EVALUATOR_CLASS_OPTION = "EvaluatorClass";
    public static final String LOCATION_INFO_OPTION = "LocationInfo";
    String to;
    String from;
    String subject;
    String smtpHost;
    int bufferSize = 512;
    CyclicBuffer cb = new CyclicBuffer(this.bufferSize);
    Session session;
    Message msg;
    boolean locationInfo = false;
    TriggeringEventEvaluator evaluator;
    private static /* synthetic */ Class class$Lorg$apache$log4j$spi$TriggeringEventEvaluator;

    public void activateOptions() {
        Properties properties = System.getProperties();
        if (this.smtpHost != null) {
            ((Hashtable)properties).put("mail.smtp.host", this.smtpHost);
        }
        this.session = Session.getDefaultInstance((Properties)properties, null);
        this.msg = new MimeMessage(this.session);
        try {
            if (this.from != null) {
                this.msg.setFrom((Address)this.getAddress(this.from));
            } else {
                this.msg.setFrom();
            }
            this.msg.setRecipients(Message.RecipientType.TO, (Address[])this.parseAddress(this.to));
            if (this.subject != null) {
                this.msg.setSubject(this.subject);
            }
        }
        catch (MessagingException messagingException) {
            LogLog.error("Could not activate SMTPAppender options.", messagingException);
        }
    }

    public void append(LoggingEvent loggingEvent) {
        if (!this.checkEntryConditions()) {
            return;
        }
        loggingEvent.getThreadName();
        loggingEvent.getNDC();
        if (this.locationInfo) {
            loggingEvent.setLocationInformation();
        }
        this.cb.add(loggingEvent);
        if (this.evaluator.isTriggeringEvent(loggingEvent)) {
            this.sendBuffer();
        }
    }

    protected boolean checkEntryConditions() {
        if (this.msg == null) {
            this.errorHandler.error("Message object not configured.");
            return false;
        }
        if (this.evaluator == null) {
            this.errorHandler.error("No TriggeringEventEvaluator is set for appender [" + this.name + "].");
            return false;
        }
        if (this.layout == null) {
            this.errorHandler.error("No layout set for appender named [" + this.name + "].");
            return false;
        }
        return true;
    }

    public void close() {
        this.closed = true;
    }

    InternetAddress getAddress(String string) {
        try {
            return new InternetAddress(string);
        }
        catch (AddressException addressException) {
            this.errorHandler.error("Could not parse address [" + string + "].", (Exception)((Object)addressException), 6);
            return null;
        }
    }

    public String[] getOptionStrings() {
        return OptionConverter.concatanateArrays(super.getOptionStrings(), new String[]{TO_OPTION, FROM_OPTION, SUBJECT_OPTION, SMTP_HOST_OPTION, BUFFER_SIZE_OPTION, EVALUATOR_CLASS_OPTION, LOCATION_INFO_OPTION});
    }

    InternetAddress[] parseAddress(String string) {
        try {
            return InternetAddress.parse((String)string, (boolean)true);
        }
        catch (AddressException addressException) {
            this.errorHandler.error("Could not parse address [" + string + "].", (Exception)((Object)addressException), 6);
            return null;
        }
    }

    public boolean requiresLayout() {
        return true;
    }

    protected void sendBuffer() {
        try {
            MimeBodyPart mimeBodyPart = new MimeBodyPart();
            StringBuffer stringBuffer = new StringBuffer();
            String string = this.layout.getHeader();
            if (string != null) {
                stringBuffer.append(string);
            }
            int n = this.cb.length();
            int n2 = 0;
            while (n2 < n) {
                stringBuffer.append(this.layout.format(this.cb.get()));
                ++n2;
            }
            string = this.layout.getFooter();
            if (string != null) {
                stringBuffer.append(string);
            }
            mimeBodyPart.setContent((Object)stringBuffer.toString(), this.layout.getContentType());
            MimeMultipart mimeMultipart = new MimeMultipart();
            mimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
            this.msg.setContent((Multipart)mimeMultipart);
            this.msg.setSentDate(new Date());
            Transport.send((Message)this.msg);
        }
        catch (Exception exception) {
            LogLog.error("Error occured while sending e-mail notification.", exception);
        }
    }

    public void setOption(String string, String string2) {
        if (string2 == null) {
            return;
        }
        super.setOption(string, string2);
        if (string.equals(TO_OPTION)) {
            this.to = string2;
        } else if (string.equals(FROM_OPTION)) {
            this.from = string2;
        } else if (string.equals(SMTP_HOST_OPTION)) {
            this.smtpHost = string2;
        } else if (string.equals(SUBJECT_OPTION)) {
            this.subject = string2;
        } else if (string.equals(EVALUATOR_CLASS_OPTION)) {
            this.evaluator = (TriggeringEventEvaluator)OptionConverter.instantiateByClassName(string2, class$Lorg$apache$log4j$spi$TriggeringEventEvaluator != null ? class$Lorg$apache$log4j$spi$TriggeringEventEvaluator : (class$Lorg$apache$log4j$spi$TriggeringEventEvaluator = SMTPAppender.class$("org.apache.log4j.spi.TriggeringEventEvaluator")), this.evaluator);
        } else if (string.equals(BUFFER_SIZE_OPTION)) {
            this.bufferSize = OptionConverter.toInt(string2, this.bufferSize);
            this.cb.resize(this.bufferSize);
        } else if (string.equals(LOCATION_INFO_OPTION)) {
            this.locationInfo = OptionConverter.toBoolean(string2, this.locationInfo);
        }
    }

    static /* synthetic */ boolean access$1(SMTPAppender sMTPAppender) {
        return sMTPAppender.closed;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public SMTPAppender() {
        this(new DefaultEvaluator());
    }

    public SMTPAppender(TriggeringEventEvaluator triggeringEventEvaluator) {
        this.evaluator = triggeringEventEvaluator;
    }
}

