/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;

class EditorWindow
extends FixedFrame
implements CbButtonCallback {
    TextField name;
    TextArea edit;
    CbButton save_b;
    CbButton saveclose_b;
    CbButton cancel_b;
    CbButton goto_b;
    CbButton find_b;
    RemoteFile file;
    FileManager filemgr;
    GotoWindow goto_window;
    FindReplaceWindow find_window;

    EditorWindow(RemoteFile remoteFile, FileManager fileManager) {
        super(500, 300);
        this.file = remoteFile;
        this.filemgr = fileManager;
        this.makeUI(false);
        this.setTitle(this.filemgr.text("edit_title", this.file.path));
        try {
            byte[] byArray;
            URL uRL = new URL(this.filemgr.getDocumentBase(), "show.cgi" + FileManager.urlize(this.file.path) + "?rand=" + System.currentTimeMillis() + "&trust=" + this.filemgr.trust + "&edit=1" + this.filemgr.extra);
            URLConnection uRLConnection = uRL.openConnection();
            this.filemgr.set_cookie(uRLConnection);
            int n = uRLConnection.getContentLength();
            InputStream inputStream = uRLConnection.getInputStream();
            if (n >= 0) {
                byArray = new byte[uRLConnection.getContentLength()];
                int n2 = 0;
                while (n2 < byArray.length) {
                    n2 += inputStream.read(byArray, n2, byArray.length - n2);
                }
            } else {
                byArray = new byte[]{};
                while (true) {
                    int n3;
                    byte[] byArray2 = new byte[16384];
                    try {
                        n3 = inputStream.read(byArray2);
                    }
                    catch (EOFException eOFException) {
                        break;
                    }
                    if (n3 <= 0) break;
                    byte[] byArray3 = new byte[byArray.length + n3];
                    System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
                    System.arraycopy(byArray2, 0, byArray3, byArray.length, n3);
                    byArray = byArray3;
                }
            }
            this.edit.setText(new String(byArray, 0));
            inputStream.close();
            this.file.size = byArray.length;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    EditorWindow(String string, FileManager fileManager) {
        super(500, 300);
        this.filemgr = fileManager;
        this.makeUI(true);
        this.setTitle(this.filemgr.text("edit_title2"));
        this.name.setText(string.equals("/") ? string : string + "/");
        this.name.select(this.name.getText().length(), this.name.getText().length());
    }

    void makeUI(boolean bl) {
        Panel panel;
        this.setLayout(new BorderLayout());
        if (bl) {
            panel = new Panel();
            panel.setLayout(new BorderLayout());
            panel.add("West", new Label(this.filemgr.text("edit_filename")));
            this.name = new TextField();
            panel.add("Center", this.name);
            this.name.setFont(this.filemgr.fixed);
            this.add("North", panel);
        }
        this.edit = new TextArea(20, 80);
        this.add("Center", this.edit);
        this.edit.setFont(this.filemgr.fixed);
        panel = new Panel();
        panel.setLayout(new FlowLayout(2));
        this.goto_b = new CbButton(this.filemgr.get_image("goto.gif"), this.filemgr.text("edit_goto"), 0, this);
        panel.add(this.goto_b);
        this.find_b = new CbButton(this.filemgr.get_image("find.gif"), this.filemgr.text("edit_find"), 0, this);
        panel.add(this.find_b);
        panel.add(new Label(" "));
        this.save_b = new CbButton(this.filemgr.get_image("save.gif"), this.filemgr.text("save"), 0, this);
        panel.add(this.save_b);
        this.saveclose_b = new CbButton(this.filemgr.get_image("save.gif"), this.filemgr.text("edit_saveclose"), 0, this);
        panel.add(this.saveclose_b);
        this.cancel_b = new CbButton(this.filemgr.get_image("cancel.gif"), this.filemgr.text("close"), 0, this);
        panel.add(this.cancel_b);
        this.add("South", panel);
        Util.recursiveBody(this);
        this.pack();
        this.show();
    }

    public void click(CbButton cbButton) {
        if (cbButton == this.save_b || cbButton == this.saveclose_b) {
            String string;
            String string2;
            RemoteFile remoteFile = null;
            RemoteFile remoteFile2 = null;
            if (this.file == null) {
                int n;
                string2 = this.filemgr.trim_path(this.name.getText());
                remoteFile = this.filemgr.find_directory(string2.substring(0, n = string2.lastIndexOf(47)), false);
                if (remoteFile == null) {
                    return;
                }
                remoteFile2 = remoteFile.find(string2.substring(n + 1));
                if (remoteFile2 != null && (remoteFile2.type == 0 || remoteFile2.type == 5)) {
                    new ErrorWindow(this.filemgr.text("edit_eover", string2));
                    return;
                }
            } else {
                string2 = this.file.path;
            }
            String string3 = this.edit.getText();
            try {
                URL uRL = new URL(this.filemgr.getDocumentBase(), "save.cgi" + FileManager.urlize(string2) + "?rand=" + System.currentTimeMillis() + "&trust=" + this.filemgr.trust + "&length=" + string3.length() + this.filemgr.extra);
                URLConnection uRLConnection = uRL.openConnection();
                this.filemgr.set_cookie(uRLConnection);
                uRLConnection.setDoOutput(true);
                OutputStream outputStream = uRLConnection.getOutputStream();
                byte[] byArray = new byte[string3.length()];
                string3.getBytes(0, byArray.length, byArray, 0);
                outputStream.write(byArray);
                outputStream.close();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
                String string4 = bufferedReader.readLine();
                if (string4.length() > 0) {
                    new ErrorWindow(this.filemgr.text("edit_esave", string4));
                    bufferedReader.close();
                    return;
                }
                string = bufferedReader.readLine();
                bufferedReader.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
            if (this.file == null) {
                this.file = new RemoteFile(this.filemgr, string, remoteFile);
                if (remoteFile2 != null) {
                    remoteFile2.type = this.file.type;
                    remoteFile2.user = this.file.user;
                    remoteFile2.group = this.file.group;
                    remoteFile2.size = this.file.size;
                    remoteFile2.perms = this.file.perms;
                    remoteFile2.modified = this.file.modified;
                } else {
                    remoteFile.add(this.file);
                }
            } else {
                this.file.size = string3.length();
                this.file.modified = System.currentTimeMillis();
            }
            this.filemgr.show_files(this.filemgr.showing_files);
            if (cbButton == this.saveclose_b) {
                this.dispose();
            }
        } else if (cbButton == this.cancel_b) {
            this.dispose();
        } else if (cbButton == this.goto_b) {
            if (this.goto_window != null) {
                this.goto_window.toFront();
            } else {
                this.goto_window = new GotoWindow(this);
            }
        } else if (cbButton == this.find_b) {
            if (this.find_window != null) {
                this.find_window.toFront();
            } else {
                this.find_window = new FindReplaceWindow(this);
            }
        }
    }

    public void dispose() {
        super.dispose();
        if (this.goto_window != null) {
            this.goto_window.dispose();
        }
        if (this.find_window != null) {
            this.find_window.dispose();
        }
    }
}

