/*
   Copyright (C) 1997-2001 Id Software, Inc.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

   See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

 */

#include "../g_local.h"
#include "ai_local.h"

//AI_HELPERS
//
//	Taken and modified (or not) from g_ai.c
//

//=============
//visible
//returns 1 if the entity is visible to self, even if not infront ()
//=============
qboolean AI_visible( edict_t *self, edict_t *other )
{
	vec3_t spot1;
	vec3_t spot2;
	trace_t	trace;

	VectorCopy( self->s.origin, spot1 );
	spot1[2] += self->viewheight;
	VectorCopy( other->s.origin, spot2 );
	spot2[2] += other->viewheight;
	G_Trace( &trace, spot1, vec3_origin, vec3_origin, spot2, self, MASK_OPAQUE );
	//trace = gi.trace( spot1, vec3_origin, vec3_origin, spot2, self, MASK_OPAQUE );

	if( trace.fraction == 1.0 )
		return qtrue;
	return qfalse;
}


//=============
//infront
//returns 1 if the entity is in front (in sight) of self
//=============
qboolean AI_infront( edict_t *self, edict_t *other )
{
	vec3_t vec;
	float dot;
	vec3_t forward;

	AngleVectors( self->s.angles, forward, NULL, NULL );
	VectorSubtract( other->s.origin, self->s.origin, vec );
	VectorNormalizeFast( vec );
	dot = DotProduct( vec, forward );

	if( dot > 0.3 )
		return qtrue;
	return qfalse;
}


//=============
//inView
//returns 1 if the entity is in view field to self (in front and not blocked)
//=============
#if 0
qboolean AI_inView( edict_t *self, edict_t *other )
{
	vec3_t vec;
	float dot;
	vec3_t forward;
	float MONSTER_VIEWDISTANCE = 1000.0f; //jalfixme: make a class based field
	float MONSTER_VIEWSIZE = 0.3f; //jalfixme: make a class based field

	//too far away for our view capabilities
	if( DistanceFast( self->s.origin, other->s.origin ) > MONSTER_VIEWDISTANCE )
		return qfalse;

	//check if in front
	AngleVectors( self->s.angles, forward, NULL, NULL );
	VectorSubtract( other->s.origin, self->s.origin, vec );
	VectorNormalizeFast( vec );
	dot = DotProduct( vec, forward );
	if( dot < MONSTER_VIEWSIZE )
		return qfalse;

	if( !AI_visible( self, other ) )  //blocked
		return qfalse;

	return qtrue;
}
#endif

void AI_NewEnemyInView( edict_t *self, edict_t *enemy )
{
	if( enemy )
	{
		if( G_IsTeamDamage( self, enemy ) || enemy == self || enemy->ai.notarget )
		{
			return;
		}
	}

	self->ai.latched_enemy = enemy;
	self->ai.enemyReactionDelay = ( 50 + ( AI_REACTION_TIME * ( 1.0f - self->ai.pers.skillLevel ) ) );
}


//=============
//AI_Sounds
//
//=============



//==========================================
//
//			COMMANDS
//
//==========================================

void Cmd_ShowPLinks_f( edict_t *ent )
{
	if( !sv_cheats->integer )
	{
		G_PrintMsg( ent, "Cheats are not enabled in this server\n" );
		AIDevel.showPLinks = qfalse;
		AIDevel.plinkguy = NULL;
		return;
	}

	if( AIDevel.showPLinks == qfalse )
	{
		AIDevel.showPLinks = qtrue;
		AIDevel.plinkguy = ent;

	}
	else
	{
		AIDevel.showPLinks = qfalse;
		AIDevel.plinkguy = NULL;
	}
}
