/* ------------------------------------------------------------------------
 * $Id: EmitterImpl.hh,v 1.4 2001/08/28 13:18:50 elm Exp $
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * ------------------------------------------------------------------------
 * File created 2001-04-22 by Niklas Elmqvist.
 *
 * Copyright (c) 2001 Niklas Elmqvist <elm@3dwm.org>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------
 */

#ifndef _EmitterImpl_hh_
#define _EmitterImpl_hh_

// -- System Includes
#include <list>

// -- 3Dwm Includes
#include "Nobel/CORBA.hh"
#include "Nobel/Event.hh"

// -- Forward Declarations
class Mutex;

// -- Class Declarations

class EmitterImpl : public virtual POA_Nobel::Emitter,
		    public virtual PortableServer::RefCountServantBase {
public:

    /**
     * Destructor.
     **/
    virtual ~EmitterImpl();
    
    // IDL Functions
    virtual void emit(const Nobel::Event &e);
    virtual void addListener(Nobel::Listener_ptr l);
    virtual void removeListener(Nobel::Listener_ptr l);
    virtual void clearListeners();
    
protected:
    
    /**
     * Protected constructor (abstract base class).
     **/
    EmitterImpl() { }

    /**
     * Emit a "SubjectChanged" event signifying to all listeners that
     * this subject has been modified.
     **/
    void emitSubjectChanged();
	
private:
    std::list<Nobel::Listener_var> _listeners;
    Mutex _emutex;
};

#endif /* EmitterImpl.hh */
