/* ------------------------------------------------------------------------
 * $Id: VrmlLoader.hh,v 1.1 2001/04/21 15:33:10 elm Exp $
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * ------------------------------------------------------------------------
 * File created 2000-12-09 by Niklas Elmqvist.
 *
 * Copyright (c) 2000 Niklas Elmqvist <elm@3dwm.org>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------
 */

#ifndef _VrmlLoader_hh_
#define _VrmlLoader_hh_

// -- 3Dwm Includes
#include <Nobel/Node.hh>
#include <Nobel/NodeKit.hh>
#include <Nobel/GeometryKit.hh>

// -- Forward Declarations
class VrmlNode;

// -- Class Declarations

namespace Nobel {

    /**
     * VRML file loading class. This is a support class intended for
     * C++ programmers who need a quick and effortless way of loading
     * VRML (.wrl) files into the 3Dwm display server. Simply create a
     * VrmlLoader instance and then call the load() method to turn a
     * .wrl file into a corresponding scene graph subtree that can be
     * inserted into the server scene graph where desired.
     * 
     * @@@ When needed, refactor into an abstract geometry file loading
     * class. Possibly even refactor ImageLoader into same hierarchy.
     * If it doesn't acquire any state, turn it into a function!
     **/
    class VrmlLoader {
	
    public:
	
	/**
	 * Constructor.
	 **/
	VrmlLoader();

	/**
	 * Destructor.
	 **/
	~VrmlLoader();
	
	/**
	 * Load a VRML file and create a corresponding shape scene
	 * graph hierarchy. 
	 *
	 * @param filename the file to load (possibly an URL)
	 * @param node_kit a node kit for constructing new nodes.
	 * @param geo_kit a geometry kit for constructing geometry nodes.
	 * @return the root of the 3Dwm scene graph hierarchy
	 **/
	Node_ptr load(const char *filename, Nobel::NodeKit_ptr node_kit,
		      Nobel::GeometryKit_ptr geo_kit);
    };
};

#endif /* VrmlLoader.hh */
