<?
/*
+-------------------------------------------------------------------+
| BasiliX - Copyright (C) 2000 Murat Arslan <arslanm@cyberdude.com> |
+-------------------------------------------------------------------+
*/

// Folder related functions, create mbox, folder list, etc..
// ------------------------------------------------------------------
function crt_sentmail($imap) {
    global $BSX_SENTMAIL, $lng;
    if(@$imap->crtmbox($BSX_SENTMAIL) == false)
      err_exit($lng->p(182));
}

function crt_trash($imap) {
    global $BSX_TRASH, $lng;
    if(@$imap->crtmbox($BSX_TRASH) == false)
     err_exit($lng->p(181));
}

function folder_list(&$total, &$mbox_cnt, $stype, $sep) {
    global $imap, $BSX_MDIR;

    // list the folders of the user
    $total["msg"] = 0;
    $total["size"] = 0;
    $total["unread"] = 0;

    // first inbox
    $inbox_info = $imap->mboxinfo();
    $inbox_nmsgs = $inbox_info->Nmsgs;
    $inbox_unread = $inbox_info->Unread;
    $inbox_size = $inbox_info->Size;
    $mboxes[0]["name"] = "Inbox";
    $mboxes[0]["unread"] = $inbox_unread;
    $mboxes[0]["nmsgs"] = $inbox_nmsgs;
    $mboxes[0]["size"] = convert_size($inbox_size);
    $total["msg"] += $inbox_nmsgs;
    $total["size"] += $inbox_size;
    $total["unread"] += $inbox_unread;

    // then other mboxes
    if($stype == 2)  // Cyrus IMAPd
       $other_list = $imap->lstscrbed($BSX_MDIR . "%");
    else if($stype == 1)  // wu-imapd
       $other_list = $imap->lstmbox($BSX_MDIR . "%");
    
    if(!$other_list) {
       crt_sentmail($imap);
       crt_trash($imap);    
       if($stype == 2)  // Cyrus IMAPd
          $other_list = $imap->lstscrbed($BSX_MDIR . "%");
       else if($stype == 1)  // wu-imapd
          $other_list = $imap->lstmbox($BSX_MDIR . "%");
       if(!$other_list) return false;
    }

    for($mbox_cnt = 1 ; $mbox_cnt <= count($other_list) ; $mbox_cnt++) {
       $j = $mbox_cnt - 1;
       if(!$imap->reopbox2($other_list[$j])) return array();
       $other_info = $imap->mboxinfo();
       $other_arr = explode($sep, $other_info->Mailbox);
       $j = count($other_arr) - 1;
       $mboxes[$mbox_cnt]["name"] = imap_utf7_decode($other_arr[$j]);
       $total["unread"] += $mboxes[$mbox_cnt]["unread"] = $other_info->Unread;
       $total["msg"] += $mboxes[$mbox_cnt]["nmsgs"] = $other_info->Nmsgs;
       $total["size"] += $mbox_size = $other_info->Size;
       $mboxes[$mbox_cnt]["size"] = convert_size($mbox_size);
    }
    return $mboxes;
}

function empty_folder($mbox) {
    global $BSX_MDIR, $imap;

    if(strtoupper($mbox) != "INBOX") {
       $bsx_mbox = $BSX_MDIR . $mbox;
       $imap->reopbox($bsx_mbox);
    } else $bsx_mbox = "Inbox";

    $mbox_info = $imap->mboxinfo();
    $mbox_nmsgs = $mbox_info->Nmsgs;
    
    $seq = "1";
    for($i = 2 ; $i <= $mbox_info->Nmsgs ; $i++) $seq .= ",$i";

    if(!$imap->setflg($seq, "\\Deleted")) return false;
    $imap->expng();
    return true;
}
?>
