# Copyright 2001, Hewlett-Packard Corporation
# This file contains all of the HP-unique subroutines
# $Id: HP_API.pm,v 1.42 2002/02/19 17:32:38 hpbuck Exp $

####################################################################
#
#  This module makes up the HP-UX specific API routines.
#  
####################################################################
#
#  Subroutine Listing:
#     &HP_ConfigureForDistro: adds all used file names to global
#                             hashes and generates a global IPD
#                             hash for SD modification lookup.
#
#     &getGlobalSwlist($):    Takes a fully qualified file name
#                             and returns product:filset info
#                             for that file.  returns undef if
#                             the file is not present in the IPD
#
#     &B_swmodify($):         Takes a file name and runs the
#                             swmodify command on it so that the
#                             IPD is updated after changes
#
#     &B_System($$):          Takes a system command and the system
#                             command that should be used to undo
#                             whatever was done. Returns 1 on 
#                             success and 0 on failure
#
#     &B_ch_rc($$):           Takes a the rc.config.d flag name and
#                             new value as well as the init script
#                             location. This will stop a services
#                             and set the service so that it will
#                             not be restarted.
#
#     &B_TODO($):             Appends the give string to the TODO.txt
#                             file.
#
#     &B_chperm($$$$):        Takes new perm owner and group of given
#                             file.  TO BE DEPRICATED!!!
#
#     &B_install_jail($$):    Takes the jail name and the jail config
#                             script location for a give jail...
#                             These scripts can be found in the main
#                             directory e.g. jail.bind.hpux
#
#####################################################################

##############################################################################
#
#                     HP-UX Bastille v1.3 directory structure
#
##############################################################################
#
#  /opt/sec_mgmt/bastille/bin/   -- location of Bastille binaries
#  /opt/sec_mgmt/bastille/lib/   -- location of Bastille modules
#  /opt/sec_mgmt/bastille/doc/   -- location of Bastille doc files
#
#  /etc/opt/sec_mgmt/bastille/   -- location of Bastille config files
#
#  /var/opt/sec_mgmt/bastille/log         -- location of Bastille log files
#  /var/opt/sec_mgmt/bastille/undo        -- directory holding all Bastille-
#                                            created undo scripts
#  /var/opt/sec_mgmt/bastille/undo/backup -- directory holding the original
#                                            files that Bastille modifies,
#                                            with permissions intact
#
##############################################################################



#####################################################################
# HP_ConfigureForDistro:  This subroutine is run when Bastilles
#    API is initiated.  HP-UX specific and configures Bastilles
#    GLOBAL_* Hashes for the rest of the implementation.
#####################################################################

sub HP_ConfigureForDistro {
    my $returnval=1;
    
    if ($GLOBAL_DISTRO =~ "^HP-UX11"){

	# First, let's make sure that we do not create any files or 
        # directories with more permissive permissions than we 
        # intend via setting the perl umask
	umask(077);
	# Original "Prepare to Run" Global Variables

	$GLOBAL_BDIR{"log"} = $GLOBAL_PREFIX . "/var/opt/sec_mgmt/bastille/log";
	$GLOBAL_BFILE{"action-log"} = &getGlobal('BDIR', "log") . "/action-log";	
	$GLOBAL_BFILE{"error-log"} = &getGlobal('BDIR', "log") . "/error-log";
	$GLOBAL_BDIR{"undo"}= $GLOBAL_PREFIX . "/var/opt/sec_mgmt/bastille/undo";
	$GLOBAL_BDIR{"backup"}= &getGlobal('BDIR', "undo") . "/backup";
	$GLOBAL_BDIR{"config"} = $GLOBAL_PREFIX . "/etc/opt/sec_mgmt/bastille";
	$GLOBAL_BDIR{"home"}= $GLOBAL_PREFIX ."/etc/opt/sec_mgmt/bastille";
	$GLOBAL_BDIR{"share"}= $GLOBAL_PREFIX . "/etc/opt/sec_mgmt/bastille";
	$GLOBAL_BDIR{"jail"} =  $GLOBAL_PREFIX . "/var/jail";
	$GLOBAL_BDIR{"apachejail"} = &getGlobal('BDIR',"jail") . "/apache";
	

	$GLOBAL_BFILE{"config"} = &getGlobal('BDIR', "config") . "/config";
	$GLOBAL_BFILE{"undo-actions"}= &getGlobal('BDIR', "undo") . "/undo-actions";
	$GLOBAL_BFILE{"undo-directory-perms.sh"}=&getGlobal('BDIR', "undo") . "/undo-directory-perms.sh";
	$GLOBAL_BFILE{"credits"}="/opt/sec_mgmt/bastille/docs/Credits";
	$GLOBAL_BFILE{"TODO"}= "/var/opt/sec_mgmt/bastille/TODO.txt";
	$GLOBAL_BFILE{"TOUNDO"}= "/var/opt/sec_mgmt/bastille/TOUNDO.txt";
	$GLOBAL_BFILE{"directory-perms.sh"} = "/var/opt/sec_mgmt/bastille/directory-perms.sh";
	$GLOBAL_BFILE{"Xaccess.bastille"}="/etc/dt/config/Xaccess.bastille";
	$GLOBAL_BFILE{"Xconfig"}="/etc/dt/config/Xconfig";
	$GLOBAL_BFILE{"jail.generic.hpux"}= &getGlobal('BDIR','config') . "/jail.generic.hpux";
	$GLOBAL_BFILE{"jail.bind.hpux"}= &getGlobal('BDIR','config') . "/jail.bind.hpux";
	$GLOBAL_BFILE{"jail.bind9.hpux"}= &getGlobal('BDIR','config') . "/jail.bind9.hpux";
	$GLOBAL_BFILE{"nodisclaimer"}=    &getGlobal('BDIR', "home") . "/.nodisclaim";

	# Set necessary binaries
	$GLOBAL_BIN{"at"}="/usr/bin/at";
	$GLOBAL_BIN{"cat"}="/usr/bin/cat";
	$GLOBAL_BIN{"ch_rc"}="/usr/sbin/ch_rc";
	$GLOBAL_BIN{"clear"}="/usr/bin/clear";
	$GLOBAL_BIN{"crontab"}="/usr/bin/crontab";
	$GLOBAL_BIN{"cut"}="/usr/bin/cut";
	$GLOBAL_BIN{"dtlogin.rc"}="/sbin/init.d/dtlogin.rc";
	$GLOBAL_BIN{"dump"}="/usr/sbin/dump";
	$GLOBAL_BIN{"echo"}="/usr/bin/echo";
	$GLOBAL_BIN{"inetd"}="/usr/sbin/inetd";
	$GLOBAL_BIN{"lpalt"}="/usr/bin/lpalt";
	$GLOBAL_BIN{"more"}="/usr/bin/more";
	$GLOBAL_BIN{"ping"}="/usr/sbin/ping";
	$GLOBAL_BIN{"rcp"}="/usr/bin/rcp";
	$GLOBAL_BIN{"rdist"}="/usr/bin/rdist";
	$GLOBAL_BIN{"restore"}="/sbin/restore";
	$GLOBAL_BIN{"rexec"}="/usr/bin/rexec";
	$GLOBAL_BIN{"rexecd"}="/usr/lbin/rexecd";
	$GLOBAL_BIN{"rlogin"}="/usr/bin/rlogin";
	$GLOBAL_BIN{"rlogind"}="/usr/lbin/rlogind";
	$GLOBAL_BIN{"rsh"}="/usr/bin/remsh";
	$GLOBAL_BIN{"rshd"}="/usr/lbin/remshd";
	$GLOBAL_BIN{"traceroute"}="/usr/contrib/bin/traceroute";
        $GLOBAL_BIN{"chmod"}="/usr/bin/chmod";
        $GLOBAL_BIN{"chown"}="/usr/bin/chown";
        $GLOBAL_BIN{"chgrp"}="/usr/bin/chgrp";
        $GLOBAL_BIN{"cp"}="/usr/bin/cp";
        $GLOBAL_BIN{"diff"}="/usr/bin/diff";
	$GLOBAL_BIN{"grep"}="/usr/bin/grep";
        $GLOBAL_BIN{"groupadd"}="/usr/sbin/groupadd";
        $GLOBAL_BIN{"groupdel"}="/usr/sbin/groupdel";
        $GLOBAL_BIN{"killall"}="/usr/sbin/killall";
        $GLOBAL_BIN{"kmtune"}="/usr/sbin/kmtune";
	$GLOBAL_BIN{"ln"}="/usr/bin/ln";
        $GLOBAL_BIN{"lpq"}="/usr/bin/lpstat";
        $GLOBAL_BIN{"lpr"}="/usr/bin/lp";
        $GLOBAL_BIN{"lprm"}="/usr/bin/cancel";
	$GLOBAL_BIN{"mk_kernel"}="/usr/sbin/mk_kernel";
        $GLOBAL_BIN{"mknod"}="/usr/sbin/mknod";
        $GLOBAL_BIN{"mkfifo"}="/usr/bin/mkfifo";
        $GLOBAL_BIN{"modprdef"}="/usr/lbin/modprdef";
        $GLOBAL_BIN{"mount"}="/usr/sbin/mount";
        $GLOBAL_BIN{"mv"}="/usr/bin/mv";	
        $GLOBAL_BIN{"named-xfer"}="/usr/sbin/named-xfer";
        $GLOBAL_BIN{"ndd"}="/usr/bin/ndd";
        $GLOBAL_BIN{"swacl"}="/usr/sbin/swacl";
	$GLOBAL_BIN{"swlist"}="/usr/sbin/swlist";
	$GLOBAL_BIN{"swmodify"}="/usr/sbin/swmodify";
	$GLOBAL_BIN{"syslogd"}="/usr/sbin/syslogd";	
        $GLOBAL_BIN{"tsconvert"}="/usr/lbin/tsconvert";
        $GLOBAL_BIN{"umask"}="/usr/bin/umask";
        $GLOBAL_BIN{"umount"}="/usr/sbin/umount";
        $GLOBAL_BIN{"useradd"}="/usr/sbin/useradd";
        $GLOBAL_BIN{"userdel"}="/usr/sbin/userdel";
	$GLOBAL_BIN{"rm"}="/usr/bin/rm";
	$GLOBAL_BIN{"rmdir"}="/usr/bin/rmdir";
	$GLOBAL_BIN{"sendmail"}="/usr/sbin/sendmail";
        $GLOBAL_BIN{"touch"}="/usr/bin/touch";
 	
	# Directories
	$GLOBAL_DIR{"home"}="/home";
	$GLOBAL_DIR{"initd"}="/sbin/init.d";
        $GLOBAL_DIR{"rcd"}="/sbin";
	$GLOBAL_DIR{"sbin"}="/sbin";
	$GLOBAL_DIR{"share"}= $GLOBAL_PREFIX . "/etc/opt/sec_mgmt/bastille";
        $GLOBAL_DIR{"xinetd.d"}="";

	#
	# Config/misc files
	#
	$GLOBAL_FILE{"apachectl"}="/opt/apache/bin/apachectl";
	$GLOBAL_FILE{"chkconfig_diagnostics"}="/sbin/init.d/diagnostic";
	$GLOBAL_FILE{"chkconfig_lpd"}="/sbin/init.d/lp";
	$GLOBAL_FILE{"chkconfig_named"}="/sbin/init.d/named";
 	$GLOBAL_FILE{"chkconfig_nfs"}="/sbin/init.d/nfs.server";
	$GLOBAL_FILE{"chkconfig_nfs_client"}="/sbin/init.d/nfs.client";
 	$GLOBAL_FILE{"chkconfig_nfs_server"}="/sbin/init.d/nfs.server";
  	$GLOBAL_FILE{"chkconfig_nfs_core"}="/sbin/init.d/nfs.server";
 	$GLOBAL_FILE{"chkconfig_nisp_client"}="/sbin/init.d/nisplus.client";
	$GLOBAL_FILE{"chkconfig_nisp_server"}="/sbin/init.d/nisplus.server";
	$GLOBAL_FILE{"chkconfig_nis_client"}="/sbin/init.d/nis.client";
	$GLOBAL_FILE{"chkconfig_nis_server"}="/sbin/init.d/nis.server";
	$GLOBAL_FILE{"chkconfig_pty"}="/sbin/init.d/ptydaemon";
	$GLOBAL_FILE{"chkconfig_pwgrd"}="/sbin/init.d/pwgr";
	$GLOBAL_FILE{"chkconfig_snmpd"}="/sbin/init.d/SnmpMaster";
	$GLOBAL_FILE{"chkconfig_snmpd_HP"}="/sbin/init.d/SnmpHpunix";
	$GLOBAL_FILE{"chkconfig_snmpd_Master"}="/sbin/init.d/SnmpMaster";
	$GLOBAL_FILE{"chkconfig_snmpd_Mib2"}="/sbin/init.d/SnmpMib2";
	$GLOBAL_FILE{"chkconfig_snmpd_Trp"}="/sbin/init.d/SnmpTrpDst";
	$GLOBAL_FILE{"chkconfig_vt"}="/sbin/init.d/vt";
	$GLOBAL_FILE{"chkconfig_ypbind"}="/sbin/init.d/nis.client";
	$GLOBAL_FILE{"csh.login"}="/etc/csh.login";
	$GLOBAL_FILE{"chroot_os_cp.sh"}="/opt/apache/bin/chroot_os_cp.sh";
	$GLOBAL_FILE{"devassign"}="/tcb/files/devassign";
	$GLOBAL_FILE{"ftpaccess"}="/etc/ftpd/ftpaccess";
	$GLOBAL_FILE{"group"}="/etc/group";
	$GLOBAL_FILE{"inetd.conf"}="/etc/inetd.conf";
	$GLOBAL_FILE{"inittab"}="/etc/inittab";
	$GLOBAL_FILE{"issue"}="/etc/issue";
	$GLOBAL_FILE{"kernel_params"}="/stand/system";
	$GLOBAL_FILE{"lpr"}="/usr/bin/lpr";
	$GLOBAL_FILE{"motd"}="/etc/motd";
        $GLOBAL_FILE{"mtab"}="/etc/mnttab";
	$GLOBAL_FILE{"named"}="/usr/sbin/named";
	$GLOBAL_FILE{"named.pid"}="/var/run/named.pid";
	$GLOBAL_FILE{"nddconf"}="/etc/rc.config.d/nddconf";
	$GLOBAL_FILE{"nsswitch.conf"}="/etc/nsswitch.conf";
	$GLOBAL_FILE{"pam_access.conf"}="/etc/pam.conf";
	$GLOBAL_FILE{"profile"}="/etc/profile";
	$GLOBAL_FILE{"Questions"} = &getGlobal('BDIR', "share") . "/Questions.txt";
	$GLOBAL_FILE{"root_cron"}="/var/spool/cron/crontabs/root";
	$GLOBAL_FILE{"rsh"}="/usr/bin/remsh";
	$GLOBAL_FILE{"sendmail.cf"}="/etc/mail/sendmail.cf";
	$GLOBAL_FILE{"spc"}="/opt/sec_mgmt/spc/bin/security_patch_check";
	$GLOBAL_FILE{"sysconfig_sendmail"}="/sbin/init.d/sendmail";
	$GLOBAL_FILE{"sysconfig_cron"}="/sbin/init.d/cron";
	$GLOBAL_FILE{'Xconfig'}="/usr/dt/config/Xconfig";
	$GLOBAL_FILE{"zprofile"}="/etc/zprofile";

	$GLOBAL_FILE{"httpd.conf"}="/opt/apache/conf/httpd.conf";
	$GLOBAL_FILE{"httpd"}="/opt/apache/bin/httpd";
	$GLOBAL_FILE{"httpd_access.conf"}="/opt/apache/conf/access.conf";


	# Generating swlist database for swmodify changes that will be required
	# The database will be a hash of fully qualified file names that reference
	# the files product name and fileset.  These values are required to use
	# swmodify...
	# temp variable to keep swlist command /usr/sbin/swlist
	my $swlist = &getGlobal('BIN',"swlist");
	# listing of each directory and file that was installed by SD on the target machine
	my @fileList = `${swlist} -l file`;
	if($#fileList >= 0){
	    # foreach line of swlist output
	    foreach my $fileEntry ( @fileList ){
		#filter out commented protions
		if( $fileEntry !~ /^\s*\#/ ){
		    chomp $fileEntry;
		    # split the output into two fields filename and product.fileset
		    my ($productInfo,$file) = split /: /, $fileEntry;
		    $productInfo =~ s/\s+//;
		    $file =~ s/\s+//;
		    # if the file entry already exists replace it only if the new
		    # product is a patch
		    if(exists $GLOBAL_SWLIST{"$file"}){
			if($productInfo =~ /PH(CO|KL|NE|SS)/){
			    $GLOBAL_SWLIST{"$file"} = $productInfo;
			}
		    }
		    else {
			#add the file to the hash
			$GLOBAL_SWLIST{"$file"} = $productInfo;
		    }
		}
	    }
	}
	else{
	    &ErrorLog("Could Not execute swlist.  Swmodifys will not be attemped");
	}
	
    } # End if GLOBAL_DISTRO starts with "HP-UX11"
    else {
       $returnval=0;
    }

    return $returnval;
} # End Subroutine

####################################################################    
# &getGlobalSwlist ($file);
#   This function returns the product and fileset information for 
#   a given file or directory if it exists in the IPD otherwise
#   it returns undefined "undef"
#
#   uses $GLOBAL_SWLIST{"$FILE"}
####################################################################
sub getGlobalSwlist($){
    my $file = $_[0];
    if(exists $GLOBAL_SWLIST{"$file"}){
	return $GLOBAL_SWLIST{"$file"};
    }
    else {
	return undef;
    }
}

###################################################################
#  &B_swmodify($file);
#    This subroutine is called after a file is modified.  It will
#    redifine the file in the IPD with it's new properties.  If 
#    the file is not in the IPD it does nothing.
#
#    uses B_System to make the swmodifications.
##################################################################
sub B_swmodify($){
    my $file = $_[0];
    if(defined &getGlobalSwlist($file)){
	my $swmodify = &getGlobal('BIN',"swmodify");
	my $productInfo = &getGlobalSwlist($file);
	# running swmodify on files that were altered by this function but
	# were created and maintained by SD
	&B_System("$swmodify -x files='$file' $productInfo",
		  "$swmodify -x files='$file' $productInfo");
    }
}


####################################################################
#  &B_System($command,$undocommand);
#    This function executes a command, then places the associated 
#    undo command in undo file. It takes two parameters, the
#    command and the command that undoes that command.
#
#   uses ActionLog and ErrorLog for logging purposes.
###################################################################
sub B_System ($$) {
    my ($command,$undocmd)=@_;

    my $commandOutput = `$command 2>&1`; # run the command and gather its output
    my $commandRetVal = ($? >> 8);  # find the commands return value

    if($commandRetVal == 0){  # if the command ran
	&ActionLog("Executed Command: " . $command . "\n");
	&ActionLog("Command Output: " . $commandOutput . "\n");	
	&B_undo_log_entry ("$undocmd \n");
	return 1;
    } # end of successful command execution
    else {  # command did not run...
	&ActionLog("Failed to Execute Command: " . $command . "\n");
	&ActionLog("Command Output: " . $commandOutput . "\n");	
	&ErrorLog("Failed to Execute Command: " . $command . "\n");
	&ErrorLog("Command Output: " . $commandOutput . "\n");	
	return 0;
    }  # end of failed execution...

}

#   Old B_System
#    if ( system ($command) == 0 ) {
#	&ActionLog("Executed Command: " . $command . "\n");
#	&B_undo_log_entry ("$undocmd \n");
#	return 1;
#    } # end of successful command execution
#    else {
#	&ActionLog("Failed to Execute Command: " . $command . "\n");
#	&ErrorLog("Failed to Execute Command: " . $command . "\n");
#	return 0;
#    }

#This function turns off a service.  The first parameter is the parameter that 
#controls the operation of the service, the second parameter is the script that
#turns on and off the service at boot-time.
sub B_ch_rc ($$) { 

    my ($ch_rc_parameter, $startup_script)=@_;

    if ($GLOBAL_DISTRO != "^HP-UX") {
       &ErrorLog("Tried to call ch_rc $ch_rc_parameter on a non-HP-UX system!  Internal Bastille error.");
       return undef;
    }

    my $command = &getGlobal('BIN', 'ch_rc');
    my $orig_value = `$command -l -p $ch_rc_parameter`;
    chomp $orig_value;
    if ( $orig_value eq "0" ) { #If param is already zero, the "stop" script won't work
	&B_System (&getGlobal('BIN',"ch_rc") . " -a -p $ch_rc_parameter=1"," ");
    }
    &B_System ($startup_script  . " stop", #stop service, then restart if UndoBastille run
	       $startup_script . " start");  

    # set parameter, so that service will stay off after reboots
    &B_System (&getGlobal('BIN',"ch_rc") . " -a -p $ch_rc_parameter=0" , 
	       &getGlobal('BIN',"ch_rc") . " -a -p $ch_rc_parameter=$orig_value");
}

# This function adds something to the To Do List.  It takes one argument, the string you want
# to add to the To Do List.
sub B_TODO ($) {
    my $text = $_[0];
    unless ( &B_append_line(&getGlobal('BFILE', "TODO"), "", $text) ) {
	    &ActionLog("TODO Failed for text: " . $text );
	    &ErrorLog("TODO Failed for text: " . $text );
	}
}

##################################################################################
# &B_chperm($owner,$group,$mode,$filename(s))
#   This function changes ownership and mode of a list of files. Takes four
#   arguments first the owner next the group and third the new mode in oct and
#   last a list of files that the permissions changes should take affect on.
#
#   uses: &swmodify and &B_undo_log_entry
##################################################################################
sub B_chperm($$$$) {
    my ($newown, $newgrp, $newmode, $file_expr) = @_;
    my @files = glob($file_expr);
    
    my $return = 1;
    
    foreach my $file (@files){
	my @filestat = stat $file;
	my $oldmode = (($filestat[2]/512) % 8) .
	    (($filestat[2]/64) % 8) .
		(($filestat[2]/8) % 8) .
		    (($filestat[2]) % 8);

	if((chown $newown, $newgrp, $file) != 1 ){
	    &ErrorLog("Could not change ownership of $file to $newown:$newgrp\n");
	    $return = 0;
	}
	else{
	    &ActionLog("Changed ownership of $file to $newown:$newgrp\n");
	}
	# swmodifying file if possible...
	&B_swmodify($file);

	&B_undo_log_entry(&getGlobal('BIN',"chown") . " $filestat[4]:$filestat[5] $file\n");
	
	if((chmod $newmode, $file) != 1){
	    &ErrorLog("Could not change mode of $file to $newmode\n");
	    $return = 0;
	}
	else{
	    &ActionLog("Changed mode of $file to $newmode\n");
	}   

	&B_undo_log_entry(&getGlobal('BIN',"chmod") . " $oldmode $file\n");
		      
    }
    return $return;
}

############################################################################
# &B_install_jail($jailname, $jailconfigfile);
# This function takes two arguments ( jail_name, jail_config )
# It's purpose is to take read in config files that define a 
# chroot jail and then generate it bases on that specification
############################################################################
sub B_install_jail($$) {

    my $jailName = $_[0];  # Name of the jail e.g bind
    my $jailConfig = $_[1]; # Name of the jails configuration file
    # create the root directory of the jail if it does not exist
    &B_create_dir( &getGlobal('BDIR','jail'));
    &B_chperm(0,0,0700,&getGlobal('BDIR','jail'));

    # create the Jail dir if it does not exist
    &B_create_dir( &getGlobal('BDIR','jail') . "/" . $jailName);
    &B_chperm(0,0,0700,&getGlobal('BDIR','jail') . "/". $jailName);
    
    
    my $jailPath = &getGlobal('BDIR','jail') . "/" . $jailName;
    my @lines; # used to store no commented no empty config file lines
    # open configuration file for desired jail and parse in commands
    if(open(JAILCONFIG,"< $jailConfig")) {
	while(my $line=<JAILCONFIG>){
	    if($line !~ /^\s*\#|^\s*$/){
		chomp $line;
		push(@lines,$line);
	    }
	}
    }
    else{
	&ErrorLog("Open Failed on filename: $jailConfig\n");
	return 0;
    }
    # read through commands and execute
    foreach my $line (@lines){
	my @confCmd = split /\s+/,$line;
	if($confCmd[0] =~ /dir/){ # if the command say to add a directory
	    if($#confCmd == 4) { # checking dir Cmd form
		if(! (-d  $jailPath . "/" . $confCmd[1])){
		    if(&B_create_dir( $jailPath . "/" . $confCmd[1])){ 
			#add a directory and change its permissions according to the conf file
			&B_chperm($confCmd[3],$confCmd[4],oct($confCmd[2]),$jailPath . "/" . $confCmd[1]);
			&ActionLog("$line\n");
		    }
		    else {
			&ErrorLog("Could not make specified directory\n");
			&ErrorLog("\tERROR: $line\n");
		    }
		}
	    }
	    else {
		&ErrorLog("Badly Formed Configuration Line\n");
		&ErrorLog("\tERROR: $line\n");
	    }
	}       
	elsif($confCmd[0] =~ /file/) {
	    if($#confCmd == 5) { # checking file cmd form
		if(!(-e $jailPath . "/" . $confCmd[2])){
		    if(&B_cp($confCmd[1],$jailPath . "/" . $confCmd[2])){ 
			# for copy command cp file and change perms
			&B_chperm($confCmd[4],$confCmd[5],oct($confCmd[3]),$jailPath . "/" . $confCmd[2]);
			&ActionLog("$line\n");
		    }
		    else {
			&ErrorLog("Could not complete copy on specified files\n");
			&ErrorLog("\tERROR: $line\n");
		    }
		}
	    }
	    else {
		&ErrorLog("Badly Formed Configuration Line\n");
		&ErrorLog("\tERROR: $line\n");
	    }
	}           
	elsif($confCmd[0] =~ /slink/) {
	    if($#confCmd == 2) { # checking file cmd form
		if(!(-e $jailPath . "/" . $confCmd[2])){
		    if(&B_symlink($jailPath . "/" . $confCmd[1], $confCmd[2])){
			#for symlink command create the symlink
			&ActionLog("$line\n");
		    }
		    else {
			&ErrorLog("Could not complete symlink on specified files\n");
			&ErrorLog("\tERROR: $line\n");
		    }
		}
	    }
	    else {
		&ErrorLog("Badly Formed Configuration Line\n");
		&ErrorLog("\tERROR: $line\n");
	    }
	}	    
	else {
	    &ErrorLog("Unrecognized Configuration Line\n");
	    &ErrorLog("\tERROR: $line\n");
	}
    }
    return 1;
}

1;
























