/* unit-cmd-diff.c
 *
 ****************************************************************
 * Copyright (C) 2004, Canonical Limited
 *               Author: Robert Collins
 *
 * See the file "COPYING" for further information about
 * the copyright and warranty status of this work.
 */


#include "hackerlab/vu/reserv.h"
#include "hackerlab/bugs/panic.h"
#include "hackerlab/char/str.h"
#include "hackerlab/arrays/ar.h"
#include "commands/cmd.h"



/* typedefs */



/* local methods */



int
main (int argc, char * argv[])
{
  char ** array = NULL;

  ar_push_char_star(&array, "foo");
  ar_push_char_star(&array, "bar");

  invariant(2 == ar_size_char_star (array));
  invariant(!str_cmp(array[0], "foo"));
  invariant(!str_cmp(array[1], "bar"));

  ar_free_char_star (&array);

  return 0;
}

