#!/bin/sh
# -*- mode: sh; coding: utf-8 -*-
# Simple update tests
# Written by James Blackwell <jblack@inframix.com>
# Copyright  2004 Canonical Ltd.
#
# This file is licensed under the General Public License v2, or at your
# preference, any later version.

set -e

arg0="$0"
srcdir=`dirname "$arg0"`

. ${srcdir}/test-framework

test_class "update"
  
setup_hello_world ()
{
  setup_with_trivial_archives
  tla get jane@example.com--2003/hello-world--mainline--1.0 hello-world-1

  cd hello-world-1

  sed -e 's/Hello World/Hello, World/' < hello-world.c > hello-world.c.new
  mv hello-world.c.new hello-world.c
  tla commit -L 'correctly punctuate'

  cd ..
}

setup_hello_world

begin_test "solitary update"
tla get jane@example.com--2003/hello-world--mainline--1.0--base-0 hw-2
cd hw-2
tla update
cd ..
end_test

begin_test "update with -d dirname"
tla get jane@example.com--2003/hello-world--mainline--1.0--base-0 hw-3
tla update -d hw-3 
end_test "update with -d dirname"

begin_test "update with no local changes"
tla get jane@example.com--2003/hello-world--mainline--1.0--base-0 hw-4
cd hw-4
foo=$(tla update) 
echo $foo | grep -v "temporarily reverting local changes"
echo $foo | grep -v "reapplying local changes"
end_test "update with -d dirname"

begin_test "update with local changes"
tla get jane@example.com--2003/hello-world--mainline--1.0--base-0 hw-5
cd hw-5
touch X
tla add X
foo=$(tla update) 
echo $foo | grep "temporarily reverting local changes"
echo $foo | grep "reapplying local changes"
cd ..
end_test "update with -d dirname"

begin_test "update does more than patchlogs"
tree="$PWD/tree"
archive="jane@example.com--2003"
nonarch="hello-world--mainline--1.1"
fqver="$archive/$nonarch"
mkdir "$tree"
tla import -a -d "$tree" "$fqver"
cd "$tree"
echo "first" > foo
tla add foo
tla commit -s 'rev 1'
echo "second" > foo
tla commit -s 'rev 2'
tla undo patch-1
[ "$(tla tree-id)" == $fqver--patch-1 ] || test_fail "wrong tree id $(tla tree-id)"
file_matches first foo || test_fail "wrong content in foo: $(cat foo)"
tla update > ,,update-output
tla diff || test_fail "changes present after update: $(tla diff)"
[ "$(tla tree-id)" == $fqver--patch-2 ] || test_fail "wrong tree id $(tla tree-id)"
file_matches second foo || test_fail "wrong content in foo: $(cat foo)"
end_test

begin_test "update to head -1 works"
# note this depends on no revlib currently - checks the patch-series approach
tla get jane@example.com--2003/hello-world--mainline--1.0--patch-1 foo
cd foo
tla update base-0
end_test

# tag: DO_NOT_CHANGE James Blackwell Mon Aug 16 07:02:51 EDT 2004
