/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#include "libraries.h"
#include <glib.h>
#include "dialogeditextramatter.h"
#include "utilities.h"
#include <config.h>
#include <time.h>
#include "extra_matter_utils.h"
#include "usfm.h"
#include "gtkwrappers.h"


EditExtraMatterDialog::EditExtraMatterDialog (const ustring& projectname, EditExtraMatter edit_what)
{
  // Deal with the file with the extra matter.
  extra_matter_file_ensure_exists (projectname, edit_what);
  filename = extra_matter_file_name (projectname, edit_what);
  
  dialogeditextramatter = gtk_dialog_new ();
  ustring title;
  switch (edit_what) {
    case FrontMatter   : title = "Edit front matter";   break;
    case BackMatter    : title = "Edit back matter";    break;
    case OtherMaterial : title = "Edit other material"; break;
  }
  gtk_window_set_title (GTK_WINDOW (dialogeditextramatter), title.c_str());
  gtk_window_set_position (GTK_WINDOW (dialogeditextramatter), GTK_WIN_POS_CENTER_ON_PARENT);
  gtk_window_set_modal (GTK_WINDOW (dialogeditextramatter), TRUE);
  gtk_window_set_destroy_with_parent (GTK_WINDOW (dialogeditextramatter), TRUE);
  gtk_window_set_type_hint (GTK_WINDOW (dialogeditextramatter), GDK_WINDOW_TYPE_HINT_DIALOG);

  dialog_vbox1 = GTK_DIALOG (dialogeditextramatter)->vbox;
  gtk_widget_show (dialog_vbox1);

  vbox1 = gtk_vbox_new (FALSE, 4);
  gtk_widget_show (vbox1);
  gtk_box_pack_start (GTK_BOX (dialog_vbox1), vbox1, TRUE, TRUE, 3);

  hbox1 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox1);
  gtk_box_pack_start (GTK_BOX (vbox1), hbox1, TRUE, TRUE, 0);

  label1 = gtk_label_new ("Insert Marker for");
  gtk_widget_show (label1);
  gtk_box_pack_start (GTK_BOX (hbox1), label1, FALSE, FALSE, 4);
  gtk_misc_set_alignment (GTK_MISC (label1), 0, 0.5);

  // Get the supported and relevant markers.
  vector<ustring> markers;
  extra_matter_file_get_relevant_markers (markers, edit_what);  

  combo1 = gtk_combo_box_new_text ();
  gtk_widget_show (combo1);
  gtk_box_pack_start (GTK_BOX (hbox1), combo1, FALSE, FALSE, 0);
  GList *combo1_items = NULL;
  vector<ustring> marker_names;
  for (unsigned int i = 0; i < markers.size(); i++) {
    marker_names.push_back ((markers[i]));
    combo1_items = g_list_append (combo1_items, (gpointer) marker_names[i].c_str());
  }
  gtk_combo_set_popdown_strings (GTK_COMBO (combo1), combo1_items);
  g_list_free (combo1_items);

  combo_entry1 = GTK_COMBO (combo1)->entry;
  gtk_widget_show (combo_entry1);
  gtk_entry_set_text (GTK_ENTRY (combo_entry1), marker_names[0].c_str());
  gtk_widget_set_size_request (combo_entry1, 200, -1);
  gtk_editable_set_editable (GTK_EDITABLE (combo_entry1), FALSE);

  button1 = gtk_button_new_from_stock ("gtk-add");
  gtk_widget_show (button1);
  gtk_box_pack_start (GTK_BOX (hbox1), button1, FALSE, FALSE, 0);

  vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox2);
  gtk_box_pack_start (GTK_BOX (hbox1), vbox2, TRUE, TRUE, 5);

  markerlabel = gtk_label_new ("");
  gtk_widget_show (markerlabel);
  gtk_box_pack_start (GTK_BOX (vbox2), markerlabel, FALSE, FALSE, 0);
  gtk_misc_set_alignment (GTK_MISC (markerlabel), 0, 0.5);

  commentlabel = gtk_label_new ("");
  gtk_widget_show (commentlabel);
  gtk_box_pack_start (GTK_BOX (vbox1), commentlabel, FALSE, FALSE, 0);
  gtk_misc_set_alignment (GTK_MISC (commentlabel), 0, 0.5);

  scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (scrolledwindow1);
  gtk_box_pack_start (GTK_BOX (vbox1), scrolledwindow1, TRUE, TRUE, 0);
  gtk_widget_set_size_request (scrolledwindow1, 800, 600);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW (scrolledwindow1), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  textview1 = gtk_text_view_new ();
  gtk_widget_show (textview1);
  gtk_container_add (GTK_CONTAINER (scrolledwindow1), textview1);
  gtk_text_view_set_wrap_mode (GTK_TEXT_VIEW (textview1), GTK_WRAP_WORD);

  // Load text.
  gchar *contents;
  g_file_get_contents (filename.c_str(), &contents, NULL, NULL);
  gtk_text_buffer_set_text (gtk_text_view_get_buffer (GTK_TEXT_VIEW (textview1)), contents, -1);
  g_free (contents);
  gtk_text_buffer_set_modified (gtk_text_view_get_buffer (GTK_TEXT_VIEW (textview1)), false);

  dialog_action_area1 = GTK_DIALOG (dialogeditextramatter)->action_area;
  gtk_widget_show (dialog_action_area1);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area1), GTK_BUTTONBOX_END);

  cancelbutton1 = gtk_button_new_from_stock ("gtk-cancel");
  gtk_widget_show (cancelbutton1);
  gtk_dialog_add_action_widget (GTK_DIALOG (dialogeditextramatter), cancelbutton1, GTK_RESPONSE_CANCEL);
  GTK_WIDGET_SET_FLAGS (cancelbutton1, GTK_CAN_DEFAULT);

  okbutton1 = gtk_button_new_from_stock ("gtk-ok");
  gtk_widget_show (okbutton1);
  gtk_dialog_add_action_widget (GTK_DIALOG (dialogeditextramatter), okbutton1, GTK_RESPONSE_OK);
  GTK_WIDGET_SET_FLAGS (okbutton1, GTK_CAN_DEFAULT);

  g_signal_connect ((gpointer) combo_entry1, "changed", G_CALLBACK (on_combo_entry1_changed), gpointer (this));
  g_signal_connect ((gpointer) button1, "clicked", G_CALLBACK (on_button1_clicked), gpointer (this));
  g_signal_connect ((gpointer) cancelbutton1, "clicked", G_CALLBACK (on_cancelbutton1_clicked), gpointer (this));
  g_signal_connect ((gpointer) okbutton1, "clicked", G_CALLBACK (on_okbutton1_clicked), gpointer (this));

  gtk_widget_grab_focus (textview1);

  // Update GUI.
  on_combo_entry ();
}


EditExtraMatterDialog::~EditExtraMatterDialog ()
{
  // In case window is closed through window manager, or Escape key, 
  // activate the cancel routine, so that the user gets the opportunity
  // to save any changes.
  on_cancelbutton ();
  gtk_widget_destroy (dialogeditextramatter);
}


int
EditExtraMatterDialog::run ()
{
  return gtk_dialog_run (GTK_DIALOG (dialogeditextramatter));
}


void EditExtraMatterDialog::on_button1_clicked (GtkButton *button, gpointer user_data)
{
  ((EditExtraMatterDialog *) user_data)->on_button1 ();
}


void EditExtraMatterDialog::on_button1 ()
{
  // Get the marker.
  ustring marker;
  marker = gtk_entry_get_text (GTK_ENTRY (combo_entry1));
  GtkTextBuffer *buffer;
  buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (textview1));
  if (true) {
    // This marker should start at a new line.
    // Where is the cursor now?
    GtkTextIter iterator;
    gtk_text_buffer_get_iter_at_mark (buffer, &iterator, gtk_text_buffer_get_insert (buffer));
    // Is it at the beginning of a line?
    if (!gtk_text_iter_starts_line (&iterator)) {
      // Cursor is not at the beginning of a line. Move it to the next line.
      int line_of_cursor = gtk_text_iter_get_line (&iterator);
      gtk_text_buffer_get_iter_at_line (buffer, &iterator, ++line_of_cursor);
      gtk_text_buffer_place_cursor (buffer, &iterator);
    }
  }
  // Insert text, with newline, and move cursor back to the end of the line.
  bool insert_space;
  insert_space = true;
  marker = "\\" + marker;
  gtk_text_buffer_insert_at_cursor (buffer, marker.c_str(), -1);
  if (insert_space)
    gtk_text_buffer_insert_at_cursor (buffer, " ", -1);
  gtk_text_buffer_insert_at_cursor (buffer, "\n", -1);
  GtkTextIter iterator;
  gtk_text_buffer_get_iter_at_mark (buffer, &iterator, gtk_text_buffer_get_insert (buffer));
  gtk_text_iter_backward_char (&iterator);  
  gtk_text_buffer_place_cursor (buffer, &iterator);
  // For user's convenience, textview should have focus.
  gtk_widget_grab_focus (textview1);
}


void EditExtraMatterDialog::on_okbutton1_clicked (GtkButton *button, gpointer user_data)
{
  ((EditExtraMatterDialog *) user_data)->on_okbutton ();
}


void EditExtraMatterDialog::on_okbutton ()
{
  // Save data to disk.
  GtkTextBuffer * buffer;
  buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (textview1));
  vector<ustring> lines;
  textbuffer_get_lines (buffer, lines);
  // Remove empty last line.
  if (lines.size() > 0)
    if (lines[lines.size() - 1].empty())
      lines.erase (lines.end());
  write_lines (filename, lines);
  gtk_text_buffer_set_modified (buffer, false);  
}


void EditExtraMatterDialog::on_cancelbutton1_clicked (GtkButton *button, gpointer user_data)
{
  ((EditExtraMatterDialog *) user_data)->on_cancelbutton ();
}


void EditExtraMatterDialog::on_cancelbutton ()
{
  if (gtk_text_buffer_get_modified (gtk_text_view_get_buffer (GTK_TEXT_VIEW (textview1)))) {
    // Oops, does the user really want to discard the edits?
    if (gtkw_dialog_question (dialogeditextramatter, "Do you want to save the changes?", GTK_RESPONSE_YES) == GTK_RESPONSE_YES) {
      on_okbutton ();
    }
    gtk_text_buffer_set_modified (gtk_text_view_get_buffer (GTK_TEXT_VIEW (textview1)), false);
  }
}


void EditExtraMatterDialog::on_combo_entry1_changed (GtkEditable *editable, gpointer user_data)
{
  ((EditExtraMatterDialog *) user_data)->on_combo_entry ();
}


void EditExtraMatterDialog::on_combo_entry ()
{
  ustring marker;
  marker = gtk_entry_get_text (GTK_ENTRY (combo_entry1));
  ustring label;
  label = "Marker: \\" + marker;
  gtk_label_set_text (GTK_LABEL (markerlabel), label.c_str());
  label = (marker);
  gtk_label_set_text (GTK_LABEL (commentlabel), label.c_str());  
}
