/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#include "libraries.h"
#include "notecaller.h"
#include "utilities.h"
#include "constants.h"


NoteCaller::NoteCaller (NoteNumberingType numbering, ustring user_sequence, bool spacious)
// Deal with the note callers.
{
  mynumbering = numbering;
  mysequence = user_sequence;
  myspacious = spacious;
  if (mynumbering == nntAlphabetical)
    mysequence = ALPHABET;
  reset ();
}


NoteCaller::~NoteCaller ()
{
}


void NoteCaller::reset ()
{
  caller_pointer = 0;
}


ustring NoteCaller::get_caller ()
{
  ustring caller;
  caller_pointer++;
  switch (mynumbering) {
    case nntNumerical:
    {
      caller = convert_to_string (caller_pointer);      
      break;
    }
    case nntAlphabetical:
    case nntUserDefined:
    {
      if (caller_pointer > mysequence.size())
        caller_pointer = 1;
      if (caller_pointer > mysequence.size())
        caller = "a";
      else
        caller = mysequence[caller_pointer - 1];      
      break;
    }
  }
  return caller;
}


bool NoteCaller::get_spacious ()
{
  return myspacious;
}
