/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#include "libraries.h"
#include "screen.h"
#include "generalconfig.h"
#include "gwrappers.h"


ScreenDimensions::ScreenDimensions (GtkWindow *window)
{
  // Open configuration and get values.
  GeneralConfiguration genconfig (0);
  width = genconfig.window_width ();
  height = genconfig.window_height ();
  x = genconfig.window_x_position ();
  y = genconfig.window_y_position ();
  hpane_position = genconfig.hpane_position ();
  vpane_editor_position = genconfig.vpane_editor_position ();
  vpane_biblenotes_position = genconfig.vpane_biblenotes_position ();
  vpane_quick_references_position = genconfig.vpane_quick_references_position ();
  tools_area_left = genconfig.tools_area_left ();
  // If the screen resolution got changed, recalculate the values.
  GdkScreen * screen = gtk_window_get_screen (window);
  bool screen_resolution_changed = false;
  int real_screen_width = gdk_screen_get_width (screen);
  int stored_screen_width = genconfig.screen_width();
  int real_screen_height = gdk_screen_get_height (screen);
  int stored_screen_height = genconfig.screen_height();
  if (real_screen_width != stored_screen_width) 
    screen_resolution_changed = true;
  if (real_screen_height != stored_screen_height)
    screen_resolution_changed = true;
  if (screen_resolution_changed) {
    gw_message ("Screen resolution changed");    
    genconfig.screen_width_set (real_screen_width);
    genconfig.screen_height_set (real_screen_height);
    width = real_screen_width * 95 / 100;
    genconfig.window_width_set (width);
    height = real_screen_height * 90 / 100;
    genconfig.window_height_set (height);
    x = 0;
    genconfig.window_x_position_set (x);
    y = 0;
    genconfig.window_y_position_set (y);
    hpane_position = width * 87 / 100;
    genconfig.hpane_position_set (hpane_position);
    vpane_editor_position = height * 60 / 100;
    genconfig.vpane_editor_position_set (vpane_editor_position);
    vpane_biblenotes_position = int (0.85 * vpane_editor_position);
    genconfig.vpane_biblenotes_position_set (vpane_biblenotes_position);
    vpane_quick_references_position = vpane_editor_position;
    genconfig.vpane_quick_references_position_set (vpane_quick_references_position);
    tools_area_left = false;
    genconfig.tools_area_left_set (tools_area_left);
  }
  // Prevents areas from becoming invisible altogether,
  // prompting users to ask for support.
  if (hpane_position < 300) hpane_position = 300;
  if (vpane_editor_position < 200) vpane_editor_position = 200;
  if (vpane_biblenotes_position < 100) vpane_biblenotes_position = 100;
  if (vpane_quick_references_position < 100) vpane_quick_references_position = 100;
}


void screen_scroll_to_itererator (GtkTextView *text_view, GtkTextIter *iter)
// Used for the editor, to get a position near the top of the screen.
{
  gtk_text_view_scroll_to_iter (text_view, iter, 0.1, true, 0, 0.3); 
}
