/*
 * Copyright (c) 2005, 2006 Jeremy Erickson
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef WATCHERMAINACT_H
#define WATCHERMAINACT_H

#include "versewatcher.h"
#include "qt_types.h"
namespace bmemcore
{
class SearchFilter;
//#include "searchfilter.h"
class bmemcore::Verse;
//#include "verse.h"
}
class QString;

namespace bmemui
{
class MainAct;

/**
@author Jeremy Erickson
*/
class WatcherMainAct : public bmemcore::VerseWatcher
{
public:
    WatcherMainAct(MainAct&, bmemcore::Verse&, bmemcore::SearchFilter*);

    virtual ~WatcherMainAct();

    void verseChanged(const bmemcore::Verse&,
                      bmemcore::VerseWatcher::ChangeType);

    void newFilter(bmemcore::SearchFilter*);
protected:
    MainAct &mMainAct;
    bmemcore::SearchFilter *mSearchFilter;
    bmemcore::Verse &mVerse;
    //BQListBox &mListBox;
    BQListBoxText *mListBoxText;
    bool textChanged;
    void handleFilter();
    void killListBoxText();
};

}
#endif
