#!/bin/bash
#
# gen_am.sh script
#
# (C) 2001 The BibleTime team
# released under the GPL
#
# This script creates the Makefile.am files in the
# bibletime/pics/*color/ and bibletime/pics/*color/*x* directories.
#
# It will not change the bibletime/pics/Makefile.am!

# change to the dir the script is located in
cd `dirname $0`

export HEADER="\n"\
"# this Makefile.am was automatically generated by bibletime/pics/gen_am.sh\n"\
"# please do not edit this file but rather run the script to update\n"

# create Makefile.am's in /bibletime/pics/*color/ directories
#
for I1 in `ls -d *color`; do

  echo creating $I1/Makefile.am
  ( # output to Makefile.am
  echo -e $HEADER

  echo -n "SUBDIRS = "
  for I2 in `ls -d $I1/*x*`; do
    echo -n `basename $I2`" "
  done
  echo
  ) > $I1/Makefile.am

done


# create Makefile.am's in /bibletime/pics/*color/*x* directories
#
for I1 in `ls -d *color/*x*`; do

  echo creating $I1/Makefile.am
  ( # output to Makefile.am  
  echo -e $HEADER

  echo "KDE_ICON = AUTO"
  echo "EXTRA_DIST=\\"
  for I2 in `ls -d $I1/*.png`; do
    echo -n `basename $I2`" "
  done
  echo
  ) > $I1/Makefile.am

done
