#!/usr/bin/env python
# -*- coding: ISO-8859-1 -*-
# generated by wxGlade 0.4.1 on Sun Nov  5 21:44:38 2006

import wx, BIB

class Wizard_MySQL_choiceDB(wx.Panel):
    def __init__(self, *args, **kwds):
        # begin wxGlade: Wizard_MySQL_choiceDB.__init__
        kwds["style"] = wx.TAB_TRAVERSAL
        wx.Panel.__init__(self, *args, **kwds)
        self.label_9 = wx.StaticText(self, -1, _("Please choose the bibliographic database"))
        self.dbname = wx.Choice(self, -1, choices=[])

        self.__set_properties()
        self.__do_layout()
        # end wxGlade

    def __set_properties(self):
        # begin wxGlade: Wizard_MySQL_choiceDB.__set_properties
        self.label_9.SetFont(wx.Font(12, wx.DEFAULT, wx.NORMAL, wx.BOLD, 0, ""))
        # end wxGlade

    def __do_layout(self):
        # begin wxGlade: Wizard_MySQL_choiceDB.__do_layout
        sizer_2 = wx.BoxSizer(wx.VERTICAL)
        sizer_2.Add((20, 20), 1, 0, 0)
        sizer_2.Add(self.label_9, 0, wx.BOTTOM|wx.EXPAND, 5)
        sizer_2.Add(self.dbname, 0, wx.ALL|wx.EXPAND, 5)
        sizer_2.Add((20, 20), 1, 0, 0)
        self.SetSizer(sizer_2)
        sizer_2.Fit(self)
        # end wxGlade
        
    def setDB(self):
        self.dbname.Clear()
        self.dbname.AppendItems(self.__getDB())
        self.dbname.SetSelection(0)
        
    def __getDB(self):
        import dbBibMySQL
        saved_name = BIB.DB_NAME			# we save the old DB_NAME
        BIB.DB_NAME = ''
        db = dbBibMySQL.dbBib()	# we connect with no db name
        BIB.DB_NAME = saved_name				# restore db name
        try:
            return [dbname[0] for dbname in db.getDatabases()]
        except AttributeError:
            return []

    def getValues(self):
        return self.dbname.GetStringSelection()
        
# end of class Wizard_MySQL_choiceDB


class Wizard_MySQL(wx.Panel):
    def __init__(self, *args, **kwds):
        # begin wxGlade: Wizard_MySQL.__init__
        kwds["style"] = wx.TAB_TRAVERSAL
        wx.Panel.__init__(self, *args, **kwds)
        self.label_7 = wx.StaticText(self, -1, _("Setting database and rights"))
        self.label_8 = wx.StaticText(self, -1, _("If you have the necessary rights (MySQL Administrator),\nclick the button below to create/change the MySQL database"))
        self.button_Setup = wx.Button(self, -1, _("MySQL database setup ..."))
        self.static_line_1 = wx.StaticLine(self, -1)
        self.label_6 = wx.StaticText(self, -1, _("Enter your connection parameters below"))
        self.label_1 = wx.StaticText(self, -1, _("UserName"))
        self.username = wx.TextCtrl(self, -1, "")
        self.label_2 = wx.StaticText(self, -1, _("Password"))
        self.password = wx.TextCtrl(self, -1, "", style=wx.TE_PASSWORD)
        self.label_3 = wx.StaticText(self, -1, _("Host"))
        self.host = wx.TextCtrl(self, -1, "")
        self.label_4 = wx.StaticText(self, -1, _("Port"))
        self.port = wx.SpinCtrl(self, -1, "3306", min=0, max=10000)
        self.label_5 = wx.StaticText(self, -1, _("Socket"))
        self.socket = wx.TextCtrl(self, -1, "")

        self.__set_properties()
        self.__do_layout()

        self.Bind(wx.EVT_BUTTON, self.onSetup, self.button_Setup)
        # end wxGlade

    def __set_properties(self):
        # begin wxGlade: Wizard_MySQL.__set_properties
        self.label_7.SetFont(wx.Font(12, wx.DEFAULT, wx.NORMAL, wx.BOLD, 0, ""))
        self.label_6.SetFont(wx.Font(12, wx.DEFAULT, wx.NORMAL, wx.BOLD, 0, ""))
        # end wxGlade
        self.username.SetValue(BIB.USER)
        self.password.SetValue(BIB.PASSWORD)
        self.host.SetValue(BIB.HOST)
        self.port.SetValue(BIB.PORT)
        self.socket.SetValue(BIB.SOCKET)

    def __do_layout(self):
        # begin wxGlade: Wizard_MySQL.__do_layout
        sizer_1 = wx.BoxSizer(wx.VERTICAL)
        grid_sizer_1 = wx.FlexGridSizer(5, 2, 3, 3)
        sizer_1.Add(self.label_7, 0, wx.BOTTOM, 5)
        sizer_1.Add(self.label_8, 0, 0, 0)
        sizer_1.Add(self.button_Setup, 0, wx.ALL|wx.EXPAND, 5)
        sizer_1.Add((20, 20), 1, 0, 0)
        sizer_1.Add(self.static_line_1, 0, wx.EXPAND, 0)
        sizer_1.Add(self.label_6, 0, wx.BOTTOM|wx.EXPAND, 5)
        grid_sizer_1.Add(self.label_1, 0, wx.ALIGN_RIGHT|wx.ALIGN_CENTER_VERTICAL, 0)
        grid_sizer_1.Add(self.username, 0, wx.EXPAND, 0)
        grid_sizer_1.Add(self.label_2, 0, wx.ALIGN_RIGHT|wx.ALIGN_CENTER_VERTICAL, 0)
        grid_sizer_1.Add(self.password, 0, wx.EXPAND, 0)
        grid_sizer_1.Add(self.label_3, 0, wx.ALIGN_RIGHT|wx.ALIGN_CENTER_VERTICAL, 0)
        grid_sizer_1.Add(self.host, 0, wx.EXPAND, 0)
        grid_sizer_1.Add(self.label_4, 0, wx.ALIGN_RIGHT|wx.ALIGN_CENTER_VERTICAL, 0)
        grid_sizer_1.Add(self.port, 0, wx.EXPAND, 0)
        grid_sizer_1.Add(self.label_5, 0, wx.ALIGN_RIGHT|wx.ALIGN_CENTER_VERTICAL, 0)
        grid_sizer_1.Add(self.socket, 0, wx.EXPAND, 0)
        grid_sizer_1.AddGrowableCol(1)
        sizer_1.Add(grid_sizer_1, 1, wx.EXPAND, 0)
        self.SetSizer(sizer_1)
        sizer_1.Fit(self)
        # end wxGlade

    def onSetup(self, event): # wxGlade: Wizard_MySQL.<event_handler>
        import MySQL_Setup
        mySetup = MySQL_Setup.MySQL_Setup_Main(None, -1, "")
        try:                                        # not possible for mysql
            mySetup.ShowModal()
        finally:
            mySetup.Destroy()
            
    def check(self):
        try:
            import MySQLdb
        except ImportError:
            wx.MessageBox(_("Sorry but the MySQL python module (MySQLdb) is not available.\nRead installation.txt"),_('Error'),wx.ICON_ERROR|wx.OK)
            self.Close()

    def getValues(self):
        return self.username.GetValue(),self.password.GetValue(),self.host.GetValue(),self.port.GetValue(),self.socket.GetValue()
        
# end of class Wizard_MySQL


