#ifndef __BKL_DBUS_H__
#define __BKL_DBUS_H__

#include <glib-object.h>


G_BEGIN_DECLS

#define BKL_TYPE_DBUS                                                   \
   (bkl_dbus_get_type())
#define BKL_DBUS(obj)                                                   \
   (G_TYPE_CHECK_INSTANCE_CAST ((obj),                                  \
                                BKL_TYPE_DBUS,                          \
                                BklDBus))
#define BKL_DBUS_CLASS(klass)                                           \
   (G_TYPE_CHECK_CLASS_CAST ((klass),                                   \
                             BKL_TYPE_DBUS,                             \
                             BklDBusClass))
#define IS_BKL_DBUS(obj)                                                \
   (G_TYPE_CHECK_INSTANCE_TYPE ((obj),                                  \
                                BKL_TYPE_DBUS))
#define IS_BKL_DBUS_CLASS(klass)                                        \
   (G_TYPE_CHECK_CLASS_TYPE ((klass),                                   \
                             BKL_TYPE_DBUS))
#define BKL_DBUS_GET_CLASS(obj)                                         \
   (G_TYPE_INSTANCE_GET_CLASS ((obj),                                   \
                               BKL_TYPE_DBUS,                           \
                               BklDBusClass))

#define BKL_DBUS_PATH "/org/moblin/Bickley"

typedef struct _BklDBus      BklDBus;
typedef struct _BklDBusClass BklDBusClass;

struct _BklDBus
{
    GObject parent;
};

struct _BklDBusClass
{
    GObjectClass parent_class;
};

GType bkl_dbus_get_type (void) G_GNUC_CONST;
BklDBus *bkl_dbus_new (void);

void bkl_dbus_notify_uri_changed (BklDBus    *dbus,
                                  const char *source,
                                  const char *uri);
void bkl_dbus_notify_uri_added (BklDBus    *self,
                                const char *source,
                                const char *uri);
void bkl_dbus_notify_uri_deleted (BklDBus    *self,
                                  const char *source,
                                  const char *uri);

G_END_DECLS

#endif /* __BKL_DBUS_H__ */
