;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Cgen/walk.scm               */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Feb 21 08:37:48 1995                          */
;*    Last change :  Tue Jul  3 16:09:18 2001 (serrano)                */
;*    Copyright   :  1995-2001 Manuel Serrano, see LICENSE file        */
;*    -------------------------------------------------------------    */
;*    The `C generation' pass.                                         */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module cgen_walk
   (include "Engine/pass.sch"
	    "Ast/unit.sch"
	    "Tools/trace.sch")
   (import  tools_shape
	    tools_error
	    engine_param
	    engine_configure
	    module_module
	    module_library
	    type_type
	    ast_var
	    ast_node
	    ast_occur
	    ast_build
	    object_class
	    bdb_emit
	    prof_emit
	    cgen_cop
	    cgen_emit
	    cgen_prototype
	    cgen_main
	    cgen_init
	    cgen_cgen)
   (export  (cgen-walk ::pair-nil)
	    (ast+initializers::pair-nil ::pair-nil)))

;*---------------------------------------------------------------------*/
;*    cgen-walk ...                                                    */
;*---------------------------------------------------------------------*/
(define (cgen-walk globals)
   (pass-prelude "C generation" (lambda () (start-emission! ".c")))
   
   (trace cgen "cgen-walk: *main*: " (shape *main*) #\( *main* #\) #\Newline)
   
   ;; a very little comment 
   (emit-header)
   
   ;; emit the GC selection
   (emit-garbage-collector-selection)
   
   ;; if we are in debugging mode, we generate a macro
   (if (or (>fx *compiler-debug* 0) *c-debug*)
       (emit-debug-activation))
   
   ;; the include (both Bigloo's and user's ones)
   (emit-include)
   
   ;; we emit the generated type for the classes
   (emit-class-types *c-port*)
   
   ;; we declare prototypes
   ;; first, we print the prototype of variables
   (emit-prototypes)
   
   ;; then we emit the constants values
   (emit-cnsts)
   
   ;; when compiling in bdb mode we have to emit the identifier
   ;; translation table.
   (if (>fx *bdb-debug* 0)
       (emit-bdb-info globals *c-port*))
   
   ;; when compiling for profile we emit identifier translation table
   (if (>fx *profile-mode* 0)
       (emit-prof-info globals *c-port*))
   
   ;; we print the C main...
   (if (and (or *main* (memq *pass* '(ld distrib)))
	    (not (eq? *main* 'imported)))
       (emit-main))
   
   ;; we emit the dynamic loading init point
   (let ((mod-init (get-module-init)))
      (if (and bgl-configure-dlopen? *dlopen-init* (global? mod-init))
	  (emit-dlopen-init mod-init)))
   
   ;; we now emit the code for all the Scheme functions
   (for-each cgen globals)
   
   (stop-emission!))

;*---------------------------------------------------------------------*/
;*    ast+initializers ...                                             */
;*    -------------------------------------------------------------    */
;*    This function builds the complete list of global variables. That */
;*    is, the user global variables plus the globals that implement    */
;*    the module initialization (e.g. module-initialization,           */
;*    cnst-initialization, ...).                                       */
;*---------------------------------------------------------------------*/
(define (ast+initializers::pair-nil globals::pair-nil)
   (let* ((lib-unit (library-finalizer))
	  (lib-init (if (unit? lib-unit)
			(let ((vars (build-ast-sans-remove (list lib-unit))))
			   (for-each (lambda (g)
					(occur-node-in!
					 (sfun-body (global-value g))
					 g))
				     vars)
			   vars)
			'()))
	  (mod-init (get-module-init))
	  (globals  (cons mod-init
			  (if (and (or *main* (memq *pass* '(ld distrib)))
				   (not (eq? *main* 'imported)))
			      (cons (make-bigloo-main)
				    (append lib-init globals))
			      (append lib-init globals)))))
      globals))

