;*=====================================================================*/
;*    .../prgm/project/bigloo/comptime.case1.4/Heap/restore.scm        */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Dec 26 10:53:23 1994                          */
;*    Last change :  Fri Jul  6 09:03:30 2001 (serrano)                */
;*    Copyright   :  1994-2001 Manuel Serrano, see LICENSE file        */
;*    -------------------------------------------------------------    */
;*    We restore an heap                                               */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module heap_restore
   (include "Engine/pass.sch")
   (export  (restore-heap)
	    (restore-additional-heaps))
   (import  engine_param
	    engine_engine
	    init_main
	    tools_error
	    ast_env
	    type_type
	    type_env
	    ast_var
	    read_jvm
	    tools_shape))

;*---------------------------------------------------------------------*/
;*    restore-heap ...                                                 */
;*---------------------------------------------------------------------*/
(define (restore-heap)
   (if (string? *heap-name*)
       (begin
	  (pass-prelude "Heap")
	  (let ((fname (find-file/path *heap-name* *lib-dir*)))
	     (if (string? fname)
 		 (let* ((port    (open-input-binary-file fname))
			(handler (lambda (escape proc mes obj)
				    (notify-error proc mes obj)
				    (close-binary-port port)
				    (exit-bigloo -5))))
		    (if (not (binary-port? port))
			(begin
			   (error "restore-heap"
				  (string-append "Cannot open heap file \""
						 fname "\"")
				  *lib-dir*)
			   (exit-bigloo -5))
			(begin
			   (verbose 2 "      [reading "
				    fname
				    "]" #\Newline)
			   (try (let* ((Envs (input-obj port))
				       (dummy (if (not (and (vector? Envs)
							    (=fx (vector-length Envs) 3)))
						  (error *heap-name*
							 "Corrupted heap"
							 Envs)))
				       (target (vector-ref Envs 0))
				       (Genv (vector-ref Envs 1))
				       (Tenv (vector-ref Envs 2)))
				   ;; check the target languages
				   (if (not (eq? target *target-language*))
				       (error *heap-name*
					      "Target language mismatch"
					      (cons target *target-language*)))
				   (close-binary-port port)
				   (set-genv! Genv)
				   ;; for class handling see the not set
				   ;; for add-Tenv!:
				   ;; @ref restore.scm:heap class handling@
				   (set-tenv! Tenv)
				   (if (and (not *call/cc?*)
					    (not (eq? *target-language* 'jvm)))
				       (unbind-call/cc!))
				   ;; in jvm mode, we have to propagate
				   ;; the package/module association
				   (if (eq? *target-language* 'jvm)
				       (for-each-global!
					(lambda (new)
					   (add-qualified-type!
					    (global-module new)
					    (global-jvm-type-name new)))))
				   #t)
				handler))))
		 (begin
		    (error "restore-heap"
			   (string-append "Cannot open heap file \""
					  *heap-name* "\"")
			   *lib-dir*)
		    (exit-bigloo -5)))))
       #f))

;*---------------------------------------------------------------------*/
;*    unbind-call/cc! ...                                              */
;*---------------------------------------------------------------------*/
(define (unbind-call/cc!)
   (if (find-global/module 'call/cc '__r4_control_features_6_9)
       (unbind-global! 'call/cc '__r4_control_features_6_9))
   (if (find-global/module 'call-with-current-continuation
			   '__r4_control_features_6_9)
       (unbind-global! 'call-with-current-continuation
		       '__r4_control_features_6_9)))

;*---------------------------------------------------------------------*/
;*    restore-additional-heaps ...                                     */
;*---------------------------------------------------------------------*/
(define (restore-additional-heaps)
   (if (pair? *additional-heap-names*)
       (begin
	  (pass-prelude "Library")
	  (for-each restore-additional-heap
		    (reverse *additional-heap-names*)))))

;*---------------------------------------------------------------------*/
;*    restore-additional-heap ...                                      */
;*---------------------------------------------------------------------*/
(define (restore-additional-heap heap)
   (let ((fname (find-file/path heap *lib-dir*)))
      (if (string? fname)
	  (let* ((port    (open-input-binary-file fname))
		 (handler (lambda (escape proc mes obj)
			     (notify-error proc mes obj)
			     (close-binary-port port)
			     (exit-bigloo -6))))
	     (if (not (binary-port? port))
		 (begin
		    (error "restore-additional-heap"
			   (string-append "Cannot open heap file \""
					  fname "\"")
			   *lib-dir*)
		    (exit-bigloo -6))
		 (begin
		    (verbose 2 "      [reading "
			     fname
			     "]" #\Newline)
		    (try (let* ((Envs     (input-obj port))
				(dummy    (if (not (and (vector Envs)
							(=fx (vector-length Envs)
							     4)))
					      (error heap
						     "Corrupted heap"
						     Envs)))
				(target   (vector-ref Envs 0))
				(Genv     (vector-ref Envs 1))
				(Tenv     (vector-ref Envs 2))
				(includes (vector-ref Envs 3)))
			    ;; check the target languages
			    (if (not (eq? target *target-language*))
				       (error heap
					      "Target language mismatch"
					      (cons target *target-language*)))
			    (close-binary-port port)
			    ;; @label heap class handling@
			    ;; The function add-Tenv! manages the importation
			    ;; of class definitions. That is, if the additional
			    ;; heap contains class definition, add-Tenv! will
			    ;; create the accessors for that classes. Note
			    ;; that set-Tenv! *doesn't* do the same job, it
			    ;; supposes that the class doesn't contains classes
			    [assert (Tenv) (hashtable? Tenv)]
			    [assert (Genv) (hashtable? Genv)]
			    (add-tenv! Tenv)
			    (add-genv! Genv)
			    (set! *additional-include-foreign*
				  (append *additional-include-foreign*
					  includes))
			    #t)
			 handler))))
	  (begin
	     (error "restore-additional-heap"
		    (string-append "Cannot open heap file \"" heap "\"")
		    *lib-dir*)
	     (exit-bigloo -6)))))


