;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Jvm/jld.scm                 */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Oct 24 10:32:46 2000                          */
;*    Last change :  Mon Oct  8 19:56:07 2001 (serrano)                */
;*    Copyright   :  2000-01 Manuel Serrano                            */
;*    -------------------------------------------------------------    */
;*    The pseudo Jvm link (generation of a script shell that will run  */
;*    the application).                                                */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module jvm_ld
   (import engine_param
	   engine_configure
	   engine_link
	   tools_speek
	   tools_error
	   read_reader
	   module_module
	   ast_var
	   type_type)
   (export (jvm-ld)))

;*---------------------------------------------------------------------*/
;*    jvm-ld ...                                                       */
;*---------------------------------------------------------------------*/
(define (jvm-ld)
   (let* ((target (if (string? *dest*)
		      *dest*
		      bgl-configure-a.bat))
	  (path (find-path *o-files*))
	  (jarname (string-append (prefix target) ".jar")))
      (verbose 1 "   . ld")
      (verbose 2 " (" target ")")
      (verbose 1 #\Newline)
      (if *jvm-jar?*
	  (let* ((manifest (make-manifest-name))
		 (o-files (append (map (lambda (s)
					  (string-append (prefix s) ".class"))
				       *src-files*)
				  *o-files*))
		 (all-objects (objects->classes o-files)))
	     (generate-jvm-manifest manifest (find-jvm-main o-files) jarname)
	     (jvm-jar jarname manifest all-objects)))
      (generate-jvm-script target (prefix (car *src-files*)) path jarname)))

;*---------------------------------------------------------------------*/
;*    find-path ...                                                    */
;*---------------------------------------------------------------------*/
(define (find-path o-files)
   (let loop ((o-files o-files)
	      (res '()))
      (if (null? o-files)
	  res
	  (let ((dir (dirname (car o-files))))
	     (cond
		((string=? dir "")
		 (loop (cdr o-files)
		       res))
		((member dir res)
		 (loop (cdr o-files)
		       res))
		(else
		 (loop (cdr o-files)
		       (cons dir res))))))))

;*---------------------------------------------------------------------*/
;*    find-jvm-main ...                                                */
;*---------------------------------------------------------------------*/
(define (find-jvm-main o-files)
   (if (global? *main*)
       (prefix (car *src-files*))
       (try (let loop ((o-files o-files))
	       (if (null? o-files)
		   (error "jar" "No main clause found" o-files)
		   (let* ((pref (unprof-src-name (prefix (car o-files))))
			  (bpref    (basename pref))
			  (scm-file (find-src-file pref bpref)))
		      (if (or (not (string? scm-file))
			      (not (file-exists? scm-file)))
			  (loop (cdr o-files))
			  (or (with-input-from-file scm-file
				 (lambda ()
				    (match-case (compiler-read)
				       ((module ?- ??- (main ?-) . ?-)
					(prefix scm-file))
				       (else #f) )))
			      (loop (cdr o-files)))))))
	    (lambda (escape obj proc msg)
	       (notify-error obj proc msg)
	       (error "jar" "Can't find Main JVM class" o-files)
	       (exit 1)))))

;*---------------------------------------------------------------------*/
;*    objects->classes ...                                             */
;*---------------------------------------------------------------------*/
(define (objects->classes objects)
   (define (untype-ident id)
      (let* ((string (symbol->string id))
	     (len    (string-length string)))
	 (let loop ((walker  0))
	    (cond
	       ((=fx walker len)
		id)
	       ((and (char=? (string-ref string walker) #\:)
		     (<fx walker (-fx len 1))
		     (char=? (string-ref string (+fx walker 1)) #\:))
		(string->symbol (substring string 0 walker)))
	       (else
		(loop (+fx walker 1)))))))
   (define (mangle sname)
      (if (bigloo-need-mangling? sname)
	  (bigloo-mangle sname)
	  sname))
   (define (find-classes::pair-nil mod::symbol base clauses)
      (let loop ((clauses clauses)
		 (classes '()))
	 (if (null? clauses)
	     classes
	     (match-case (car clauses)
		(((or export static) . ?statexp)
		 (let liip ((statexp statexp)
			    (classes classes))
		    (if (null? statexp)
			(loop (cdr clauses)
			      classes)
			(match-case (car statexp)
			   (((or class abstract-class final-class wide-class)
			     ?ident . ?-)
			    (let* ((id (untype-ident ident))
				   (sid (string-append (symbol->string mod)
						       "_K"
						       (symbol->string id)))
				   (mgl (mangle sid)))
			       (liip (cdr statexp)
				     (cons (make-file-name
					    base
					    (string-append mgl ".class"))
					   classes))))
			   (else
			    (liip (cdr statexp)
				  classes))))))
		(else
		 (loop (cdr clauses) classes))))))
   (define (source->classes::pair-nil source)
      (if (and (not (string=? (suffix source) "mco"))
	       (file-exists? source))
	  (with-input-from-file source
	     (lambda ()
		(try (match-case (read)
			((module ?mod . ?clauses)
			 (find-classes mod (dirname source) clauses))
			(else
			 '()))
		     (lambda (escape obj proc msg)
			(escape '())))))
	  '()))
   (let loop ((objects objects)
	      (classes '()))
      (if (null? objects)
	  classes
	  (let* ((object (car objects))
		 (pref (unprof-src-name (prefix object)))
		 (bpref (basename pref))
		 (scm-file (find-src-file pref bpref)))
	     (if (and (string? scm-file) (file-exists? scm-file))
		 (loop (cdr objects)
		       (cons object
			     (append (source->classes scm-file) classes)))
		 (loop (cdr objects)
		       (cons object classes)))))))

;*---------------------------------------------------------------------*/
;*    jvm-jar ...                                                      */
;*---------------------------------------------------------------------*/
(define (jvm-jar target manifest objects)
   (let ((cmd (let loop ((objects objects)
			 (cmd ""))
		 (if (null? objects)
		     (string-append bgl-configure-jar " "
				    manifest " "
				    target " " cmd)
		     (loop (cdr objects)
			   (string-append (car objects) " " cmd))))))
      (verbose 2 "      [" cmd #"]\n")
      (unwind-protect
	 (if (not (=fx (system cmd) 0))
	     (error bgl-configure-jar "Can't create jar file" target)
	     #t)
	 (delete-file manifest))))

;*---------------------------------------------------------------------*/
;*    make-manifest-name ...                                           */
;*---------------------------------------------------------------------*/
(define (make-manifest-name)
   (let loop ((name "Manifest"))
      (if (not (file-exists? name))
	  name
	  (loop (string-append name "X")))))

;*---------------------------------------------------------------------*/
;*    jvm-classpath ...                                                */
;*---------------------------------------------------------------------*/
(define (jvm-classpath)
   (if (string? *jvm-classpath*)
       *jvm-classpath*
       bgl-configure-zip-directory))

;*---------------------------------------------------------------------*/
;*    jvm-jarpath ...                                                  */
;*---------------------------------------------------------------------*/
(define (jvm-jarpath path)
   (if (string? *jvm-jarpath*)
       *jvm-jarpath*
       path))

;*---------------------------------------------------------------------*/
;*    generate-jvm-manifest ...                                        */
;*---------------------------------------------------------------------*/
(define (generate-jvm-manifest fname::bstring main jarname::bstring)
   (cond
      ((string=? *jvm-shell* "sh")
       (generate-sh-jvm-manifest fname main))
      ((string=? *jvm-shell* "msdos")
       (generate-msdos-jvm-manifest fname main jarname))
      (else
       (warning "generate-jvm-manifest"
		"Illegal shell `" *jvm-shell* "' -- using `sh'")
       (generate-sh-jvm-manifest fname main))))

;*---------------------------------------------------------------------*/
;*    generate-sh-jvm-manifest ...                                     */
;*---------------------------------------------------------------------*/
(define (generate-sh-jvm-manifest fname main)
   (with-output-to-file fname
      (lambda ()
	 (print "Manifest-Version: 1.0")
	 (print "Main-Class: " main)
	 (display "Class-Path: . ")
	 (display (make-file-name (jvm-classpath)
				  (if *unsafe-library*
				      "bigloo_u.zip"
				      "bigloo.zip")))
	 (for-each (lambda (l)
		      (display " ")
		      (display (user-library l)))
		   *additional-bigloo-zips*)
	 (newline)
	 (print "Created-By: " *bigloo-name*)
	 (newline))))

;*---------------------------------------------------------------------*/
;*    generate-msdos-jvm-manifest ...                                  */
;*---------------------------------------------------------------------*/
(define (generate-msdos-jvm-manifest fname main jarname)
   (with-output-to-file fname
      (lambda ()
	 (print "Manifest-Version: 1.0")
	 (print "Main-Class: " main)
	 (print "Created-By: " *bigloo-name*)
	 (newline))))

;*---------------------------------------------------------------------*/
;*    generate-jvm-sh-script ...                                       */
;*---------------------------------------------------------------------*/
(define (generate-jvm-sh-script target main-class path)
   (define (generate-jvm-env)
      (let loop ((env *jvm-env*)
		 (res ""))
	 (if (null? env)
	     res
	     (loop (cdr env)
		   (string-append "-Dbigloo." (car env) "=$" (car env)
				  " " res)))))
   (define (generate-jvm-jar-script)
      (with-output-to-file target
	 (lambda ()
	    (print "#!/bin/sh")
	    (newline)
	    (print *jvm-java* " $BIGLOOJAVAOPT " bgl-configure-jflags
		   (if (not *jvm-purify*) bgl-configure-jvflags "")
		   " -jar "
		   *jvm-options* " "
		   (generate-jvm-env)
		   (if (not (string=? bgl-configure-dirname-cmd ""))
		       (make-file-name (string-append "`"
						      bgl-configure-dirname-cmd
						      " $0`")
				       (prefix (basename target)))
		       (prefix target))
		   ".jar $0 $*")))
      (chmod target 'read 'write 'execute))
   (define (generate-jvm-class-script)
      (with-output-to-file target
	 (lambda ()
	    (print "#!/bin/sh")
	    (newline)
	    (print "CLASSPATH="
		   (list->sh-path-string
		    `("."
		      ,@path
		      "$BIGLOOCLASSPATH"
		      ,(make-file-name (jvm-classpath)
				       (if *unsafe-library*
					   "bigloo_u.zip"
					   "bigloo.zip"))
		      ,@(map user-library *additional-bigloo-zips*))))
	    (print "export CLASSPATH")
	    (newline)
	    (print *jvm-java* " $BIGLOOJAVAOPT " bgl-configure-jflags
		   (if (not *jvm-purify*) bgl-configure-jvflags "")
		   " "
		   *jvm-options* " "
		   (generate-jvm-env)
		   (string-replace! main-class #\/ #\.)
		   " $0 $*")))
      (chmod target 'read 'write 'execute))
   (if *jvm-jar?*
       (generate-jvm-jar-script)
       (generate-jvm-class-script)))

;*---------------------------------------------------------------------*/
;*    generate-jvm-msdos-script ...                                    */
;*---------------------------------------------------------------------*/
(define (generate-jvm-msdos-script target main-class path jarname)
   (define (generate-jvm-env)
      (let loop ((env *jvm-env*)
		 (res ""))
	 (if (null? env)
	     res
	     (loop (cdr env)
		   (string-append "-Dbigloo." (car env) "=$" (car env)
				  " " res)))))
   (define (generate-jvm-jar-script)
      (with-output-to-file target
	 (lambda ()
	    (print "@echo off")
	    (newline)
	    (print "set BIGLOO_CLASSPATH="
		   (list->msdos-path-string
		    `(,(string-append (jvm-jarpath (dirname jarname))
				      "\\"
				      (basename jarname))
		      ,(string-append (string-replace!
				       (string-copy (jvm-classpath))
				       #\/ #\\)
				      (if *unsafe-library*
					  "\\bigloo_u.zip"
					  "\\bigloo.zip"))
		      ,@(map (lambda (x)
				(string-replace! (user-library x) #\/ #\\))
			     *additional-bigloo-zips*))))
	    (print *jvm-java* " %BIGLOOJAVAOPT% " bgl-configure-jflags
		   (if (not *jvm-purify*) bgl-configure-jvflags "")
		   " -cp %BIGLOO_CLASSPATH% "
		   *jvm-options* " "
		   (generate-jvm-env)
		   (string-replace! main-class #\/ #\.)
		   " %0 %*")))
      (chmod target 'read 'write 'execute))
   (define (generate-jvm-class-script)
      (with-output-to-file target
	 (lambda ()
	    (print "@echo off")
	    (newline)
	    (print "set BIGLOO_CLASSPATH="
		   (list->msdos-path-string
		    `("."
		      ,@path
		      ,(string-append (string-replace!
				       (string-copy (jvm-classpath))
				       #\/ #\\)
				      (if *unsafe-library*
					  "\\bigloo_u.zip"
					  "\\bigloo.zip"))
		      ,@(map (lambda (x)
				(string-replace! (user-library x) #\/ #\\))
			     *additional-bigloo-zips*))))
	    (newline)
	    (print *jvm-java* " %BIGLOOJAVAOPT% " bgl-configure-jflags
		   (if (not *jvm-purify*) bgl-configure-jvflags "")
		   " "
		   *jvm-options*
		   " -cp %BIGLOO_CLASSPATH% "
		   (generate-jvm-env)
		   (string-replace! main-class #\/ #\.)
		   " %0 %*")))
      (chmod target 'read 'write 'execute))
   (if *jvm-jar?*
       (generate-jvm-jar-script)
       (generate-jvm-class-script)))

;*---------------------------------------------------------------------*/
;*    generate-jvm-script ...                                          */
;*---------------------------------------------------------------------*/
(define (generate-jvm-script target main-class path jarname)
   (cond
      ((string=? *jvm-shell* "sh")
       (generate-jvm-sh-script target main-class path))
      ((string=? *jvm-shell* "msdos")
       (generate-jvm-msdos-script target main-class path jarname))
      (else
       (warning "generate-jvm-script"
		"Illegal shell `" *jvm-shell* "' -- using `sh'")
       (generate-jvm-sh-script target main-class path))))

;*---------------------------------------------------------------------*/
;*    user-library ...                                                 */
;*---------------------------------------------------------------------*/
(define (user-library lib)
   (define (relative-name? lib)
      (let ((len (string-length lib)))
	 (let loop ((i 0))
	    (cond
	       ((=fx i len)
		#f)
	       ((char=? (string-ref lib i) #\/)
		#t)
	       (else
		(loop (+fx i 1)))))))
   (if (relative-name? lib)
       lib
       (make-file-name (jvm-classpath) lib)))

;*---------------------------------------------------------------------*/
;*    list->path-string ...                                            */
;*---------------------------------------------------------------------*/
(define (list->path-string path separator)
   (let ((rpath (reverse path)))
      (let loop ((path (cdr rpath))
		 (res (car rpath)))
	 (if (null? path)
	     res
	     (loop (cdr path) (string-append (car path) separator res))))))

;*---------------------------------------------------------------------*/
;*    list->sh-path-string ...                                         */
;*---------------------------------------------------------------------*/
(define (list->sh-path-string path)
   (list->path-string path ":"))

;*---------------------------------------------------------------------*/
;*    list->msdos-path-string ...                                      */
;*---------------------------------------------------------------------*/
(define (list->msdos-path-string path)
   (list->path-string path ";"))

;*---------------------------------------------------------------------*/
;*    string-replace! ...                                              */
;*---------------------------------------------------------------------*/
(define (string-replace! str from to)
   (let ((len (string-length str)))
      (let loop ((i 0))
	 (cond
	    ((=fx i len)
	     str)
	    ((char=? (string-ref str i) from)
	     (string-set! str i to)
	     (loop (+fx i 1)))
	    (else
	     (loop (+fx i 1)))))))
