/*---------------------------------------------------------------------*/
/*    serrano/prgm/project/bigloo/runtime/Clib/init-obj.c              */
/*                                                                     */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Fri Jul 17 09:00:08 1992                          */
/*    Last change :  Sat Mar 11 09:53:42 2000 (serrano)                */
/*                                                                     */
/*    On initialise les objects vitaux                                 */
/*---------------------------------------------------------------------*/
#include <stdio.h>
#include <bigloo.h>

/*---------------------------------------------------------------------*/
/*    Les objects vitaux ...                                           */
/*---------------------------------------------------------------------*/
obj_t an_object;

obj_t quote;
obj_t *c_allocated_char;
obj_t _exit_value_;

obj_t bprof_port = BUNSPEC;

/*---------------------------------------------------------------------*/
/*    Importatations                                                   */
/*---------------------------------------------------------------------*/
extern obj_t string_to_obj();

extern void init_symbol_table();
extern void init_keyword_table();
extern void init_io();
extern void init_trace();

/*---------------------------------------------------------------------*/
/*    init_objects ...                                                 */
/*---------------------------------------------------------------------*/
void init_objects()
{
   /* l'initialisation des traces */
   init_trace();
   
   /* l'initialisation des symbols */
   init_symbol_table();

   /* l'initialisation des ports d'entree/sortie */
   init_io();

   /* the dsssl keywords initialization */
   init_keyword_table();

   /* l'initialisation du symbol QUOTE (voir apply.c) */
   quote = string_to_symbol( "QUOTE" );
   
}
