/*=====================================================================*/
/*    serrano/prgm/project/bigloo/runtime/Jlib/process.java            */
/*    -------------------------------------------------------------    */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Fri Dec  8 07:55:39 2000                          */
/*    Last change :  Sat Jul 14 07:02:50 2001 (serrano)                */
/*    Copyright   :  2000-01 Manuel Serrano                            */
/*    -------------------------------------------------------------    */
/*    The simplified JVM Bigloo process implementation.                */
/*=====================================================================*/
package bigloo;
import bigloo.*;
import java.lang.Process;
import java.io.*;

/*---------------------------------------------------------------------*/
/*    PROCESS ...                                                      */
/*---------------------------------------------------------------------*/
public class process extends obj {
/*--- static fields ---------------------------------------------------*/
    static obj all_processes = bigloo.nil.nil;
    static int MAX_PROC_NUM = 255;
    static Object[] proc_arr;
   
/*--- non static fields -----------------------------------------------*/
    Process process = null;
    int index;
    obj input_port, output_port, error_port;

/*--- class constructor -----------------------------------------------*/
    static {
	int i;
	byte[] env = foreign.getenv( "BIGLOOLIVEPROCESS".getBytes() );

	if( env != null ) {
	    int num = foreign.parseint( env, 0, env.length, 10 );

	    if( num > 0 )
		MAX_PROC_NUM = num;
	}
	proc_arr = new Object[ MAX_PROC_NUM ];
      
	for( i = 0; i < MAX_PROC_NUM; i++ ) 
	    proc_arr[ i ] = bigloo.foreign.BUNSPEC;
    }

/*--- instance constructor --------------------------------------------*/
    process( byte[] host, boolean fork, boolean waiting, 
	     Object binput, Object boutput, Object berror,
	     byte[] bcommand, Object bargs, Object benv ) throws IOException {
	String cmd = new String();
	String[] argv = new String[ 3 ];
	String[] envp = null;
	Object aux;
	int env_len = 0;

	// we purge the process table and ask for a new index */
	PURGE_PROCESS_TABLE();
	index = find_process();
	if( index < 0 )
	    bigloo.runtime.Llib.error.the_failure("make-process".getBytes(),
						  "too many processes".getBytes(), 
						  bigloo.foreign.BUNSPEC );
	   

	// append the command arguments
	while( bargs instanceof pair ) {
	    cmd = cmd + " " + new String( (byte[])(((pair)bargs).car) );
	    bargs = ((pair)bargs).cdr;
	}

	// the re-directions
	if( !(binput instanceof keyword) ) {
	    input_port = bigloo.foreign.BFALSE;
	    if( binput instanceof byte[] )
		cmd = "< " + new String( (byte[])binput ) + cmd;
	}

	if( !(boutput instanceof keyword) ) {
	    output_port = bigloo.foreign.BFALSE;
	    if( boutput instanceof byte[] )
		cmd = "> " + new String( (byte[])boutput ) + cmd;
	}

	if( !(berror instanceof keyword) ) {
	    error_port = bigloo.foreign.BFALSE;
	    if( berror instanceof byte[] )
		cmd = "2> " + new String( (byte[])berror ) + cmd;
	}

	// the command
	cmd = new String( bcommand ) + cmd;

	// rsh initialization
	if( host != null ) {
	    argv[ 0 ] = "rsh";
	    argv[ 1 ] = new String( host );
	} else {
	    argv[ 0 ] = "sh";
	    argv[ 1 ] = "-c";
	}
      
	argv[ 2 ] = cmd;

	if( !fork ) {
	    System.err.println( "***WARNING: Can't run process without forking with the JVM back-end" );
	}

	// Construct the process environment variable list
	aux = benv;
	while( aux instanceof pair ) {
	    env_len++;
	    aux = ((pair)aux).cdr;
	}
	envp = new String[ env_len ];
	aux = benv;
	env_len = 0;
	while( aux instanceof pair ) {
	    envp[ env_len ] = new String((byte[])(((pair)aux).car));
	    env_len++;
	    aux = ((pair)aux).cdr;
	}

	// we create the system process
	process = Runtime.getRuntime().exec( argv, envp );

	// the re-directions
	if( binput instanceof keyword ) {
	    input_port = new output_port( process.getOutputStream(), bcommand );
	}

	if( boutput instanceof keyword ) {
	    output_port = new input_pipe_port( process.getInputStream(), bcommand );
	}

	if( berror instanceof keyword ) {
	    error_port = new input_pipe_port( process.getErrorStream(), bcommand );
	}

	// and we store the Java object into the process table
	proc_arr[ index ] = this;

	// if the output ports are not redirected to files or pipes, we
	// have to flush the input stream
	if( (boutput == bigloo.foreign.BUNSPEC) && 
	    (berror == bigloo.foreign.BUNSPEC) ) {
	    new flusher( process ).flush();
	} else {
	    if( (boutput == bigloo.foreign.BUNSPEC) ) {
		new flusher( process.getInputStream(), null ).flush();
	    } else {
		if( (berror == bigloo.foreign.BUNSPEC) ) {
		    new flusher( null, process.getErrorStream() ).flush();
		}
	    }
	}

	// if requested, we wait for the process completion
	if( waiting ) {
	    try {
		process.waitFor();
	    }
	    catch( InterruptedException e ) { ; }
	}
    }

/*--- private static methods ------------------------------------------*/
    private static void PURGE_PROCESS_TABLE() {
	int i;

	for( i = 0; i < MAX_PROC_NUM; i++ ) {
	    Object proc;

	    proc = proc_arr[ i ];
	    if( (proc instanceof process) && !((process)proc).alivep() )
		proc_arr[ i ] = bigloo.foreign.BUNSPEC;
	}
    }

    private static int find_process() {
	int i;

	for( i = 0; i < MAX_PROC_NUM; i++ )
	    if( proc_arr[ i ] == bigloo.foreign.BUNSPEC )
		return i;
	return -1;
    }

/*--- public static methods -------------------------------------------*/
    public static obj process_list() {
	int i;
	obj lst = (obj)bigloo.foreign.BNIL;

	PURGE_PROCESS_TABLE();
      
	for( i = 0; i < MAX_PROC_NUM; i++ ) 
	    if( proc_arr[ i ] != bigloo.foreign.BUNSPEC )
		lst = bigloo.pair.cons( proc_arr[ i ], lst );
      
	return lst;
    }

/*--- public methods --------------------------------------------------*/
    public int pid() {
	return -1;
    }

    public boolean alivep() {
	try {
	    process.exitValue();
	} 
	catch( IllegalThreadStateException e ) {
	    return true;
	}
	return false;
    }

    public int xstatus() {
	try {
	    return process.exitValue();
	} 
	catch( IllegalThreadStateException e ) {
	    return -1;
	}
    }

    public obj kill() {
	process.destroy();
	return (obj)bigloo.foreign.BUNSPEC;
    }

    public obj waitfor() {
	try {
	    process.waitFor();
	}
	catch( InterruptedException e ) { ; }

	return (obj)bigloo.foreign.BUNSPEC;
    }

    public obj stop() {
	System.err.println( "***WARNING: Can't stop a process using the JVM back-end" );
	return (obj)bigloo.foreign.BUNSPEC;
    }
	
    public obj cont() {
	System.err.println( "***WARNING: Can't continue a process using the JVM back-end" );
	return (obj)bigloo.foreign.BUNSPEC;
    }
    public obj send_signal( int s ) {
	System.err.println( "***WARNING: Can't send signal to process using the JVM back-end" );
	return (obj)bigloo.foreign.BUNSPEC;
    }
}

