/*=====================================================================*/
/*    serrano/prgm/project/bigloo/runtime/Jlib/socket.java             */
/*    -------------------------------------------------------------    */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Tue Dec  5 10:53:03 2000                          */
/*    Last change :  Sat Jul 14 06:50:11 2001 (serrano)                */
/*    Copyright   :  2000-01 Manuel Serrano                            */
/*    -------------------------------------------------------------    */
/*    The Socket implementation for the JVM back-end.                  */
/*=====================================================================*/
package bigloo;

import java.io.*;
import java.net.*;

/*---------------------------------------------------------------------*/
/*    SOCKET ...                                                       */
/*---------------------------------------------------------------------*/
public abstract class socket extends obj {
/*--- public fields ---------------------------------------------------*/
    Object socket;
    public obj input, output;

/*--- protected fields ------------------------------------------------*/
    protected boolean down = false;
    
/*--- constructors ----------------------------------------------------*/
    protected socket() {
	input = bigloo.foreign.BFALSE;
	output = bigloo.foreign.BFALSE;
    }

/*--- private methods -------------------------------------------------*/
    protected void socket_error( String s1, String s2, Object o ) {
	foreign.fail( s1, s2, o );
    }

    protected void set_socket_io_ports( Socket client, boolean b ) throws IOException {
       input = new input_socket_port( client.getInputStream(), b );
       // CARE must be buffered !?
       output = new output_port( client.getOutputStream() );
    }

/*--- public methods --------------------------------------------------*/
    public boolean DOWNP() {
	return down;
    }

/*--- public abstract methods -----------------------------------------*/
    public abstract byte[] HOSTNAME();
    public abstract byte[] HOSTIP();
    public abstract Object shutdown(boolean _) throws IOException;
    public abstract int PORT();
}
