;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime/Llib/foreign.scm             */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Jul  5 16:50:26 1995                          */
;*    Last change :  Sun Jun 24 19:31:13 2001 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The foreign object management.                                   */
;*    -------------------------------------------------------------    */
;*    Source documentation:                                            */
;*       @path ../../manuals/foreign.texi@                             */
;*       @node Foreign Interface@                                      */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __foreign
   
   (import  __error)
   
   (use     __type
	    __bigloo
	    __tvector
	    __structure
	    __r4_equivalence_6_2
	    __r4_vectors_6_8
	    __r4_booleans_6_1
	    __r4_pairs_and_lists_6_3
	    __r4_control_features_6_9
	    __r4_strings_6_7
	    __r4_symbols_6_4
	    __r4_numbers_6_5_fixnum
	    __evenv)
   
   (extern  (macro c-foreign?::bool (::obj) "FOREIGNP")
	    (macro c-foreign-null?::bool (::obj) "FOREIGN_NULLP")
	    (macro c-foreign-eq?::bool (::foreign ::foreign) "FOREIGN_EQP")
	    (macro foreign-id::symbol (::foreign) "FOREIGN_ID")
	    (macro %string-ptr-null?::bool (::string) "STRING_PTR_NULL")
	    (macro %void*-ptr-null?::bool (::void*) "FOREIGN_PTR_NULL"))
   
   (java    (class foreign
	       (method static c-foreign?::bool (::obj)
		       "FOREIGNP")
 	       (method static c-foreign-null?::bool (::obj)
		       "FOREIGN_NULLP")
	       (method static c-foreign-eq?::bool (::obj ::obj)
		       "FOREIGN_EQP")
	       (method static foreign-id::symbol (::obj)
		       "FOREIGN_ID")
	       (method static %string-ptr-null?::bool (::string)
		       "STRING_PTR_NULL")
	       (method static %void*-ptr-null?::bool (::void*)
		       "OBJECT_PTR_NULL")))
   
   (export  (inline foreign?::bool ::obj)
	    (inline foreign-eq?::bool ::obj ::obj)
	    (inline foreign-null?::bool ::obj)
	    (inline string-ptr-null?::bool ::string)
	    (inline obj->cobj::cobj ::obj)
	    (inline void*-null?::bool ::void*))
   
   (pragma  (c-foreign? (predicate-of foreign) no-cfa-top nesting)
	    (foreign? (predicate-of foreign) no-cfa-top nesting)
	    (c-foreign-null? side-effect-free no-cfa-top nesting)
	    (foreign-null? side-effect-free no-cfa-top nesting)
	    (c-foreign-eq? side-effect-free no-cfa-top nesting)
	    (foreign-eq? side-effect-free no-cfa-top nesting)
	    (string-ptr-null? side-effect-free no-cfa-top nesting)
	    (void*-null? side-effect-free no-cfa-top nesting)
	    (obj->cobj side-effect-free)))
 
;*---------------------------------------------------------------------*/
;*    foreign? ...                                                     */
;*---------------------------------------------------------------------*/
(define-inline (foreign? obj)
   (c-foreign? obj))

;*---------------------------------------------------------------------*/
;*    foreign-eq? ...                                                  */
;*---------------------------------------------------------------------*/
(define-inline (foreign-eq? o1 o2)
   (c-foreign-eq? o1 o2))

;*---------------------------------------------------------------------*/
;*    foreign-null? ...                                                */
;*---------------------------------------------------------------------*/
(define-inline (foreign-null? obj)
   (if (foreign? obj)
       (c-foreign-null? obj)
       (error "foreign-null?" "not a foreign object" obj)))

;*---------------------------------------------------------------------*/
;*    @deffn string-ptr-null?@ ...                                     */
;*---------------------------------------------------------------------*/
(define-inline (string-ptr-null? obj::string)
   (%string-ptr-null? obj))
 
;*---------------------------------------------------------------------*/
;*    obj->cobj ...                                                    */
;*---------------------------------------------------------------------*/
(define-inline (obj->cobj obj)
   (c-obj->cobj obj))

;*---------------------------------------------------------------------*/
;*    void*-null? ...                                                  */
;*---------------------------------------------------------------------*/
(define-inline (void*-null? obj::void*)
   (%void*-ptr-null? obj))
