;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime/Llib/socket.scm              */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Jun 29 18:45:17 1998                          */
;*    Last change :  Sat Jul 14 06:42:47 2001 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Socket handling. This poart is mostly compatible with            */
;*    STk. This code is extracted from STk by Erick Gallesio.          */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __socket

   (import  __error)
   
   (use     __type
	    __bigloo
	    __tvector
	    __ucs2
	    __dsssl
	    
	    __r4_numbers_6_5_fixnum
	    __r4_equivalence_6_2
	    __r4_vectors_6_8
	    __r4_booleans_6_1
	    __r4_characters_6_6
	    __r4_symbols_6_4
	    __r4_pairs_and_lists_6_3
	    __r4_strings_6_7
	    __r4_ports_6_10_1
	    __r4_control_features_6_9

	    __evenv)
 
   (extern  (macro c-socket?::bool            (::obj)    "SOCKETP")
	    (macro c-socket-hostname::bstring (::socket) "SOCKET_HOSTNAME")
	    (macro c-socket-hostip::bstring   (::socket) "SOCKET_HOSTIP")
	    (macro c-socket-down?::bool       (::socket) "SOCKET_DOWNP")
	    (macro c-socket-port-number::int  (::socket) "SOCKET_PORT")
	    (macro c-socket-input::obj        (::socket) "SOCKET_INPUT")
	    (macro c-socket-output::obj       (::socket) "SOCKET_OUTPUT")
	    
	    (c-make-client-socket::socket    (::bstring ::int ::bool)
					     "make_client_socket")
	    (c-make-server-socket::socket    (::int)
					     "make_server_socket")
	    (c-socket-accept-connection::obj (::socket ::bool)
					     "socket_accept_connection")
	    (c-socket-local-addr::bstring    (::socket)
					     "socket_local_addr")
	    (c-socket-dup::socket            (::socket)
					     "socket_dup")
	    (c-socket-shutdown::obj          (::socket ::bool)
					     "socket_shutdown"))

   (java    (class foreign
	       (method static c-socket?::bool (::obj)
		       "SOCKETP")
	       
	       (method static c-socket-dup::socket (::socket)
		       "socket_dup")
	       (method static c-make-client-socket::socket (::bstring ::int ::bool)
		       "make_client_socket")
	       (method static c-make-server-socket::socket (::int)
		       "make_server_socket")
	       
	       (method static c-socket-hostname::bstring (::socket)
		       "SOCKET_HOSTNAME")
	       (method static c-socket-hostip::bstring (::socket)
		       "SOCKET_HOSTIP")
	       (method static c-socket-down?::bool (::socket)
		       "SOCKET_DOWNP")
	       (method static c-socket-port-number::int (::socket)
		       "SOCKET_PORT")
	       (method static c-socket-input::obj (::socket)
		       "SOCKET_INPUT")
	       (method static c-socket-output::obj (::socket)
		       "SOCKET_OUTPUT")
	       
	       (method static c-socket-accept-connection::obj (::socket ::bool)
		       "socket_accept_connection")
	       (method static c-socket-local-addr::bstring (::socket)
		       "socket_local_addr")
	       (method static c-socket-shutdown::obj (::socket ::bool)
		       "socket_shutdown")))

   (export  (inline socket?::bool ::obj)
	    (inline socket-hostname::bstring ::socket)
	    (inline socket-host-address::bstring ::socket)
	    (inline socket-down?::bool ::socket)
	    (inline socket-port-number::bint ::socket)
	    (inline socket-input::obj ::socket)
	    (inline socket-output::obj ::socket)
	    (inline make-client-socket::socket ::bstring ::int . opt)
	    (inline make-server-socket::socket . port-number)
	    (inline socket-accept-connection ::socket . opt)
	    (inline socket-local-address ::socket)
	    (inline socket-dup::socket ::socket)
	    (inline socket-shutdown::obj ::socket . close))

   (pragma  (c-socket? nesting)
	    (c-socket-hostname nesting)
	    (c-socket-hostip nesting)
	    (c-socket-down? nesting)
	    (c-socket-port-number nesting)
	    (c-socket-input nesting)
	    (c-socket-output nesting)))

;*---------------------------------------------------------------------*/
;*    socket? ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (socket? obj)
   (c-socket? obj))

;*---------------------------------------------------------------------*/
;*    socket-hostname ...                                              */
;*---------------------------------------------------------------------*/
(define-inline (socket-hostname::bstring socket::socket)
   (c-socket-hostname socket))

;*---------------------------------------------------------------------*/
;*    socket-host-address ...                                          */
;*---------------------------------------------------------------------*/
(define-inline (socket-host-address::bstring socket::socket)
   (c-socket-hostip socket))

;*---------------------------------------------------------------------*/
;*    socket-down? ...                                                 */
;*---------------------------------------------------------------------*/
(define-inline (socket-down?::bool socket::socket)
   (c-socket-down? socket))

;*---------------------------------------------------------------------*/
;*    socket-port-number ...                                           */
;*---------------------------------------------------------------------*/
(define-inline (socket-port-number::bint socket::socket)
   (c-socket-port-number socket))

;*---------------------------------------------------------------------*/
;*    socket-input ...                                                 */
;*---------------------------------------------------------------------*/
(define-inline (socket-input socket::socket)
   (c-socket-input socket))

;*---------------------------------------------------------------------*/
;*    socket-output ...                                                */
;*---------------------------------------------------------------------*/
(define-inline (socket-output socket::socket)
   (c-socket-output socket))

;*---------------------------------------------------------------------*/
;*    make-client-socket ...                                           */
;*---------------------------------------------------------------------*/
(define-inline (make-client-socket::socket hostname port-number . buffered)
   (c-make-client-socket hostname
			 port-number
			 (or (null? buffered) (eq? (car buffered) #t))))

;*---------------------------------------------------------------------*/
;*    make-server-socket ...                                           */
;*---------------------------------------------------------------------*/
(define-inline (make-server-socket::socket . port-number)
   (c-make-server-socket (if (null? port-number) 0 (car port-number))))

;*---------------------------------------------------------------------*/
;*    socket-accept-connection ...                                     */
;*---------------------------------------------------------------------*/
(define-inline (socket-accept-connection socket::socket . buffered)
   (c-socket-accept-connection socket
			       (or (null? buffered) (eq? (car buffered) #t))))
	    
;*---------------------------------------------------------------------*/
;*    socket-local-address ...                                         */
;*---------------------------------------------------------------------*/
(define-inline (socket-local-address socket::socket)
   (c-socket-local-addr socket))

;*---------------------------------------------------------------------*/
;*    socket-dup ...                                                   */
;*---------------------------------------------------------------------*/
(define-inline (socket-dup::socket socket::socket)
   (c-socket-dup socket))

;*---------------------------------------------------------------------*/
;*    socket-shutdown ...                                              */
;*---------------------------------------------------------------------*/
(define-inline (socket-shutdown socket::socket . close)
   (c-socket-shutdown socket (if (pair? close) (car close)  #t)))
