/*=====================================================================*/
/*    serrano/prgm/project/bigloo/runtime/Jlib/bgldynamic.java         */
/*    -------------------------------------------------------------    */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Sat Oct 19 10:42:04 2002                          */
/*    Last change :  Sat Oct 19 15:10:49 2002 (serrano)                */
/*    Copyright   :  2002 Manuel Serrano                               */
/*    -------------------------------------------------------------    */
/*    Handling global dynamic environments (current_output_port et al) */
/*=====================================================================*/
using System;

namespace bigloo
{
  public sealed class bgldynamic 
  {
    public static bgldynamic current_dynamic_env= new bgldynamic();

    // global environment
    public Object exitd_top;
    public Object error_handler;
    public input_port current_input_port;
    public output_port current_output_port;
    public output_port current_error_port;
    public int mvalues_number;
    public readonly Object[] mvalues_values;
    // !!!!! to set up this way as soon as DotGNU compiler allows doing so.
    // = { unspecified._unspecified, unspecified._unspecified, unspecified._unspecified, unspecified._unspecified };

    // constructor
    public bgldynamic()
    {
      mvalues_values= new Object[4];

      for ( int i= 0 ; i < 4 ; ++ i)
        mvalues_values[i]= unspecified._unspecified;

      exitd_top= new exit();
      error_handler= nil._nil;

      mvalues_number= 1;

      current_input_port= new input_console_port( foreign.default_io_bufsiz );
      current_output_port= new output_stream_port( Console.OpenStandardOutput() );    // !!!!! to check
      current_error_port= new output_stream_port( Console.OpenStandardError() );      // !!!!! to check

      error_handler= bigloo.nil._nil;
    }

    // constructor
    public bgldynamic( bgldynamic  o ) 
    {
      mvalues_values= new Object[4];

      for ( int i= 0 ; i < 4 ; ++ i)
        mvalues_values[i]= unspecified._unspecified;

      exitd_top= new exit();
      error_handler= nil._nil;

      mvalues_number= 1;

      current_input_port= o.current_input_port;
      current_output_port= o.current_output_port;
      current_error_port= o.current_error_port;
    }
  }
}
